/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremX3ServiceOptionManager=void 0,exports.getSizingFromActivityCode=getSizingFromActivityCode;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),sys_activity_code_1=require("../nodes/sys-activity-code"),logger=xtrem_core_1.Logger.getLogger(__filename,"service-option-manager");class XtremX3ServiceOptionManager extends xtrem_core_1.ServiceOptionManager{async isServiceOptionEnabled(e,t){if(t.code){const i=!!(await this.getEnabledServiceOptions(e)).find(e=>typesLib.strictEq(e.code,t.code));return e.logger.debug(()=>`The activity code ${t.code} is ${i?"":"not "}active`),i}return false}setServiceOptionActiveState(){return Promise.resolve()}async getLanguageFromLocale(e,t){const i=xtrem_core_1.Context.localizationManager;if(!i.getLanguageFromLocale||typesLib.strictEq(e.globals.localizationManagerBusy,true))return{language:"ENG",defaultLanguage:"ENG"};e.globals.localizationManagerBusy=true;const a=await i.getLanguageFromLocale(e,e.currentLocale,t.toUpperCase()),r=await i.getFolderDefaultLanguage(e);return e.globals.localizationManagerBusy=false,{language:a,defaultLanguage:r}}static async getActivityCodeEtag(e){const t=await e.queryAggregate(sys_activity_code_1.SysActivityCode,{filter:{},group:{},values:{_updateStamp:{max:true}}}).at(0);if(t)return t.values._updateStamp.max;return}static async verifyActivityCodeEtag(e){const t=await XtremX3ServiceOptionManager.getActivityCodeEtag(e);if(typesLib.eq(XtremX3ServiceOptionManager.activityCodeEtag,null))return XtremX3ServiceOptionManager.activityCodeEtag=t,true;if(typesLib.eq(t,null))return false;const i=typesLib.strictEq(XtremX3ServiceOptionManager.activityCodeEtag.compare(t),0);return logger.debug(()=>`Activity code etag verification from DB: ${i}`),logger.debug(()=>`Activity code etag verification stored: ${t}`),XtremX3ServiceOptionManager.activityCodeEtag=t,i}static async verifyActivityCodeCache(e){const t=new Date;if(XtremX3ServiceOptionManager.lastCacheCheck=XtremX3ServiceOptionManager.lastCacheCheck||t,typesLib.lt(typesLib.sub(t.getTime(),XtremX3ServiceOptionManager.lastCacheCheck.getTime()),3e4))return;if(XtremX3ServiceOptionManager.lastCacheCheck=t,!await XtremX3ServiceOptionManager.verifyActivityCodeEtag(e))logger.debug(()=>"ActivityCode cache invalidation."),await e.invalidateCachedCategory("ActivityCode")}async loadCurrentLanguageCode(e){const t=e,i=await this.getLanguageFromLocale(e,xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}));t.currentLanguageCode=i.language,t.defaultLanguageCode=i.defaultLanguage}async loadSizingActivityCodes(e){const t=e;if(t.x3SizingActivityCodes)return;const getSizing=async e=>{const t=await e.databaseMinimumSize,i=await e.screenSize,a=await e.maximumSize,r=await e.type;if(typesLib.strictNe(r,"sizing"))throw new Error(`${e} invalid sizing activity code`);if(typesLib.strictEq(a,0))return typesLib.max(t,i);return typesLib.min(typesLib.max(t,i),a)};t.x3SizingActivityCodes=await e.getCachedValue({category:"ActivityCode",key:"SizingActivityCodes",getValue:async()=>{const t={};return await e.queryWithReader(sys_activity_code_1.SysActivityCode,{filter:{activeFlag:true,type:"sizing"}},e=>e.forEach(async e=>{const i=await e.code;t[i]=await getSizing(e)})),{value:t}},cacheInMemory:true,ttlInSeconds:3600})}async getEnabledServiceOptions(e){return await XtremX3ServiceOptionManager.verifyActivityCodeCache(e),await this.loadCurrentLanguageCode(e),await this.loadSizingActivityCodes(e),e.getCachedValue({category:"ActivityCode",key:"ActiveActivityCodes",getValue:async()=>{const t=[];return await e.queryWithReader(sys_activity_code_1.SysActivityCode,{filter:{activeFlag:true}},async i=>{const a=Object.values(e.application.serviceOptionsByName).filter(e=>e.code);let r=false;for(;!r;){const e=await i.read();if(r=typesLib.strictEq(e,void 0),typesLib.strictNe(e,void 0)){const i=await(0,xtrem_core_1.asyncArray)(a).find(async t=>typesLib.strictEq(t.code,await e.code));if(typesLib.ne(i,null))t.push(i)}}}),{value:t}},cacheInMemory:true,ttlInSeconds:3600})}}function getSizingFromActivityCode(e,t){const i=e.x3SizingActivityCodes[t];if(typesLib.eq(i,null))throw new Error(`${t} invalid sizing activity code`);return i}exports.XtremX3ServiceOptionManager=XtremX3ServiceOptionManager;
//# sourceMappingURL=x3-service-option-manager.js.map