import { Context, ServiceOption, ServiceOptionManager } from '@sage/xtrem-core';
export declare class XtremX3ServiceOptionManager extends ServiceOptionManager {
    isServiceOptionEnabled(context: Context, serviceOption: ServiceOption): Promise<boolean>;
    setServiceOptionActiveState(): Promise<void>;
    private getLanguageFromLocale;
    /**
     * Get the activity code etag from the database (max UPDDATTIM_0)
     * @param context
     * @returns
     */
    private static getActivityCodeEtag;
    private static activityCodeEtag;
    /**
     * Verify the activity code etag from the database
     * @param context
     * @returns
     */
    private static verifyActivityCodeEtag;
    private static lastCacheCheck;
    /**
     * Verify the activity code cache is still valid
     * @param context
     * @returns
     */
    private static verifyActivityCodeCache;
    private loadCurrentLanguageCode;
    private loadSizingActivityCodes;
    getEnabledServiceOptions(context: Context): Promise<ServiceOption[]>;
}
/**
 * Get maxRepeat of denormalized node based on sizing activity code
 * @param context
 * @param activityCode
 * @returns
 */
export declare function getSizingFromActivityCode(context: Context, activityCode: string): number;
//# sourceMappingURL=x3-service-option-manager.d.ts.map