/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3PackageManager=void 0;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"package-manager");class X3PackageManager extends xtrem_core_1.PackageManager{constructor(e){super(e),this.application=e,process.env.XTREM_USE_MULTI_WORKER=String(typesLib.strictNe(xtrem_x3_config_manager_1.X3ConfigManager.current.x3?.development?.multiWorkerServiceDisabled,true))}static async getPackageEtag(e){const a=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),r=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),t=`SELECT MAX(UPDDATTIM_0) ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias("MAX_UPDDATTIM",a.dialect)}  FROM ${r}.APACKAGE`,g=await a.execute(t);if(g.length)return g[0].MAX_UPDDATTIM;return}static async verifyPackageEtag(e){const a=await X3PackageManager.getPackageEtag(e);if(typesLib.eq(X3PackageManager.packageEtag,null))return X3PackageManager.packageEtag=a,true;const r=typesLib.strictEq(X3PackageManager.packageEtag?.getTime(),a?.getTime());return logger.debug(()=>`Package etag verification from DB: ${r}`),logger.debug(()=>`Package etag verification stored: ${a}`),X3PackageManager.packageEtag=a,r}static async verifyPackageCache(e){const a=new Date;if(X3PackageManager.lastCacheCheck=X3PackageManager.lastCacheCheck||a,typesLib.lt(typesLib.sub(a.getTime(),X3PackageManager.lastCacheCheck.getTime()),3e4))return;if(X3PackageManager.lastCacheCheck=a,!await X3PackageManager.verifyPackageEtag(e))logger.debug(()=>"Package cache invalidation."),await e.invalidateCachedCategory("Package")}async getActivePackageNames(e){await X3PackageManager.verifyPackageCache(e);const a=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),r=`${a}/ACTIVE_PACKAGES`;return e.getCachedValue({category:"Package",key:r,getValue:async()=>{if(!await xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e).tableExists("APACKAGE",a))return{value:this.application.getPackages().map(e=>e.name)};const r=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),t=`SELECT APACK_0 AS ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias("PACKAGE_NAME",r.dialect)}, ENAFLG_0 IS_ACTIVE  FROM ${a}.APACKAGE WHERE ENAFLG_0=2`,g=(await r.execute(t)).filter(e=>typesLib.strictEq(parseInt(e.IS_ACTIVE,10),2)).map(e=>e.PACKAGE_NAME);return g.push("@sage/xtrem-x3-system-utils"),g.push("@sage/xtrem-x3-interop"),g.push("@sage/xtrem-x3-copilot"),g.push("@sage/xtrem-app-metadata"),{value:g}},cacheInMemory:true,ttlInSeconds:3600})}getCurrentVersion(e,a){return Promise.resolve(e.version)}validatePackageVersions(){return Promise.resolve()}createSqlSchemaAndTables(e={}){throw new xtrem_shared_1.LogicError("X3 schema is not managed (createSqlSchemaAndTables)")}ensureSchemaExists(e={}){throw new xtrem_shared_1.LogicError("X3 schema is not managed (ensureSchemaExists)")}createOrUpgradePackageAllocations(e,a){return Promise.resolve()}}exports.X3PackageManager=X3PackageManager;
//# sourceMappingURL=x3-package-manager.js.map