import { Application, Context, CreateSchemaOptions, Package, PackageManager } from '@sage/xtrem-core';
export declare class X3PackageManager extends PackageManager {
    readonly application: Application;
    constructor(application: Application);
    /**
     * Get the package etag from the database (max UPDDATTIM_0)
     * @param context
     * @returns
     */
    private static getPackageEtag;
    private static packageEtag;
    /**
     * Verify the package etag from the database
     * @param context
     * @returns
     */
    private static verifyPackageEtag;
    private static lastCacheCheck;
    /**
     * Verify the package cache is still valid
     * @param context
     * @returns
     */
    private static verifyPackageCache;
    getActivePackageNames(context: Context): Promise<string[]>;
    getCurrentVersion(pack: Package, _context?: Context): Promise<string | undefined>;
    validatePackageVersions(): Promise<void>;
    createSqlSchemaAndTables(_options?: CreateSchemaOptions): Promise<boolean>;
    ensureSchemaExists(_options?: CreateSchemaOptions): Promise<void>;
    createOrUpgradePackageAllocations(_context: Context, _activePackageNames?: string[]): Promise<void>;
}
//# sourceMappingURL=x3-package-manager.d.ts.map