/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremX3LocalizationManager=void 0;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"localization");class XtremX3LocalizationManager{constructor(){this.localeLangMap={},this.folderDefaultLangMap={}}initializeManager(){}getDefaultTenantLocale(){return"en-US"}isMasterLocale(){return true}createTenantLocale(){}async getLanguageFromLocale(e,a,t){if(!this.localeLangMap[a]){const r=logger.verbose(()=>`Loading Language for ${a}`);try{const r=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),o=`SELECT LAN_0 AS ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias("LANGUAGE",r.dialect)} FROM ${t}.TABLAN t WHERE LANISO_0 = '${a}'`,l=await r.execute(o);if(l&&typesLib.gt(l.length,0))this.localeLangMap[a]=l[0].LANGUAGE;else if(this.localeLangMap[a]=await this.getFolderDefaultLanguage(e),e.testMode)this.localeLangMap[a]="ENG"}catch(e){throw r.fail(`Failed to load language for ${a} : ${e.stack}`),e}}return this.localeLangMap[a]}async getFolderDefaultLanguage(e){const a=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e});if(!this.folderDefaultLangMap[a]){const t=await xtrem_x3_gateway_1.FolderManager.getReferenceFolderName(xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),{context:e}),r=logger.verbose(()=>`Loading folder ${a}`);try{const r=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),o=`SELECT LANDEF_0 AS ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias("DEFAULT_LANGUAGE",r.dialect)}  FROM ${t}.ADOSSIER WHERE DOSSIER_0 = '${a}'`,l=await r.execute(o);if(!l.length)throw Error(`${a}: Invalid folder name supplied`);this.folderDefaultLangMap[a]=l[0].DEFAULT_LANGUAGE}catch(e){throw r.fail(`${a} : Failed to load folder details : ${e.stack}`),e}}return this.folderDefaultLangMap[a]}}exports.XtremX3LocalizationManager=XtremX3LocalizationManager;
//# sourceMappingURL=x3-localization-manager.js.map