/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.accessRightsManager=exports.XtremX3AccessRightsManager=void 0,exports.allowedAccessCodes=allowedAccessCodes;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),_=require("lodash"),x3SystemUtils=require(".."),logger=xtrem_core_1.Logger.getLogger(__filename,"access-rights"),standardAuthorizationOption={create:"C",update:"M",delete:"S",read:""};class XtremX3AccessRightsManager{static async _getUserAccessCodes(e,t){return(await e.select(x3SystemUtils.nodes.SysUserAccess,{access:{access:true},modification:true,execution:true,inquiry:true},{filter:{user:t,access:{_ne:""}}})).map(e=>({accessCode:e.access.access,modification:e.modification,execution:e.execution,inquiry:e.inquiry}))}static{this.allFunctionVariables=null}static async getAllVariables(e){if(this.allFunctionVariables)return this.allFunctionVariables;const t=`SELECT\n                        t0.CODINT_0,\n                        t0.VALEUR_0,\n                        t0.VALEUR_1,\n                        t0.VALEUR_2,\n                        t0.VALEUR_3,\n                        t0.VALEUR_4,\n                        t0.VALEUR_5,\n                        t0.VALEUR_6,\n                        t0.VALEUR_7,\n                        t0.VALEUR_8,\n                        t0.VALEUR_9,\n                        t0.VARIA_0,\n                        t0.VARIA_1,\n                        t0.VARIA_2,\n                        t0.VARIA_3,\n                        t0.VARIA_4,\n                        t0.VARIA_5,\n                        t0.VARIA_6,\n                        t0.VARIA_7,\n                        t0.VARIA_8,\n                        t0.VARIA_9\n                    FROM\n                        ${xtrem_x3_gateway_1.FolderManager.getFolderName({context:e})}.AFONCTION t0\n                    WHERE t0.VARIA_0 <> ' '`,s=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),r=await s.execute(t);return this.allFunctionVariables=[],r.forEach(e=>{let t=0,s=e[`VARIA_${t}`],r=e[`VALEUR_${t}`];for(;s&&typesLib.strictNe(s," ")&&typesLib.lt(t,10);)this.allFunctionVariables?.push({variable:s,value:r,internal:e.CODINT_0}),t=typesLib.add(t,1),s=e[`VARIA_${t}`],r=e[`VALEUR_${t}`]}),logger.info(()=>`Loaded ${this.allFunctionVariables?.length} function variables from AFONCTION`),this.allFunctionVariables}static async _getFunctionalAuthorization(e,t){const s=(0,xtrem_shared_1.createDictionary)(),r=(0,xtrem_shared_1.createDictionary)();if(!t.allAuthorizedFunctions){const a=await e.select(x3SystemUtils.nodes.SysFunctionalProfile,{function:{internal:true},options:true},{filter:{profileForAllSites:{profile:t.profile},access:true},orderBy:{function:1}}),i=await this.getAllVariables(e);a.forEach(e=>{s[e.function.internal]=e.options;i.filter(t=>typesLib.strictEq(t.internal,e.function.internal)).filter(e=>/^GXTLOOKUP\d*$/.test(e.variable)&&e.value).forEach(t=>{t.value.split(",").map(e=>e.trim()).forEach(t=>{if(!r[t])r[t]=[];r[t].push(e.function.internal)})})})}return{optionsByFunctionCode:s,inherited:{lookup:r}}}static async getUsername(e){const t=(await e.user)?.userName;if(!t)throw new xtrem_shared_1.LogicError("Username not set in context.");return t}static async _loadRightsFromDb(e){const t=await this.getUsername(e),s=await e.select(x3SystemUtils.nodes.SysUser,{profession:{functionProfile:{profile:true,allAuthorizedFunctions:true}},functionProfile:{profile:true,allAuthorizedFunctions:true},allAccessCodes:true,code:true},{filter:{code:t.toUpperCase()}});if(typesLib.strictEq(s.length,0))throw new Error(`User ${t} not found`);const r=s[0],{profession:a}=r,i=a?.functionProfile.profile?a.functionProfile:r.functionProfile;if(!i)throw new Error(`${r.code}: functional profile missing`);const c=r.allAccessCodes?null:await XtremX3AccessRightsManager._getUserAccessCodes(e,r.code),n=i.allAuthorizedFunctions??false,{optionsByFunctionCode:o,inherited:u}=await XtremX3AccessRightsManager._getFunctionalAuthorization(e,i);return{userCode:t,profile:i.profile,accessCodes:c,allFunctionsAllowed:n,optionsByFunctionCode:o,inherited:u,sitesByFunctionCode:{}}}static async getRightsEtag(e){const t=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),s=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),r=`SELECT VALEUR_0 AS ${xtrem_x3_gateway_1.SqlResolver.makeColumnAlias("RIGHTSETAG",t.dialect)}  FROM ${s}.ADOVAL WHERE PARAM_0 = 'RIGHTSETAG'`,a=await t.execute(r);if(a.length)return a[0].RIGHTSETAG;return}static async verifyRightsEtag(e){const t=await XtremX3AccessRightsManager.getRightsEtag(e);if(typesLib.eq(XtremX3AccessRightsManager.rightsEtag,null))return XtremX3AccessRightsManager.rightsEtag=t,true;const s=typesLib.strictEq(XtremX3AccessRightsManager.rightsEtag,t);return logger.debug(()=>`Rights etag verification from DB: ${s}`),logger.debug(()=>`Rights etag verification stored: ${t}`),XtremX3AccessRightsManager.rightsEtag=t,s}static async verifyUserCache(e){const t=performance.now();if(XtremX3AccessRightsManager.lastCacheCheck=XtremX3AccessRightsManager.lastCacheCheck||t,typesLib.lt(typesLib.sub(t,XtremX3AccessRightsManager.lastCacheCheck),3e4))return;if(XtremX3AccessRightsManager.lastCacheCheck=t,!await XtremX3AccessRightsManager.verifyRightsEtag(e))logger.debug(()=>"AccessRightManager cache invalidation."),await e.invalidateCachedCategory("AccessRightManager"),this.loadRightsFromDbPromises=(0,xtrem_shared_1.createDictionary)(),this.allFunctionVariables=null}static{this.loadRightsFromDbPromises=(0,xtrem_shared_1.createDictionary)()}static async _getAccessRights(e){await this.verifyUserCache(e);const t=await this.getUsername(e);return e.getCachedValue({category:"AccessRightManager",key:`${e.schemaName}/${t}`,getValue:async()=>{const s=await logger.verboseAsync(()=>`Loading access rights for ${t}`);try{if(typesLib.eq(XtremX3AccessRightsManager.loadRightsFromDbPromises[t],null))XtremX3AccessRightsManager.loadRightsFromDbPromises[t]=XtremX3AccessRightsManager._loadRightsFromDb(e);const r=XtremX3AccessRightsManager.loadRightsFromDbPromises[t],a=await r;return s.success(),{value:a}}catch(e){if(t in XtremX3AccessRightsManager.loadRightsFromDbPromises)delete XtremX3AccessRightsManager.loadRightsFromDbPromises[t];throw s.fail(`Failed to load access rights : ${e.stack}`),e}},cacheInMemory:true,ttlInSeconds:3600})}static async getProfilesSitesByFunctionCode(e,t,s){return await XtremX3AccessRightsManager.verifyUserCache(e),e.getCachedValue({category:"AccessRightManager",key:`${e.schemaName}/siteBy_profile_functionCode/${t}/${s}`,getValue:async()=>{const r=await logger.verboseAsync(()=>"Loading site codes allocated to functions");try{return{value:await e.select(x3SystemUtils.nodes.SysFunctionalProfilePerSite,{site:{code:true},options:true,profile:{profile:true},function:{internal:true}},{filter:{profile:t,function:{internal:s},site:{_ne:""}}})}}catch(e){throw r.fail(`Failed to load access rights : ${e.stack}`),e}},cacheInMemory:true,ttlInSeconds:3600})}static async getSiteCodes(e,t,s,r){if(t.allFunctionsAllowed)return null;const a=`${t.profile}/${s}/${r}`;let i=t.sitesByFunctionCode[a];if(typesLib.strictEq(i,void 0)){if(i=(await XtremX3AccessRightsManager.getProfilesSitesByFunctionCode(e,t.profile,s)).filter(e=>typesLib.strictEq(r,"")||e.options.includes(r)).map(e=>e.site?.code||"").filter(e=>!!e),typesLib.strictEq(i.length,0))i=null;t.sitesByFunctionCode[a]=i}return i}static{this.mutableParentsCache=(0,xtrem_shared_1.createDictionary)()}static getMutableParents(e,t){if(this.mutableParentsCache[t.name])return this.mutableParentsCache[t.name];const s=[];return e.application.getAllFactories().forEach(e=>{if(e.mutableProperties.find(e=>typesLib.strictEq(e.targetFactory,t)))s.push(e)}),this.mutableParentsCache[t.name]=_.uniq(s),this.mutableParentsCache[t.name]}static getParentNodes(e,t){const s=_.uniq(t.referringProperties.filter(e=>typesLib.strictNe(e.targetFactory.name,t.name)&&e.targetFactory.isPublished&&!e.property.isSystemProperty&&!e.property.isVitalParent&&!e.property.isAssociationParent&&e.property.isPublished&&e.property.isMutable).map(e=>e.targetFactory.name)),r=Array.from(s);return s.forEach(s=>{const a=t.application.getFactoryByName(s);XtremX3AccessRightsManager.getMutableParents(e,a).forEach(e=>{r.push(e.name)})}),_.uniq(r)}static factoryProvidesSite(e){return e.properties.some(e=>e.provides?.includes("site"))}async getInferredAccessWithoutSites(e,t,s,r){if(!await(0,xtrem_core_1.asyncArray)(t).some(async t=>{const s=await this.getUserAccessFor(e,t,"read",r);return typesLib.strictEq(s.status,"authorized")}))return XtremX3AccessRightsManager.createUserAccess("unauthorized");const a=XtremX3AccessRightsManager.extractAccessCodes(s);return XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:a})}async getInferredAccessWithSiteAggregation(e,t,s,r){const a=[];let i=false;if(await(0,xtrem_core_1.asyncArray)(t).forEach(async t=>{const s=await this.getUserAccessFor(e,t,"read",r);if(typesLib.strictEq(s.status,"authorized"))if(i=true,typesLib.ne(s.sites,null))a.push(s.sites)}),!i)return XtremX3AccessRightsManager.createUserAccess("unauthorized");const c=XtremX3AccessRightsManager.extractAccessCodes(s);if(typesLib.gt(a.length,0)){const e=_.uniq(_.flatten(a));return XtremX3AccessRightsManager.createUserAccess("authorized",{sites:e,accessCodes:c})}return XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:c})}async getReferringPropertiesLookupAccess(e,t,s,r){let a=XtremX3AccessRightsManager.createUserAccess("unauthorized");const i=t.referringProperties.filter(e=>typesLib.strictNe(e.targetFactory.name,t.name)&&e.targetFactory.isPublished&&!e.property.isSystemProperty&&!e.property.isVitalParent&&e.property.isPublished&&XtremX3AccessRightsManager.isPropertyLookupAllowed(e.property,e.targetFactory));if(typesLib.gt(i.length,0))if(XtremX3AccessRightsManager.factoryProvidesSite(t)){const t=await(0,xtrem_core_1.asyncArray)(i).map(t=>this.getUserAccessFor(e,t.targetFactory.name,"read",r)).filter(e=>typesLib.strictEq(e.status,"authorized")).toArray();if(typesLib.gt(t.length,0)){const e=t.find(e=>typesLib.eq(e.sites,null));if(e)a=e;else{const e=_.uniq(_.flatten(t.map(e=>e.sites||[])));a=XtremX3AccessRightsManager.createUserAccess("authorized",{sites:e,accessCodes:t[0].accessCodes})}}}else{if(await(0,xtrem_core_1.asyncArray)(i).some(async s=>{const a=await this.getUserAccessFor(e,s.targetFactory.name,"lookup",r);if(typesLib.strictEq(a.status,"authorized"))return logger.verbose(()=>`Authorized lookup access via referring property ${s.targetFactory.name} for ${t.name}`),true;return false})){const e=XtremX3AccessRightsManager.extractAccessCodes(s);a=XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:e})}}return a}async getInferredLookupAccess(e,t,s,r){const a=XtremX3AccessRightsManager.getParentNodes(e,t);let i=XtremX3AccessRightsManager.createUserAccess("unauthorized");if(typesLib.gt(a.length,0)){if(XtremX3AccessRightsManager.factoryProvidesSite(t))i=await this.getInferredAccessWithSiteAggregation(e,a,s,r);else i=await this.getInferredAccessWithoutSites(e,a,s,r);if(logger.verbose(()=>`Inferred lookup access result for ${t.name}:${i.status}`),typesLib.strictEq(i.status,"authorized"))return i}if(typesLib.strictEq(i.status,"unauthorized"))i=await this.getReferringPropertiesLookupAccess(e,t,s,r),logger.verbose(()=>`Referring properties lookup access result for ${t.name}:${i.status}`);return i}static async getInheritedAccess(e,t,s,r){const a=XtremX3AccessRightsManager.extractAccessCodes(r);if(XtremX3AccessRightsManager.factoryProvidesSite(t)){const i=[];let c=false;return await(0,xtrem_core_1.asyncArray)(s).forEach(async s=>{logger.verbose(()=>`Function ${s} inherits lookup access to ${t.name}`);const a=await XtremX3AccessRightsManager.getSiteCodes(e,r,s,"");if(typesLib.eq(a,null))return void(c=true);i.push(...a)}),XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:a,sites:c?null:i})}return XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:a,sites:null})}static getInheritedLookupAccess(e,t,s){if(s.inherited?.lookup&&s.inherited.lookup[t.authorizationCode||""])return XtremX3AccessRightsManager.getInheritedAccess(e,t,s.inherited.lookup[t.authorizationCode||""],s);return XtremX3AccessRightsManager.createUserAccess("unauthorized")}async getUserAccessForLookup(e,t,s,r){if(r?.parentNodeName)return this.getUserAccessFor(e,r.parentNodeName,"read",r);const a=await this.getUserAccessFor(e,t.name,"read",r);if(typesLib.strictEq(a.status,"authorized"))return a;const i=await XtremX3AccessRightsManager.getInheritedLookupAccess(e,t,s);if(typesLib.strictEq(i.status,"authorized"))return i;return this.getInferredLookupAccess(e,t,s,r)}static verifyKeyFunction(e,t){if(!e.getContextValue("keyFunctions"))return true;const s=e.getContextValue("keyFunctions")?.split(",").map(e=>e.trim());if(s&&typesLib.gt(s.length,0)&&t&&!s.includes(t))return false;return true}static createUserAccess(e,t){return{...{sites:typesLib.strictEq(e,"authorized")?null:[],accessCodes:typesLib.strictEq(e,"authorized")?null:[],status:e},...t}}static findCustomOperation(e,t){return e.queries.find(e=>typesLib.strictEq(e.name,t))||e.mutations.find(e=>typesLib.strictEq(e.name,t))}static determineAccessContext(e,t,s){const r=XtremX3AccessRightsManager.findCustomOperation(e,t),a=e.propertiesByName[t],i=s?.authorizationCode||r?.authorizationCode||e.authorizationCode;return{factory:e,operationName:t,customOperation:r,property:a,isProperty:typesLib.ne(a,null),isCustomOperation:typesLib.ne(r,null),functionCode:i}}static extractAccessCodes(e){return e.accessCodes?.filter(e=>e.modification||e.inquiry).map(e=>e.accessCode)||null}static isPropertyLookupAllowed(e,t){return e.lookupAccess||e.isMutable||t.naturalKey?.some(t=>typesLib.strictEq(t,e.name))}async handlePropertyAccess(e,t,s,r,a){const i=await this.getUserAccessFor(e,t,"read",a);if(typesLib.strictEq(i.status,"authorized"))return i;const c=e.application.getFactoryByName(t);if(XtremX3AccessRightsManager.isPropertyLookupAllowed(s,c)){const e=XtremX3AccessRightsManager.extractAccessCodes(r);return XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:e})}return XtremX3AccessRightsManager.createUserAccess("unauthorized")}static getCustomOperationOptionCode(e,t,s,r){const a=t.externalStorageManager;if(!a.accessMapping||!a.accessMapping[s])return r[s]||"";const i=a.accessMapping[s];if(typesLib.eq(i,null))return r[s]||null;const c=typesLib.strictEq(typeof i,"function")?i(e):i;return r[c]||c}static determineOperationOptionCode(e,t,s){if(standardAuthorizationOption[s.operationName])return standardAuthorizationOption[s.operationName];if(s.customOperation)return XtremX3AccessRightsManager.getCustomOperationOptionCode(e,t,s.customOperation.name,standardAuthorizationOption);return""}static isOperationAllowed(e,t){if(typesLib.strictEq(e,null)||typesLib.strictEq(t,""))return true;return typesLib.gte(e.indexOf(t),0)}async getVitalParentAccess(e,t,s,r){if(!t.isVitalChild||typesLib.eq(standardAuthorizationOption[s],null))return null;const a=await this.getUserAccessFor(e,t.vitalParentFactory.name,s,r);if(r?.alwaysReturnParentAccess)return a;if(typesLib.strictEq(a.status,"authorized"))return a;return null}async handleFunctionAccess(e,t,s,r,a){const{functionCode:i}=r;if(typesLib.eq(i,null)){const i=await this.getVitalParentAccess(e,s,r.operationName,{...a,alwaysReturnParentAccess:true});if(i)return i;const c=XtremX3AccessRightsManager.extractAccessCodes(t);return XtremX3AccessRightsManager.createUserAccess("authorized",{accessCodes:c})}const c=t.optionsByFunctionCode[i];if(typesLib.strictEq(c,void 0)){const t=await this.getVitalParentAccess(e,s,r.operationName,a);if(t)return t;return XtremX3AccessRightsManager.createUserAccess("unauthorized")}const n=XtremX3AccessRightsManager.determineOperationOptionCode(e,s,r);if(typesLib.eq(n,null))return XtremX3AccessRightsManager.createUserAccess("unauthorized");if(!XtremX3AccessRightsManager.isOperationAllowed(c,n)){const t={C:"create",M:"update",S:"delete","":"read"}[n];if(typesLib.ne(t,null)){const r=await this.getVitalParentAccess(e,s,t,a);if(r)return r}return XtremX3AccessRightsManager.createUserAccess("unauthorized")}const o=await XtremX3AccessRightsManager.getSiteCodes(e,t,i,n),u=XtremX3AccessRightsManager.extractAccessCodes(t);return XtremX3AccessRightsManager.createUserAccess("authorized",{sites:o,accessCodes:u})}async getUserAccess(e,t,s="",r){const a=e.application.getFactoryByName(t);if(!await a.isEnabledByServiceOptions(e))return XtremX3AccessRightsManager.createUserAccess("unavailable");const i=await XtremX3AccessRightsManager._getAccessRights(e);if(i.allFunctionsAllowed)return XtremX3AccessRightsManager.createUserAccess("authorized",{sites:null,accessCodes:null});if(typesLib.strictEq(s,"lookup"))return this.getUserAccessForLookup(e,a,i,r);const c=XtremX3AccessRightsManager.determineAccessContext(a,s,r);if(c.property)return this.handlePropertyAccess(e,t,c.property,i,r);return await this.handleFunctionAccess(e,i,a,c,r)}async getUserAccessFor(e,t,s="",r){if(!r?.visitedNodes){const a={...r,visitedNodes:new Set};return this.getUserAccessFor(e,t,s,a)}const{visitedNodes:a}=r,i=`${t}:${s}`;if(a.has(i))return logger.verbose(()=>`Cycle detected - ${i}, path=[${Array.from(a).join(" → ")} → ${i}]`),XtremX3AccessRightsManager.createUserAccess("unauthorized");a.add(i);const c=logger.verbose(()=>`Checking access for user on ${t}.${s}`),n=await this.getUserAccess(e,t,s,r);return c.success(),n}async getUserAccessCodes(e){return(await XtremX3AccessRightsManager._getAccessRights(e)).accessCodes}async isAccessCodeAvailable(e,t){if(!t)return true;const s=await XtremX3AccessRightsManager._getAccessRights(e),r=s.accessCodes?.filter(e=>e.modification||e.inquiry).map(e=>e.accessCode)||[];return!s.accessCodes||r.includes(t)}getOperationSecurityFilter(e,t,s){return Promise.resolve(void 0)}getUser(e,t){const s=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),r=t.toUpperCase(),a=`${s}/${r}`;return e.getCachedValue({category:"User",key:a,getValue:async()=>{const t=(await e.select(x3SystemUtils.nodes.SysUser,{code:true,email:true,nameDescription:true,activeInSelec:true,_image:{data:true}},{filter:{login:r}})).map(e=>({_id:e.code,email:e.email||"noreply@sage.com",firstName:e.nameDescription,isActive:e.activeInSelec||void 0,photo:e._image?.data,userName:e.code}));let s;if(!t.length){const t=(await e.select(x3SystemUtils.nodes.SysUser,{code:true,email:true,nameDescription:true,activeInSelec:true,_image:{data:true}},{filter:{code:r}})).map(e=>({_id:e.code,email:e.email||"noreply@sage.com",firstName:e.nameDescription,isActive:e.activeInSelec||void 0,photo:e._image?.data,userName:e.code}));if(typesLib.strictEq(t.length,0))throw Error(`User does not exist for X3 user ${r}.`);[s]=t}else[s]=t;return{value:s}},cacheInMemory:true,ttlInSeconds:60})}async createAdminUser(){}createRequiredUsers(){}ensureAdminPersonaCreated(){return xtrem_core_1.adminDemoPersona}async getCurrentUser(e){const t=await e.user;if(!t)throw new xtrem_shared_1.LogicError("User not set on context.");return t}getUserNode(){return x3SystemUtils.nodes.SysUser}async getPermissions(e,t){const s=await XtremX3AccessRightsManager._getAccessRights(e),r=[];if(s.allFunctionsAllowed)return["create","read","update","delete","lookup"];const a=s.optionsByFunctionCode[t];if(typesLib.strictNe(a,void 0)){if(r.push("read","lookup"),typesLib.gte(a.indexOf("C"),0))r.push("create");if(typesLib.gte(a.indexOf("M"),0))r.push("update");if(typesLib.gte(a.indexOf("S"),0))r.push("delete")}return r}async createActivities(){}async updateActivities(){}async deleteActivities(){}getActivityNode(){return x3SystemUtils.nodes.SysActivityCode}getActivitiesInfo(){return[]}supportsPersona(){return false}getPersonaUser(){return null}getDemoPersonas(){return[]}invalidateAuthorizationCache(e){return e.invalidateCachedCategory("AUTHORIZATION",{})}isAuthorizationServiceOptionEnabled(e){return false}hasLookupAccess(e){return!e.startsWith("Sys")}}async function allowedAccessCodes(e){const t=await exports.accessRightsManager.getUserAccessCodes(e);if(t){const e=t.filter(e=>e.execution).map(e=>e.accessCode);return e.push(""),e.length?e:null}return null}exports.XtremX3AccessRightsManager=XtremX3AccessRightsManager,exports.accessRightsManager=new XtremX3AccessRightsManager;
//# sourceMappingURL=x3-access-rights-manager.js.map