import { AccessRightsManager, ActivityInfo, AnyFilterObject, Context, Dict, NodeFactory, UserAccess, UserInfo } from '@sage/xtrem-core';
import { AsyncResponse } from '@sage/xtrem-shared';
import { UserAccessCode } from '@sage/xtrem-x3-gateway';
import * as x3SystemUtils from '..';
export { UserAccessCode };
interface AccessRightDescriptor {
    userCode: string;
    profile: string;
    accessCodes: UserAccessCode[] | null;
    allFunctionsAllowed: boolean;
    optionsByFunctionCode: Dict<string>;
    sitesByFunctionCode: Dict<string[] | null>;
    inherited?: {
        lookup?: Dict<string[]>;
    };
}
interface GetUserAccessOptions {
    authorizationCode?: string;
    parentNodeName?: string;
    visitedNodes?: Set<string>;
}
export declare class XtremX3AccessRightsManager implements AccessRightsManager {
    private static _getUserAccessCodes;
    private static allFunctionVariables;
    private static getAllVariables;
    private static _getFunctionalAuthorization;
    static getUsername(context: Context): Promise<string>;
    private static _loadRightsFromDb;
    /**
     * Get the rights etag from the database (RIGHTSETAG parameter value)
     * @param context
     * @returns
     */
    private static getRightsEtag;
    private static rightsEtag;
    /**
     * Verify the rights etag from the database
     * @param context
     * @returns
     */
    private static verifyRightsEtag;
    private static lastCacheCheck;
    /**
     * Verify the user cache is still valid
     * @param context
     * @returns
     */
    private static verifyUserCache;
    private static loadRightsFromDbPromises;
    private static _getAccessRights;
    static getProfilesSitesByFunctionCode(context: Context, profile: string, functionCode: string): Promise<{
        site: {
            code: string;
        } | null;
        options: string;
        profile: {
            profile: string;
        };
        function: {
            internal: string;
        };
    }[]>;
    private static getSiteCodes;
    private static readonly mutableParentsCache;
    private static getMutableParents;
    /**
     * Gets parent nodes excluding self-references and system properties
     */
    private static getParentNodes;
    /**
     * Checks if factory provides site information
     */
    private static factoryProvidesSite;
    /**
     * Gets inferred access without site restrictions (simpler case)
     */
    private getInferredAccessWithoutSites;
    /**
     * Gets inferred access with site aggregation (complex case)
     */
    private getInferredAccessWithSiteAggregation;
    /**
     * Determines lookup access for a factory based on referring properties and site aggregation.
     */
    private getReferringPropertiesLookupAccess;
    /**
     * Gets inferred lookup access through parent nodes
     */
    private getInferredLookupAccess;
    static getInheritedAccess(context: Context, factory: NodeFactory, inheritedFromFunctions: string[], ard: AccessRightDescriptor): Promise<UserAccess>;
    static getInheritedLookupAccess(context: Context, factory: NodeFactory, ard: AccessRightDescriptor): AsyncResponse<UserAccess>;
    /**
     * Determines lookup access for a factory
     * Lookup access can be granted through:
     * 1. Parent node access (when called from a lookup context)
     * 2. Direct read access on the target node
     * 3. Inferred access through parent nodes
     */
    getUserAccessForLookup(context: Context, factory: NodeFactory, ard: AccessRightDescriptor, options?: GetUserAccessOptions): Promise<UserAccess>;
    static verifyKeyFunction(context: Context, functionCode?: string): boolean;
    /**
     * Creates a UserAccess object with default values
     */
    private static createUserAccess;
    /**
     * Finds custom operation (query or mutation) by name
     */
    private static findCustomOperation;
    /**
     * Determines the access context (property, operation, or standard CRUD)
     */
    private static determineAccessContext;
    /**
     * Extracts access codes from access rights descriptor
     */
    private static extractAccessCodes;
    /**
     * Checks if property allows lookup access
     */
    private static isPropertyLookupAllowed;
    /**
     * Handles access checks for property access
     */
    private handlePropertyAccess;
    /**
     * Gets option code for custom operations
     */
    private static getCustomOperationOptionCode;
    /**
     * Determines the operation option code (C, M, S, or '')
     */
    private static determineOperationOptionCode;
    /**
     * Checks if operation is allowed based on function options
     */
    private static isOperationAllowed;
    /**
     * Gets access from vital parent if applicable
     * @param context
     * @param factory
     * @param operationName
     * @returns
     */
    private getVitalParentAccess;
    /**
     * Handles access checks for function/operation access
     */
    private handleFunctionAccess;
    getUserAccess(context: Context, nodeName: string, propertyOrOperation?: string, options?: GetUserAccessOptions): Promise<UserAccess>;
    /**
     * Returns whether a user (from his/her user code) can access a function (from its code)
     */
    getUserAccessFor(context: Context, nodeName: string, propertyOrOperation?: string, options?: GetUserAccessOptions): Promise<UserAccess>;
    /**
     * Gets the list of access codes that the user is allowed to access
     *
     * @param context
     * @returns the list of access codes if controlled, null if the user can see all access codes.
     */
    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
    /**
     * Returns whether a user (from his/her user code) can access a property (from its accessCode)
     *
     * @param {Context} context
     * @param {string} accessCode
     * @returns {boolean}
     * @memberof X3AccessRightsManager
     */
    isAccessCodeAvailable(context: Context, accessCode: string): Promise<boolean>;
    getOperationSecurityFilter(context: Context, factory: NodeFactory, operation: string): Promise<AnyFilterObject | undefined>;
    /**
     * Returns the user code for a given login
     *
     * @param {Context} context
     * @param {string} code
     */
    getUser(context: Context, code: string): Promise<UserInfo>;
    createAdminUser(): Promise<void>;
    createRequiredUsers(): void;
    ensureAdminPersonaCreated(): UserInfo;
    getCurrentUser(context: Context): Promise<UserInfo>;
    getUserNode(): typeof x3SystemUtils.nodes.SysUser;
    getPermissions(context: Context, activity: string): Promise<string[]>;
    createActivities(): Promise<void>;
    updateActivities(): Promise<void>;
    deleteActivities(): Promise<void>;
    getActivityNode(): typeof x3SystemUtils.nodes.SysActivityCode;
    getActivitiesInfo(): ActivityInfo[];
    supportsPersona(): boolean;
    getPersonaUser(): UserInfo | null;
    getDemoPersonas(): UserInfo[];
    invalidateAuthorizationCache(context: Context): Promise<void>;
    /**
     * Returns whether the 'Authorization access control' service option is enabled
     */
    isAuthorizationServiceOptionEnabled(_context: Context): AsyncResponse<boolean>;
    hasLookupAccess(nodeName: string): boolean;
}
export declare const accessRightsManager: XtremX3AccessRightsManager;
export declare function allowedAccessCodes(context: Context): Promise<string[] | null>;
//# sourceMappingURL=x3-access-rights-manager.d.ts.map