import { Context, Node } from '@sage/xtrem-core';
export interface NodeKeyInfo {
    nodeName: string;
    key: string;
}
export declare class SysUtility extends Node {
    private static parsePropertyValue;
    private static getMainNodeNameFromTableName;
    /**
     * Returns the node key using the table name and X3 key.
     * @param context
     * @param tableName
     * @param x3Names
     * @param source
     * @returns
     */
    private static getNodeKeyFromTableName;
    private static functionCache;
    private static functionEtag;
    private static functionLastCheck;
    private static validateFunctionCache;
    /**
     * Retrieves the table name from the function code.
     * The function code is used to find the object code, which is then used to find the table name.
     * The result is cached to improve performance.
     * @param context
     * @param folderName
     * @param functionCode
     * @returns
     */
    private static getTableNameFromFunctionCode;
    /**
     * Retrieves the node key using the function code and X3 key.
     * The function code is used to find the table name, which is then used to find the node key.
     * @param context
     * @param functionCode
     * @param x3Names
     * @returns
     */
    private static getClassicFunctionKey;
    private static representationCache;
    private static representationEtag;
    private static representationLastCheck;
    private static validateRepresentationCache;
    /**
     * Retrieves the table name from the representation code.
     * The representation code is used to find the class code, which is then used to find the table name.
     * @param context
     * @param folderName
     * @param representationCode
     * @returns
     */
    private static getTableNameFromRepresentationCode;
    /**
     * Retrieves the node key using the representation code and X3 key.
     * The representation and class code is used to find the table name, which is then used to find the node key.
     * @param context
     * @param representationCode
     * @param x3Names
     * @returns
     */
    private static getRepresentationKey;
    /**
     * Returns the node key using the function code or representation code and X3 key.
     * @param context
     * @param input
     * @returns
     */
    static parseKey(context: Context, input: string): Promise<NodeKeyInfo>;
}
//# sourceMappingURL=sys-utility.d.ts.map