"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysUserAccess = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        access: {
            access: 'access',
        },
        user: {
            code: 'user',
        },
        profile: {
            profile: 'profile',
        },
    },
};
/** 4GL code: ACCES */
let SysUserAccess = class SysUserAccess extends xtrem_core_1.Node {
};
exports.SysUserAccess = SysUserAccess;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CODACC',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysAccess,
    })
], SysUserAccess.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'USR',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysUser,
    })
], SysUserAccess.prototype, "user", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'CONSUL',
        isStored: true,
        isNullable: true,
    })
], SysUserAccess.prototype, "inquiry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'EXEC',
        isStored: true,
        isNullable: true,
    })
], SysUserAccess.prototype, "execution", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'MODIF',
        isStored: true,
        isNullable: true,
    })
], SysUserAccess.prototype, "modification", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'PRFCOD',
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysUserFunctionProfile,
    })
], SysUserAccess.prototype, "profile", void 0);
exports.SysUserAccess = SysUserAccess = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'ACCES',
        storage: 'external',
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['profile', 'access', 'user'],
        canRead: true,
        canSearch: true,
        indexes: [
            {
                orderBy: {
                    profile: 1,
                    access: 1,
                    user: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    user: 1,
                    access: 1,
                },
            },
        ],
    })
], SysUserAccess);
//# sourceMappingURL=sys-user-access.js.map