import { Collection, integer, Node, Reference } from '@sage/xtrem-core';
import * as x3SystemUtils from '..';
/** 4GL columnName: ATABTAB */
export declare class SysMiscellaneousTables extends Node {
    /** 4GL columnName: NUMTAB */
    readonly glossaryId: Promise<integer>;
    /** 4GL columnName: NUMCAR */
    readonly tableNumber: Promise<string>;
    /** 4GL columnName: LNGDES */
    readonly description: Promise<string>;
    /** 4GL columnName: SHODES */
    readonly shortDescription: Promise<string>;
    /** 4GL columnName: CODACT */
    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
    /** 4GL columnName: ACS */
    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
    /** 4GL columnName: MODULE */
    readonly module: Promise<x3SystemUtils.enums.SysModuleTable | null>;
    /** 4GL columnName: DEPNUM */
    readonly dependency: Reference<SysMiscellaneousTables | null>;
    /** 4GL columnName: LNGFLG */
    readonly modifiableLength: Promise<boolean | null>;
    /** 4GL columnName: LNG */
    readonly length: Promise<integer>;
    /** 4GL columnName: FLGSOC */
    readonly companyFilter: Promise<boolean | null>;
    /** 4GL columnName: FLGLEG */
    readonly filterLegislation: Promise<boolean | null>;
    /** 4GL columnName: FLGENA */
    readonly activeFlag: Promise<boolean | null>;
    /** 4GL columnName: ALPDES1 */
    readonly alpha1: Promise<string>;
    /** 4GL columnName: CODTYP1 */
    readonly type1: Promise<string>;
    /** 4GL columnName: SUP1 */
    readonly option1: Promise<string>;
    /** 4GL columnName: ALPDES2 */
    readonly alpha2: Promise<string>;
    /** 4GL columnName: CODTYP2 */
    readonly type2: Promise<string>;
    /** 4GL columnName: SUP2 */
    readonly option2: Promise<string>;
    /** 4GL columnName: NUMDES1 */
    readonly numeric1: Promise<string>;
    /** 4GL columnName: CODTYP3 */
    readonly type3: Promise<string>;
    /** 4GL columnName: SUP3 */
    readonly option3: Promise<string>;
    /** 4GL columnName: NUMDES2 */
    readonly numeric2: Promise<string>;
    /** 4GL columnName: CODTYP4 */
    readonly type4: Promise<string>;
    /** 4GL columnName: SUP4 */
    readonly option4: Promise<string>;
    /** 4GL code: NBCOL */
    readonly number: Promise<integer>;
    readonly columns: Collection<x3SystemUtils.nodes.SysMiscellaneousTablesColumns>;
    /** 4GL columnName: OBLLEG */
    readonly legislationMandatory: Promise<boolean>;
}
//# sourceMappingURL=sys-miscellaneous-tables.d.ts.map