"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysGeneralParametersData = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("../index");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
        defaultSetOfValues: {
            glossaryId() {
                return 912;
            },
            code: 'defaultSetOfValues',
        },
        site: {
            code: 'site',
        },
        company: {
            code: 'company',
        },
    },
};
/** 4GL code: ADOVAL */
let SysGeneralParametersData = class SysGeneralParametersData extends xtrem_core_1.Node {
};
exports.SysGeneralParametersData = SysGeneralParametersData;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CMP',
        isPublished: false,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysCompany,
    })
], SysGeneralParametersData.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'FCY',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParametersData.prototype, "siteOrLegislationCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isNullable: true,
        isPublished: false,
        node: () => x3SystemUtils.nodes.SysMiscellaneousTable,
        dependsOn: ['siteOrLegislationCode'],
    })
], SysGeneralParametersData.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isNullable: true,
        isPublished: false,
        node: () => x3SystemUtils.nodes.SysSite,
        dependsOn: ['siteOrLegislationCode'],
    })
], SysGeneralParametersData.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'PARAM',
        canSearch: true,
        isPublished: false,
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysGeneralParametersData.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'VALEUR',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParametersData.prototype, "value", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'JEU',
        canSearch: true,
        isPublished: false,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysMiscellaneousTable,
    })
], SysGeneralParametersData.prototype, "defaultSetOfValues", void 0);
exports.SysGeneralParametersData = SysGeneralParametersData = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADOVAL',
        keyPropertyNames: ['company', 'siteOrLegislationCode', 'code'],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        indexes: [
            {
                orderBy: {
                    company: 1,
                    siteOrLegislationCode: 1,
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    code: 1,
                    company: 1,
                    siteOrLegislationCode: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysGeneralParametersData);
//# sourceMappingURL=sys-general-parameters-data.js.map