"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SysGeneralParameter_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysGeneralParameter = void 0;
const typesLib = require("@sage/xtrem-decimal");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("../index");
const joins = {
    referenceJoins: {
        chapter: {
            glossaryId() {
                return 901;
            },
            code: 'chapter',
        },
        group: {
            glossaryId() {
                return 903;
            },
            code: 'group',
        },
        activityCode: {
            code: 'activityCode',
        },
        access: {
            access: 'access',
        },
    },
};
/** 4GL code: ADOPAR */
let SysGeneralParameter = SysGeneralParameter_1 = class SysGeneralParameter extends xtrem_core_1.Node {
    static readByUserParameterValueString(context, parameters) {
        const { code, userCode, site, defintionLevel } = parameters;
        return x3SystemUtils.functions.getGeneralParameterUserValue(context, code, site, userCode, defintionLevel);
    }
    static async readByUserParameterValueDate(context, parameters) {
        const value = await SysGeneralParameter_1.readByUserParameterValueString(context, parameters);
        return value ? xtrem_core_1.date.parse(value, 'base', 'YYYY-MM-DD') : null;
    }
    static async readByUserParameterValueDecimal(context, parameters) {
        const value = await SysGeneralParameter_1.readByUserParameterValueString(context, parameters);
        return xtrem_core_1.Decimal.make(value || 0);
    }
    static async readByUserParameterValueInteger(context, parameters) {
        const value = await SysGeneralParameter_1.readByUserParameterValueString(context, parameters);
        return (0, xtrem_core_1.toNumber)(value);
    }
    static async readByUserParameterValueBoolean(context, parameters) {
        const value = await SysGeneralParameter_1.readByUserParameterValueString(context, parameters);
        return typesLib.strictEq(value, '2');
    }
    static async readParameterValueString(context, parameters) {
        switch (parameters.level) {
            case 'user': {
                const userCode = parameters?.code ?? (await context.user)?.userName;
                const userNode = await context.tryRead(x3SystemUtils.nodes.SysUser, { code: userCode });
                if (!userNode) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__user_not_found', 'User is not valid: {{userCode}}', { userCode }));
                }
                return x3SystemUtils.functions.getGeneralParameterValue(context, userNode, parameters.parameterCode, parameters.level);
            }
            case 'site': {
                const site = parameters?.code;
                if (!site) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__site_required', 'You need to enter the site code.'));
                }
                const siteNode = await context.tryRead(x3SystemUtils.nodes.SysSite, { code: site });
                if (!siteNode) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__site_not_found', 'Site is not valid: {{site}}', { site }));
                }
                return x3SystemUtils.functions.getGeneralParameterValue(context, siteNode, parameters.parameterCode, parameters.level);
            }
            case 'company': {
                const company = parameters?.code;
                if (!company) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__company_required', 'You need to enter the company code.'));
                }
                const companyNode = await context.tryRead(x3SystemUtils.nodes.SysCompany, { code: company });
                if (!companyNode) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__company_not_found', 'Company is not valid: {{company}}', { company }));
                }
                return x3SystemUtils.functions.getGeneralParameterValue(context, companyNode, parameters.parameterCode, parameters.level);
            }
            case 'legislation': {
                const legislation = parameters?.code;
                if (!legislation) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__legislation_required', 'You need to enter the legislation code.'));
                }
                const legislationNode = await context.tryRead(x3SystemUtils.nodes.SysMiscellaneousTable, {
                    glossaryId: 909,
                    code: legislation,
                });
                if (!legislationNode) {
                    throw new xtrem_core_1.BusinessRuleError(context.localize('@sage/xtrem-x3-system-utils/nodes__sys_general_parameter__legislation_not_found', 'Legislation is not valid: {{legislation}}', { legislation }));
                }
                return x3SystemUtils.functions.getGeneralParameterValue(context, legislationNode, parameters.parameterCode, parameters.level);
            }
            default:
                return x3SystemUtils.functions.getGeneralParameterValue(context, null, parameters.parameterCode, 'folder');
        }
    }
    static async readParameterValueDate(context, parameters) {
        const value = await SysGeneralParameter_1.readParameterValueString(context, parameters);
        return value ? xtrem_core_1.date.parse(value, 'base', 'YYYY-MM-DD') : null;
    }
    static async readParameterValueDecimal(context, parameters) {
        const value = await SysGeneralParameter_1.readParameterValueString(context, parameters);
        return xtrem_core_1.Decimal.make(value || 0);
    }
    static async readParameterValueInteger(context, parameters) {
        const value = await SysGeneralParameter_1.readParameterValueString(context, parameters);
        return (0, xtrem_core_1.toNumber)(value);
    }
    static async readParameterValueBoolean(context, parameters) {
        const value = await SysGeneralParameter_1.readParameterValueString(context, parameters);
        return typesLib.strictEq(value, '2');
    }
};
exports.SysGeneralParameter = SysGeneralParameter;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CHAPITRE',
        isPublished: false,
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysMiscellaneousTable,
    })
], SysGeneralParameter.prototype, "chapter", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'TYPVAL',
        isPublished: false,
        isStored: true,
        dataType: () => x3SystemUtils.enums.sysFieldType1DataType,
    })
], SysGeneralParameter.prototype, "valueType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'PARAM',
        isPublished: true,
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
    })
], SysGeneralParameter.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'GRPPAR',
        isPublished: false,
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysMiscellaneousTable,
    })
], SysGeneralParameter.prototype, "group", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NAM',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParameter.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CODACT',
        isPublished: false,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysActivityCode,
    })
], SysGeneralParameter.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'MODIF',
        isPublished: false,
        isStored: true,
        isNullable: true,
    })
], SysGeneralParameter.prototype, "isEditable", void 0);
__decorate([
    xtrem_core_1.decorators.shortProperty({
        columnName: 'NOLIB',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParameter.prototype, "localMenu", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'NIVDEF',
        isPublished: true,
        isStored: true,
        isNullable: true,
        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
    })
], SysGeneralParameter.prototype, "definitionLevel", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'VALUES',
        isPublished: false,
        isStored: true,
        max: 15,
    })
], SysGeneralParameter.prototype, "selectableValues", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'VALFLG',
        isPublished: false,
        isStored: true,
        isNullable: true,
    })
], SysGeneralParameter.prototype, "isOffValue", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'TRAIT',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParameter.prototype, "processing", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SELOPT',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParameter.prototype, "selectionOptions", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'AUSMODIF',
        isPublished: false,
        isStored: true,
        isNullable: true,
    })
], SysGeneralParameter.prototype, "canUserUpdate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'RANG',
        isPublished: false,
        isStored: true,
    })
], SysGeneralParameter.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'ACS',
        isPublished: false,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysAccess,
    })
], SysGeneralParameter.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'VALDEF',
        isPublished: false,
        isStored: true,
        isNullable: true,
    })
], SysGeneralParameter.prototype, "folderValue", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CNDMOD',
        isPublished: false,
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysGeneralParameter.prototype, "modifyingCondition", void 0);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    code: { type: 'string', isMandatory: true },
                    userCode: { type: 'string', isMandatory: false },
                    site: { type: 'string', isMandatory: false },
                    defintionLevel: {
                        name: 'defintionLevel',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                },
            },
        ],
        return: {
            type: 'string',
        },
    })
], SysGeneralParameter, "readByUserParameterValueString", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    code: { type: 'string', isMandatory: true },
                    userCode: { type: 'string', isMandatory: false },
                    site: { type: 'string', isMandatory: false },
                    defintionLevel: {
                        name: 'defintionLevel',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                },
            },
        ],
        return: {
            type: 'date',
            isNullable: true,
        },
    })
], SysGeneralParameter, "readByUserParameterValueDate", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    code: { type: 'string', isMandatory: true },
                    userCode: { type: 'string', isMandatory: false },
                    site: { type: 'string', isMandatory: false },
                    defintionLevel: {
                        name: 'defintionLevel',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                },
            },
        ],
        return: {
            type: 'decimal',
            isNullable: true,
        },
    })
], SysGeneralParameter, "readByUserParameterValueDecimal", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    code: { type: 'string', isMandatory: true },
                    userCode: { type: 'string', isMandatory: false },
                    site: { type: 'string', isMandatory: false },
                    defintionLevel: {
                        name: 'defintionLevel',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                },
            },
        ],
        return: {
            type: 'integer',
        },
    })
], SysGeneralParameter, "readByUserParameterValueInteger", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    code: { type: 'string', isMandatory: true },
                    userCode: { type: 'string', isMandatory: false },
                    site: { type: 'string', isMandatory: false },
                    defintionLevel: {
                        name: 'defintionLevel',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                },
            },
        ],
        return: {
            type: 'boolean',
        },
    })
], SysGeneralParameter, "readByUserParameterValueBoolean", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    parameterCode: { type: 'string', isMandatory: true },
                    level: {
                        name: 'level',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                    code: { type: 'string', isMandatory: false },
                },
            },
        ],
        return: {
            type: 'string',
        },
    })
], SysGeneralParameter, "readParameterValueString", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    parameterCode: { type: 'string', isMandatory: true },
                    level: {
                        name: 'level',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                    code: { type: 'string', isMandatory: false },
                },
            },
        ],
        return: {
            type: 'date',
            isNullable: true,
        },
    })
], SysGeneralParameter, "readParameterValueDate", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    parameterCode: { type: 'string', isMandatory: true },
                    level: {
                        name: 'level',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                    code: { type: 'string', isMandatory: false },
                },
            },
        ],
        return: {
            type: 'decimal',
        },
    })
], SysGeneralParameter, "readParameterValueDecimal", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    parameterCode: { type: 'string', isMandatory: true },
                    level: {
                        name: 'level',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                    code: { type: 'string', isMandatory: false },
                },
            },
        ],
        return: {
            type: 'integer',
        },
    })
], SysGeneralParameter, "readParameterValueInteger", null);
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                isMandatory: true,
                properties: {
                    parameterCode: { type: 'string', isMandatory: true },
                    level: {
                        name: 'level',
                        type: 'enum',
                        dataType: () => x3SystemUtils.enums.sysDefinitionLevel3DataType,
                        isMandatory: false,
                    },
                    code: { type: 'string', isMandatory: false },
                },
            },
        ],
        return: {
            type: 'boolean',
        },
    })
], SysGeneralParameter, "readParameterValueBoolean", null);
exports.SysGeneralParameter = SysGeneralParameter = SysGeneralParameter_1 = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADOPAR',
        keyPropertyNames: ['code'],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    chapter: 1,
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    chapter: 1,
                    sequence: 1,
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    chapter: 1,
                    group: 1,
                    code: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysGeneralParameter);
//# sourceMappingURL=sys-general-parameter.js.map