import { Context, Decimal, Node, Reference, date, integer } from '@sage/xtrem-core';
import * as x3SystemUtils from '../index';
/** 4GL code: ADOPAR */
export declare class SysGeneralParameter extends Node {
    /** 4GL code: CHAPITRE */
    readonly chapter: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
    readonly valueType: Promise<x3SystemUtils.enums.SysFieldType1>;
    /** 4GL code: PARAM */
    readonly code: Promise<string>;
    /** 4GL code: GRPPAR */
    readonly group: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
    /** 4GL code: NAM */
    readonly description: Promise<integer>;
    /** 4GL code: CODACT */
    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
    /** 4GL code: MODIF */
    readonly isEditable: Promise<boolean | null>;
    /** 4GL code: NOLIB */
    readonly localMenu: Promise<integer>;
    /** 4GL code: NIVDEF */
    readonly definitionLevel: Promise<x3SystemUtils.enums.SysDefinitionLevel3 | null>;
    /** 4GL code: VALUES */
    readonly selectableValues: Promise<string[]>;
    /** 4GL code: VALFLG */
    readonly isOffValue: Promise<boolean | null>;
    /** 4GL code: TRAIT */
    readonly processing: Promise<string>;
    /** 4GL code: SELOPT */
    readonly selectionOptions: Promise<string>;
    /** 4GL code: AUSMODIF */
    readonly canUserUpdate: Promise<boolean | null>;
    /** 4GL code: RANG */
    readonly sequence: Promise<integer>;
    /** 4GL code: ACS */
    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
    /** 4GL code: VALDEF */
    readonly folderValue: Promise<boolean | null>;
    /** 4GL code: CNDMOD */
    readonly modifyingCondition: Promise<string>;
    static readByUserParameterValueString(context: Context, parameters: {
        code: string;
        userCode?: string;
        site?: string;
        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
    }): Promise<string>;
    static readByUserParameterValueDate(context: Context, parameters: {
        code: string;
        userCode?: string;
        site?: string;
        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
    }): Promise<date | null>;
    static readByUserParameterValueDecimal(context: Context, parameters: {
        code: string;
        userCode?: string;
        site?: string;
        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
    }): Promise<Decimal>;
    static readByUserParameterValueInteger(context: Context, parameters: {
        code: string;
        userCode?: string;
        site?: string;
        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
    }): Promise<number>;
    static readByUserParameterValueBoolean(context: Context, parameters: {
        code: string;
        userCode?: string;
        site?: string;
        defintionLevel?: x3SystemUtils.enums.SysDefinitionLevel3;
    }): Promise<boolean>;
    static readParameterValueString(context: Context, parameters: {
        parameterCode: string;
        level?: x3SystemUtils.enums.SysDefinitionLevel3;
        code?: string;
    }): Promise<string>;
    static readParameterValueDate(context: Context, parameters: {
        parameterCode: string;
        level?: x3SystemUtils.enums.SysDefinitionLevel3;
        code?: string;
    }): Promise<date | null>;
    static readParameterValueDecimal(context: Context, parameters: {
        parameterCode: string;
        level?: x3SystemUtils.enums.SysDefinitionLevel3;
        code?: string;
    }): Promise<Decimal>;
    static readParameterValueInteger(context: Context, parameters: {
        parameterCode: string;
        level?: x3SystemUtils.enums.SysDefinitionLevel3;
        code?: string;
    }): Promise<number>;
    static readParameterValueBoolean(context: Context, parameters: {
        parameterCode: string;
        level?: x3SystemUtils.enums.SysDefinitionLevel3;
        code?: string;
    }): Promise<boolean>;
}
//# sourceMappingURL=sys-general-parameter.d.ts.map