"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysCompany = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
    },
};
/** 4GL code: COMPANY */
let SysCompany = class SysCompany extends xtrem_core_1.Node {
};
exports.SysCompany = SysCompany;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CPY',
        isPublished: true,
        isStored: true,
    })
], SysCompany.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'CPYLEGFLG',
        isPublished: true,
        isStored: true,
        isNullable: true,
    })
], SysCompany.prototype, "isLegalCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'LEG',
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysMiscellaneousTable,
        canSearch: true,
    })
], SysCompany.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CPYNAM',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isPublished: true,
        canSearch: true,
    })
], SysCompany.prototype, "name", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CPYSHO',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isPublished: true,
        canSearch: true,
    })
], SysCompany.prototype, "shortDescription", void 0);
exports.SysCompany = SysCompany = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'COMPANY',
        keyPropertyNames: ['code'],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        isCached: true,
        canRead: true,
        canSearch: true,
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    legislation: 1,
                    code: 1,
                },
            },
        ],
    })
], SysCompany);
//# sourceMappingURL=sys-company.js.map