"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysActivityCode = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        activityCode: {
            code: 'activityCode',
        },
    },
};
/** 4GL columnName: ACTIV */
let SysActivityCode = class SysActivityCode extends xtrem_core_1.Node {
};
exports.SysActivityCode = SysActivityCode;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODACT',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
    })
], SysActivityCode.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'LIBACT',
        isStored: true,
    })
], SysActivityCode.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'DIME',
        isStored: true,
    })
], SysActivityCode.prototype, "screenSize", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'DIMFIL',
        isStored: true,
    })
], SysActivityCode.prototype, "databaseMinimumSize", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'MODULE',
        isStored: true,
        dataType: () => x3SystemUtils.enums.sysModuleTableDataType,
    })
], SysActivityCode.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'DIMMAX',
        isStored: true,
    })
], SysActivityCode.prototype, "maximumSize", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'RANG',
        isStored: true,
    })
], SysActivityCode.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'ORDRE',
        isStored: true,
    })
], SysActivityCode.prototype, "order", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'TYP',
        isStored: true,
        isNullable: true,
        dataType: () => x3SystemUtils.enums.sysTypesOfActivityCodeDataType,
    })
], SysActivityCode.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'DEP',
        isStored: true,
        isNullable: true,
        dataType: () => x3SystemUtils.enums.sysTypeOfDependencyDataType,
    })
], SysActivityCode.prototype, "dependency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FLACT',
        isStored: true,
        isNullable: true,
    })
], SysActivityCode.prototype, "activeFlag", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'INTIT',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysActivityCode.prototype, "description1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'ACTDEP',
        isStored: true,
        columnType: 'string',
        node: () => SysActivityCode,
        isNullable: true,
    })
], SysActivityCode.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ACTFOR',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysActivityCode.prototype, "formula", void 0);
exports.SysActivityCode = SysActivityCode = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'ACTIV',
        storage: 'external',
        canRead: true,
        canSearch: true,
        isCached: true,
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    module: 1,
                    code: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    order: 1,
                    code: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysActivityCode);
//# sourceMappingURL=sys-activity-code.js.map