import { integer, Node, Reference } from '@sage/xtrem-core';
import * as x3SystemUtils from '..';
/** 4GL columnName: ACTIV */
export declare class SysActivityCode extends Node {
    /** 4GL columnName: CODACT */
    readonly code: Promise<string>;
    /** 4GL columnName: LIBACT */
    readonly description: Promise<integer>;
    /** 4GL columnName: DIME */
    readonly screenSize: Promise<integer>;
    /** 4GL columnName: DIMFIL */
    readonly databaseMinimumSize: Promise<integer>;
    /** 4GL columnName: MODULE */
    readonly module: Promise<x3SystemUtils.enums.SysModuleTable>;
    /** 4GL columnName: DIMMAX */
    readonly maximumSize: Promise<integer>;
    /** 4GL columnName: RANG */
    readonly sequence: Promise<integer>;
    /** 4GL columnName: ORDRE */
    readonly order: Promise<integer>;
    /** 4GL code: TYP */
    readonly type: Promise<x3SystemUtils.enums.SysTypesOfActivityCode | null>;
    /** 4GL code: DEP */
    readonly dependency: Promise<x3SystemUtils.enums.SysTypeOfDependency | null>;
    /** 4GL columnName: FLACT */
    readonly activeFlag: Promise<boolean | null>;
    /** 4GL columnName: INTIT */
    readonly description1: Promise<string>;
    /** 4GL columnName: ACTDEP */
    readonly activityCode: Reference<SysActivityCode | null>;
    /** 4GL columnName: ACTFOR */
    readonly formula: Promise<string>;
}
//# sourceMappingURL=sys-activity-code.d.ts.map