/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getGeneralParameter=getGeneralParameter,exports.getGeneralParameterValue=getGeneralParameterValue;const typesLib=require("@sage/xtrem-decimal"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),x3SystemUtils=require("../index"),user_parameter_values_1=require("./user-parameter-values"),logger=xtrem_core_1.Logger.getLogger(__filename,"general-parameter-value");async function getParameterNode(e,a){const t=await e.tryRead(x3SystemUtils.nodes.SysSite,{code:a});if(t)return t;const r=await e.tryRead(x3SystemUtils.nodes.SysCompany,{code:a});if(r)return r;const s=await e.tryRead(x3SystemUtils.nodes.SysMiscellaneousTable,{glossaryId:909,code:a});if(s)return s;return logger.debug(()=>`'${a}' is not site company or legislation`),null}async function fillParameterCodesKeyFromNode(e,a){const t={folderCode:"",legislationCode:"",companyCode:"",siteCode:"",userCode:""};if(typesLib.strictEq(e,null))return t;if(e instanceof x3SystemUtils.nodes.SysUser){const r=await(0,user_parameter_values_1.getUserProfile)(e.$.context,{user:e}),s=r?await(0,user_parameter_values_1.getSiteFromModule)(x3SystemUtils.enums.sysModuleTableDataType.stringValue(a),r):null;return{...t,userCode:await e.code,siteCode:await(s?.code)??"",companyCode:await((await(s?.legalCompany))?.code)??"",legislationCode:await((await((await(s?.legalCompany))?.legislation))?.code)??""}}if(e instanceof x3SystemUtils.nodes.SysSite)return{...t,legislationCode:await((await((await(e?.legalCompany))?.legislation))?.code)||"",companyCode:await((await(e?.legalCompany))?.code)||"",siteCode:await e.code};if(e instanceof x3SystemUtils.nodes.SysCompany)return{...t,legislationCode:await((await(e?.legislation))?.code)||"",companyCode:await e.code};if(e instanceof x3SystemUtils.nodes.SysMiscellaneousTable)return{...t,legislationCode:await e.code};return logger.debug(()=>"function fillParameterCodesKeyFromNode - Unknown class name"),t}async function readParam(e,a,t,r,s){if(typesLib.strictEq(t.code,""))return null;switch(await logger.debugAsync(async()=>`Keys for search ${await r.code} : ${JSON.stringify(a)}  !`),s||await r.definitionLevel){case"user":if(!await r.folderValue){const r=await e.tryRead(x3SystemUtils.nodes.SysUserParameterValue,{user:a.userCode,description:t.code});if(r)return r;return null}return readParam(e,a,t,r,"site");case"site":if(a.siteCode){const r=await e.tryRead(x3SystemUtils.nodes.SysGeneralParametersData,{...t,company:"",siteOrLegislationCode:a.siteCode});if(r)return r}return readParam(e,a,t,r,"company");case"company":if(a.companyCode){const r=await e.tryRead(x3SystemUtils.nodes.SysGeneralParametersData,{...t,company:a.companyCode,siteOrLegislationCode:""});if(r)return r}return readParam(e,a,t,r,"legislation");case"legislation":if(a.legislationCode){const r=await e.tryRead(x3SystemUtils.nodes.SysGeneralParametersData,{...t,company:"*",siteOrLegislationCode:a.legislationCode});if(r)return r}return readParam(e,a,t,r,"folder");case"folder":{const a=await e.tryRead(x3SystemUtils.nodes.SysGeneralParametersData,{...t,company:"",siteOrLegislationCode:""});if(a)return a;return null}default:return null}}async function getGeneralParameter(e,a){const t={code:a},r=await e.tryRead(x3SystemUtils.nodes.SysGeneralParameter,t);if(!r)throw new Error(`${a} General parameter does not exist`);return r}async function getGeneralParameterValue(e,a,t,r){const s={code:t},i=await getGeneralParameter(e,t);await logger.debugAsync(async()=>`level : ${r??await i.definitionLevel}`);const n=await((await readParam(e,await fillParameterCodesKeyFromNode(typesLib.strictEq(typeof a,"string")?await getParameterNode(e,a):a,await(await i.chapter).numeric1),s,i,r))?.value);if(!n)logger.warn(()=>"returned value - no data");else logger.debug(()=>`returned value : ${n}`);switch(await i.valueType){case"alphanumeric":default:return n??"";case"date":if(typesLib.strictEq(n,"00000000"))return"";return(n&&xtrem_date_time_1.date.parse(n,"base","YYYYMMDD").toString())??"";case"localMenu":return n??"1";case"numeric":return n??"0"}}
//# sourceMappingURL=general-parameter-values.js.map