/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.generateHandler=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_dictionary_1=require("@sage/xtrem-x3-dictionary"),fs=require("fs"),path=require("path"),generateHandler=async e=>{const{executionMode:r,dir:i}=xtrem_cli_lib_1.cliContext,t=path.join(i,"package.json");if(!fs.existsSync(t))(0,xtrem_cli_lib_1.quitWithError)(r,`A package.json is missing in root directory ${i}.`);const a=JSON.parse(fs.readFileSync(t,"utf-8")),{version:n,name:s}=a;if(!n)(0,xtrem_cli_lib_1.quitWithError)(r,`version is not set in ${t}`);if(!e.scopes&&!e.specificOnly)(0,xtrem_cli_lib_1.quitWithError)(r,"scopes not provided.");try{const t=xtrem_config_1.ConfigManager.current,a=xtrem_x3_dictionary_1.X3DictionaryHelper.getConnectionPool(t.x3.sql),o=t.x3.development.folderName;(0,xtrem_cli_lib_1.printInfo)(r,`Requested package scopes: ${e.scopes}`);let c=e.scopes?e.scopes.split(","):["@sage"];if(e.specificOnly)c=c.filter(e=>"@sage"!==e);if(!/^@sage\/xtrem~.*-services/.test(s)&&c.includes("@sage"))(0,xtrem_cli_lib_1.quitWithError)(r,"@sage package scope is not allowed on partner environment.");const _=(await xtrem_x3_dictionary_1.X3PackageGenerator.getPackages(a,o,e.serviceName,e)).filter(r=>{const i=r.name.split("/").shift()||"";if(c.length>0)return c.includes(i);if(e.specificOnly)return"@sage"!==i;return false});if(0===_.length)(0,xtrem_cli_lib_1.quitWithError)(r,`No packages found for scopes ${c}.`);if(e.translations){const t=await(0,xtrem_core_1.asyncArray)(_).map(async r=>{const t=[i,r.type],n=path.join(...t),s=path.join(n,path.basename(r.name)),c=new xtrem_x3_dictionary_1.X3TranslationGenerator(o,s,r.name,a,e.serviceName);return await c.init(),c}).toArray();await Promise.all(t.map(e=>((0,xtrem_cli_lib_1.printInfo)(r,`Generating translations for ${e.packageName} into ${e.dir}`),e.generateTranslation())))}else{await xtrem_x3_dictionary_1.X3PackageGenerator.preLoadPackageData(a,o,e.serviceName);const t=await(0,xtrem_core_1.asyncArray)(_).map(async r=>{const t=[i,r.type],s=path.join(...t),c=path.join(s,path.basename(r.name));xtrem_x3_dictionary_1.X3PackageGenerator.ensurePackageStructureExists(s,{name:r.name,version:n,serviceName:e.serviceName,isCustom:!!r.isCustom,isHidden:r.isHidden});const _=new xtrem_x3_dictionary_1.X3PackageGenerator(c,r.name,a,e.serviceName,o);return await _.init(),_}).toArray();if(await Promise.all(t.map(e=>((0,xtrem_cli_lib_1.printInfo)(r,`Generating ${e.metadata.name} into ${e.dir}`),e.generate()))),e.createMain)(0,xtrem_cli_lib_1.printInfo)(r,"Generating main package"),xtrem_x3_dictionary_1.X3PackageGenerator.generateMainPackage(i,n,e.serviceName)}}catch(e){(0,xtrem_cli_lib_1.quitWithError)(r,e)}if((0,xtrem_cli_lib_1.printSuccess)(r,"Package generation complete."),r===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit()};exports.generateHandler=generateHandler;
//# sourceMappingURL=generate-handler.js.map