// From file: @sage/xtrem-x3-copilot/build/index.d.ts
declare module '@sage/xtrem-x3-copilot/index' {
	export * from '@sage/xtrem-x3-copilot/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/index.d.ts
declare module '@sage/xtrem-x3-copilot/lib/index' {
	import * as enums from '@sage/xtrem-x3-copilot/lib/enums/_index';
	import * as nodes from '@sage/xtrem-x3-copilot/lib/nodes/_index';
	export { enums, nodes };
	export { InsightQuery } from '@sage/xtrem-x3-copilot/lib/classes/insight-storage-manager';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/nodes/sys-insight.d.ts
declare module '@sage/xtrem-x3-copilot/lib/nodes/sys-insight' {
	import type { Context, Reference, TextStream } from '@sage/xtrem-core';
	import { Node } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils';
	import * as x3Copilot from '@sage/xtrem-x3-copilot/lib/index';
	export class SysInsight extends Node {
	    readonly hash: Promise<string>;
	    readonly package: Reference<x3SystemUtils.nodes.SysPackage>;
	    readonly screenId: Promise<string>;
	    readonly key: Promise<string>;
	    readonly type: Promise<x3Copilot.enums.InsightTypeType>;
	    readonly query: Promise<TextStream>;
	    static saveToDisk(context: Context): Promise<boolean>;
	}
	//# sourceMappingURL=sys-insight.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/nodes/sys-copilot.d.ts
declare module '@sage/xtrem-x3-copilot/lib/nodes/sys-copilot' {
	import type { Context } from '@sage/xtrem-core';
	import { Node, TextStream } from '@sage/xtrem-core';
	export interface ChatContext {
	    userLocale: string;
	    userCurrentDate: string;
	    nodeName: string;
	    recordFilter: any;
	    screenId: string;
	    screenTitle: string;
	}
	export class SysCopilot extends Node {
	    /**
	     *  Returns the source app's version.
	     *
	     * @param context the context
	     * @returns a synchronization feed
	     */
	    static getInsightDataQueries(context: Context, chatContext: string): Promise<{
	        data?: string;
	        queries?: {
	            key: string;
	            query: TextStream;
	        }[];
	    }>;
	}
	//# sourceMappingURL=sys-copilot.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/nodes/_index.d.ts
declare module '@sage/xtrem-x3-copilot/lib/nodes/_index' {
	export * from '@sage/xtrem-x3-copilot/lib/nodes/sys-copilot';
	export * from '@sage/xtrem-x3-copilot/lib/nodes/sys-insight';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/enums/insight-type-type.d.ts
declare module '@sage/xtrem-x3-copilot/lib/enums/insight-type-type' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum InsightTypeEnum {
	    main = 1,
	    data = 2
	}
	export type InsightTypeType = keyof typeof InsightTypeEnum;
	export const insightTypeDataType: EnumDataType<"main" | "data", unknown>;
	//# sourceMappingURL=insight-type-type.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/enums/_index.d.ts
declare module '@sage/xtrem-x3-copilot/lib/enums/_index' {
	export * from '@sage/xtrem-x3-copilot/lib/enums/insight-type-type';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: @sage/xtrem-x3-copilot/build/lib/classes/insight-storage-manager.d.ts
declare module '@sage/xtrem-x3-copilot/lib/classes/insight-storage-manager' {
	import type { AnyRecord, AnyRecordWithId, AsyncReader, AsyncResponse, Context, Dict, Extend, ExternalStorageManager, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, PackageApi, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
	import type { InsightTypeType } from '@sage/xtrem-x3-copilot/lib/enums/insight-type-type';
	export interface InsightQuery {
	    screenId: string;
	    type: InsightTypeType;
	    key: string;
	    query: string;
	}
	export interface Insight extends InsightQuery {
	    hash: string;
	    screenId: string;
	    type: InsightTypeType;
	    key: string;
	    query: string;
	    package: string;
	}
	export interface PackageApiWithInsights extends PackageApi {
	    insights?: Dict<Insight>;
	}
	/**
	 * InsightStorageManager is an implementation of ExternalStorageManager for managing SysInsight nodes.
	 * It provides methods for loading, saving, querying, inserting, updating, and deleting Insight records,
	 * which are stored externally (not in the default database). Insights are typically loaded from and saved to disk,
	 * and are associated with Sage X3 Copilot packages.
	 *
	 * @template T The Node type managed by this storage manager.
	 */
	export class InsightStorageManager<T extends Node> implements ExternalStorageManager<T> {
	    /** The NodeFactory instance for this manager. */
	    factory: NodeFactory;
	    /** Indicates if insights have been loaded into memory. */
	    static isLoaded: boolean;
	    /** Promise for the current loading operation, if any. */
	    static loadingPromise: Promise<Insight[]> | undefined;
	    /** In-memory cache of all loaded insights. */
	    static insights: Insight[];
	    /**
	     * Computes a unique hash for an insight based on its package, screenId, and key.
	     * @param insight The insight to hash.
	     * @returns The base64-encoded SHA256 hash string.
	     */
	    static getHash(insight: Insight): string;
	    /**
	     * Loads all insights from all packages in the application context.
	     * Caches the result in memory for future access.
	     * @param context The application context.
	     * @returns A promise resolving to the array of all insights.
	     */
	    static getAllInsights(context: Context): AsyncResponse<Insight[]>;
	    /**
	     * Formats TypeScript source code using Prettier.
	     * @param source The TypeScript source code to format.
	     * @returns The formatted code.
	     */
	    static prettyifyTypescript(source: string): string;
	    /**
	     * Saves all loaded insights to disk, generating TypeScript files for each insight
	     * and updating package index files.
	     * @param context The application context.
	     */
	    static saveInsightsToDisk(context: Context): Promise<void>;
	    /**
	     * Construct an instance of Insight from a Node.
	     * @param node
	     * @returns
	     */
	    static getInsightFromNode<T extends Node>(node: Extend<T>): Promise<Insight>;
	    /**
	     * Create a new Insight.
	     * @param node
	     * @param _cx
	     * @returns
	     */
	    insert(node: Extend<T>, _cx: ValidationContext): Promise<AnyRecordWithId>;
	    /**
	     * Update an existing Insight.
	     * @param node
	     * @param _cx
	     * @returns
	     */
	    update(node: Extend<T>, _cx: ValidationContext): Promise<AnyRecord[]>;
	    /**
	     * Delete an existing Insight.
	     * Throws an error if the insight does not exist or if it is a main insight with
	     * @param node
	     * @param _cx
	     * @returns
	     */
	    delete(node: Extend<T>, _cx: ValidationContext): Promise<number>;
	    /**
	     * Query insights based on the provided context and options.
	     * @param context
	     * @param options
	     * @returns
	     */
	    query(context: Context, options: NodeExternalQueryOptions<T>): AsyncReader<any>;
	    mapRecordIn(record: any): any;
	    /**
	     * Maps an aggregate record in. Not implemented for insights.
	     * @param _record The record to map.
	     * @throws Always throws (not implemented).
	     */
	    mapAggregateRecordIn(_record: any): any;
	    /**
	     * Returns join information for a reference property.
	     * @param propertyName The property name.
	     * @returns A dictionary of join information.
	     */
	    getReferenceJoin(propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    /**
	     * Returns join information for a collection property.
	     * @param _propertyName The property name.
	     * @returns An empty dictionary (no collection joins).
	     */
	    getCollectionJoin(_propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    /**
	     * Gets join values for a reference property.
	     * @param node The node instance.
	     * @param data The data object.
	     * @param propertyName The property name.
	     * @param _index The index (unused).
	     * @returns A dictionary of join values.
	     */
	    getJoinValues(node: Extend<T>, data: any, propertyName: string, _index: number): Promise<Dict<any>>;
	    /**
	     * Parses an order by clause for queries.
	     * @param _context The context.
	     * @param _orderBy The order by object.
	     * @returns An empty array (no ordering supported).
	     */
	    parseOrderBy(_context: Context, _orderBy: OrderBy<Node> | undefined): OrderByClause[];
	    /**
	     * Parses a cursor for paging.
	     * @param _orderByClauses The order by clauses.
	     * @param _value The cursor value.
	     * @returns An empty array (not implemented).
	     */
	    parseCursor(_orderByClauses: OrderByClause[], _value: string): PropertyAndValue[];
	    /**
	     * Internal counter for allocating transient IDs.
	     */
	    private _lastTransientId;
	    /**
	     * Allocates a new transient (temporary) ID for a record.
	     * @returns The allocated ID as a string.
	     */
	    allocateTransientId(): string;
	    /**
	     * Gets the key values for an insight, used for identifying records.
	     * @param _context The context.
	     * @param insight The insight object.
	     * @param _options Options for allocation.
	     * @returns A dictionary of key values.
	     */
	    getKeyValues(_context: Context, insight: any, _options?: {
	        allocateTransient: boolean;
	    }): Dict<any>;
	    /**
	     * Indicates if a key property is transient.
	     * @param _propertyName The property name.
	     * @param _value The value.
	     * @returns Always false (no transient key properties).
	     */
	    isKeyPropertyTransient(_propertyName: string, _value: any): boolean;
	    /**
	     * Indicates if a property is a reverse reference.
	     * @param _propertyName The property name.
	     * @returns Always false (no reverse references).
	     */
	    isReverseReferenceProperty(_propertyName: string): boolean;
	    /**
	     * Gets the default order by clause for insights (by key properties).
	     * @returns The default order by object.
	     */
	    get defaultOrderBy(): OrderBy<Node>;
	    /**
	     * Gets the formatted key values as a string, concatenated by `~`.
	     * Used for the _id value.
	     * @param _context The context.
	     * @param values The key values.
	     * @returns The _id as a string.
	     */
	    getId(_context: Context, values: Dict<any>): string;
	    /**
	     * Indicates if creation is allowed.
	     * @param canCreate The flag.
	     * @returns The flag value.
	     */
	    canCreate(canCreate: boolean): boolean;
	    /**
	     * Indicates if update is allowed.
	     * @param canUpdate The flag.
	     * @returns The flag value.
	     */
	    canUpdate(canUpdate: boolean): boolean;
	    /**
	     * Indicates if deletion is allowed.
	     * @param canDelete The flag.
	     * @returns The flag value.
	     */
	    canDelete(canDelete: boolean): boolean;
	    /**
	     * Indicates if deleting many is allowed.
	     * @param canDeleteMany The flag.
	     * @returns The flag value.
	     */
	    canDeleteMany(canDeleteMany: boolean): boolean;
	}
	//# sourceMappingURL=insight-storage-manager.d.ts.map
}
declare module '@sage/xtrem-x3-copilot' {
	export * from '@sage/xtrem-x3-copilot/index';
}
