"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysInsight = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const x3SystemUtils = __importStar(require("@sage/xtrem-x3-system-utils"));
const x3Copilot = __importStar(require(".."));
const insight_storage_manager_1 = require("../classes/insight-storage-manager");
let SysInsight = class SysInsight extends xtrem_core_1.Node {
    static async saveToDisk(context) {
        await insight_storage_manager_1.InsightStorageManager.saveInsightsToDisk(context);
        return true;
    }
};
exports.SysInsight = SysInsight;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
        isStored: true,
        isPublished: true,
        dependsOn: ['screenId', 'type', 'key', 'query', 'package'],
        duplicatedValue: xtrem_core_1.useDefaultValue,
        async defaultValue() {
            // eslint-disable-next-line @sage/xtrem/property-decorators-warnings
            return (await insight_storage_manager_1.InsightStorageManager.getInsightFromNode(this)).hash;
        },
    })
], SysInsight.prototype, "hash", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysPackage,
        isPublished: true,
        duplicateRequiresPrompt: true,
    })
], SysInsight.prototype, "package", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
        isStored: true,
        isPublished: true,
        duplicateRequiresPrompt: true,
    })
], SysInsight.prototype, "screenId", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
        isStored: true,
        isPublished: true,
        duplicateRequiresPrompt: true,
    })
], SysInsight.prototype, "key", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        dataType: () => x3Copilot.enums.insightTypeDataType,
        isStored: true,
        isPublished: true,
        duplicateRequiresPrompt: true,
    })
], SysInsight.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isStored: true,
        isPublished: true,
    })
], SysInsight.prototype, "query", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        isPublished: true,
        parameters: [],
        return: {
            type: 'boolean',
        },
    })
], SysInsight, "saveToDisk", null);
exports.SysInsight = SysInsight = __decorate([
    xtrem_core_1.decorators.node({
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDuplicate: true,
        storage: 'external',
        externalStorageManager: new insight_storage_manager_1.InsightStorageManager(),
        keyPropertyNames: ['package', 'screenId', 'key'],
        indexes: [
            {
                orderBy: {
                    hash: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
            {
                orderBy: {
                    package: 1,
                    screenId: 1,
                    key: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysInsight);
//# sourceMappingURL=sys-insight.js.map