"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysCopilot = void 0;
const typesLib = __importStar(require("@sage/xtrem-decimal"));
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const handlebars = __importStar(require("handlebars"));
const sys_insight_1 = require("./sys-insight");
const logger = xtrem_core_1.Logger.getLogger(__filename, 'copilot');
let SysCopilot = class SysCopilot extends xtrem_core_1.Node {
    /**
     *  Returns the source app's version.
     *
     * @param context the context
     * @returns a synchronization feed
     */
    static async getInsightDataQueries(context, chatContext) {
        const parsedChatContext = JSON.parse(chatContext);
        const queries = await context.select(sys_insight_1.SysInsight, { screenId: true, key: true, type: true, query: true }, { filter: { screenId: parsedChatContext.screenId } });
        if (typesLib.gt(queries.length, 0)) {
            const mainQuery = queries.find(query => typesLib.strictEq(query.type, 'main'));
            let data = {};
            const transformedChatContext = {
                ...parsedChatContext,
                recordFilter: JSON.stringify(parsedChatContext.recordFilter).replace(/"/g, '\\"'),
            };
            if (mainQuery) {
                const compiled = handlebars.compile(mainQuery.query.value || '', { noEscape: true });
                const parsedMainQuery = compiled({
                    chatContext: transformedChatContext,
                });
                logger.verbose(() => `Copilot: Main query: ${parsedMainQuery}`);
                data = await context.executeGraphql(parsedMainQuery);
            }
            const resultQueries = [];
            queries
                .filter(query => typesLib.strictEq(query.type, 'data'))
                .forEach(query => {
                const compiled = handlebars.compile(query.query.value || '', { noEscape: true });
                const parsedQuery = compiled({
                    chatContext: transformedChatContext,
                    data,
                }).replaceAll('\n', ' ');
                logger.verbose(() => `Copilot: ${query.key} query: ${parsedQuery}`);
                resultQueries.push({
                    key: query.key,
                    query: xtrem_core_1.TextStream.fromString(parsedQuery, 'application/graphql'),
                });
            });
            return {
                data: JSON.stringify(data),
                queries: resultQueries,
            };
        }
        return Promise.resolve({});
    }
};
exports.SysCopilot = SysCopilot;
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'chatContext',
                type: 'string',
                isMandatory: true,
            },
        ],
        return: {
            type: 'object',
            properties: {
                data: { type: 'string', isMandatory: false },
                queries: {
                    type: 'array',
                    isMandatory: false,
                    item: { type: 'object', properties: { key: 'string', query: 'textStream' } },
                },
            },
        },
    })
], SysCopilot, "getInsightDataQueries", null);
exports.SysCopilot = SysCopilot = __decorate([
    xtrem_core_1.decorators.node({
        isPublished: true,
        storage: 'external',
        externalStorageManager: new xtrem_x3_gateway_1.DummyStorageManager(),
        keyPropertyNames: ['_id'],
    })
], SysCopilot);
//# sourceMappingURL=sys-copilot.js.map