/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,s){if(void 0===s)s=r;var i=Object.getOwnPropertyDescriptor(t,r);if(!i||("get"in i?!t.__esModule:i.writable||i.configurable))i={enumerable:true,get:function(){return t[r]}};Object.defineProperty(e,s,i)}:function(e,t,r,s){if(void 0===s)s=r;e[s]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:true,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var ownKeys=function(e){return ownKeys=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)if(Object.prototype.hasOwnProperty.call(e,r))t[t.length]=r;return t},ownKeys(e)};return function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r=ownKeys(e),s=0;s<r.length;s++)if("default"!==r[s])__createBinding(t,e,r[s]);return __setModuleDefault(t,e),t}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:true}),exports.InsightStorageManager=void 0;const typesLib=__importStar(require("@sage/xtrem-decimal")),sync_1=__importDefault(require("@prettier/sync")),xtrem_core_1=require("@sage/xtrem-core"),crypto=__importStar(require("crypto")),fs=__importStar(require("fs")),_=__importStar(require("lodash")),fsp=__importStar(require("path"));class InsightStorageManager{constructor(){this._lastTransientId=-1e9}static{this.isLoaded=false}static{this.insights=[]}static getHash(e){return crypto.createHash("SHA256").update(JSON.stringify({package:e.package,screenId:e.screenId,key:e.key})).digest("base64")}static getAllInsights(e){if(this.isLoaded)return this.insights;return this.loadingPromise=new Promise(t=>{const{application:r}=e,s=r.getPackages();this.insights=[];const i=[];s.forEach(e=>{const t=e.api;if(t.insights)Object.values(t.insights).forEach(t=>{const r={...t,package:"",hash:""};r.package=e.name,r.hash=this.getHash(r),i.push(r)})}),this.insights=i,this.isLoaded=true,t(this.insights)}),this.loadingPromise}static prettyifyTypescript(e){const t={parser:"typescript",singleQuote:true,printWidth:120,tabWidth:4,useTabs:false,semi:true,trailingComma:"all",arrowParens:"avoid",endOfLine:"lf",filepath:"dummy.ts"};return sync_1.default.format(e,t)}static async saveInsightsToDisk(e){const t=await InsightStorageManager.getAllInsights(e),{application:r}=e,s={};t.forEach(e=>{const{package:t}=e,i=r.packagesByName[t];if(i){const{dir:r}=i,a=fsp.join(r,"lib","insights");if(!s[t]){if(s[t]=[],fs.existsSync(a))fs.rmSync(a,{recursive:true,force:true});fs.mkdirSync(a,{recursive:true})}const n=_.kebabCase(`${e.screenId}-${e.key}`),c=fsp.join(a,`${n}.ts`),o=`export const ${_.camelCase(`${e.screenId}-${e.key}`)}: InsightQuery = {`,g=["import { InsightQuery } from '@sage/xtrem-x3-copilot';\n",o],h=" ".repeat(typesLib.add(o.length,1));g.push(`${h}screenId: '${e.screenId}',`),g.push(`${h}type: '${e.type}',`),g.push(`${h}key: '${e.key}',`),g.push(`${h}query: \`${e.query}\``),g.push(`${h}};`);const p=InsightStorageManager.prettyifyTypescript(g.join("\n")).replace(/\\/g,"\\\\");s[t].push(c),fs.writeFileSync(c,p,"utf8")}}),Object.entries(s).forEach(([e,t])=>{const s=r.packagesByName[e];if(s){const{dir:e}=s,r=fsp.join(e,"lib","insights"),i=fsp.join(r,"index.ts"),a=t.map(e=>{const t=fsp.basename(e,".ts");return`export { ${_.camelCase(t)} } from './${t}';`}),n=InsightStorageManager.prettyifyTypescript(a.join("\n"));fs.writeFileSync(i,n,"utf8");const c=fsp.join(e,"lib","index.ts"),o=fs.existsSync(c)?fs.readFileSync(c,"utf8"):"";if(!o.includes("export * as insights from './insights';")){const e="\nexport * as insights from './insights';",t=InsightStorageManager.prettyifyTypescript(typesLib.add(o,e));fs.writeFileSync(c,t,"utf8")}}})}static async getInsightFromNode(e){const t=await e.$.get("screenId"),r=await e.$.get("type"),s=await e.$.get("key"),i=await e.$.get("query"),a=await(await e.$.get("package")).$.get("name");if(!(t&&r&&s&&i&&a))throw new Error(`Invalid insight data: screenId: ${t}, type: ${r}, key: ${s}, query: ${i}, package: ${a}`);const n={screenId:t,type:r,key:s,query:i.value,package:a,hash:""};return n.hash=InsightStorageManager.getHash(n),n}async insert(e,t){const r=await InsightStorageManager.getInsightFromNode(e),s=await InsightStorageManager.getAllInsights(e.$.context);if(s.some(e=>typesLib.strictEq(e.hash,r.hash)))throw new Error(`Insight package: ${r.package}, screenId: ${r.screenId}, key: ${r.key} already exists.`);if(typesLib.strictEq(r.type,"main")&&s.some(e=>typesLib.strictEq(e.screenId,r.screenId)&&typesLib.strictEq(e.type,"main")))throw new Error(`Main insight for screenId: ${r.screenId} already exists.`);return InsightStorageManager.insights.push(r),{_id:r.hash,hash:r.hash}}async update(e,t){const r=await InsightStorageManager.getInsightFromNode(e),s=await InsightStorageManager.getAllInsights(e.$.context),i=s.findIndex(e=>typesLib.strictEq(e.hash,r.hash));if(typesLib.lt(i,0)){if(typesLib.strictEq(r.type,"main")&&s.some(e=>typesLib.strictEq(e.screenId,r.screenId)&&typesLib.strictEq(e.type,"main")))throw new Error(`Main insight for screenId: ${r.screenId} already exists.`);InsightStorageManager.insights.push(r)}else{if(typesLib.strictEq(r.type,"main")&&s.some(e=>typesLib.strictEq(e.screenId,r.screenId)&&typesLib.strictNe(e.hash,r.hash)&&typesLib.strictEq(e.type,"main")))throw new Error(`Main insight for screenId: ${r.screenId} already exists.`);InsightStorageManager.insights[i]=r}return[{_id:r.hash,hash:r.hash}]}async delete(e,t){const r=await InsightStorageManager.getInsightFromNode(e),s=await InsightStorageManager.getAllInsights(e.$.context),i=s.findIndex(e=>typesLib.strictEq(e.hash,r.hash));if(typesLib.lt(i,0))throw new Error(`Insight package: ${r.package}, screenId: ${r.screenId}, key: ${r.key} does not exist.`);if(typesLib.strictEq(r.type,"main")&&s.some(e=>typesLib.strictEq(e.screenId,r.screenId)&&typesLib.strictNe(e.type,"main")))throw new Error(`Cannot delete main insight for screenId: ${r.screenId} when other insights exist.`);return InsightStorageManager.insights.splice(i,1),1}query(e,t){let r;const getInsights=async t=>{const r=(await InsightStorageManager.getAllInsights(e)).map(e=>({_id:e.hash,hash:e.hash,screenId:e.screenId,type:e.type,key:e.key,query:e.query?xtrem_core_1.TextStream.fromString(e.query):xtrem_core_1.TextStream.empty,package:e.package}));return(await xtrem_core_1.RecordPaging.applyPagingOptions(this.factory,e,[...r],(e,t,r)=>r[t.name],t)).items};if(t.count){const readCount=async()=>{if(!r)return r=await getInsights({filters:t.filters}),r.length;return};return new xtrem_core_1.AsyncGenericReader({read:readCount,stop(){}})}const read=async()=>{if(!r)r=await getInsights(t);return r.pop()};return new xtrem_core_1.AsyncGenericReader({read,stop(){}})}mapRecordIn(e){return e}mapAggregateRecordIn(e){throw new Error("NYI: aggregates on insights")}getReferenceJoin(e){if(typesLib.strictEq(e,"package"))return{name:"package"};return{}}getCollectionJoin(e){return{}}async getJoinValues(e,t,r,s){if(typesLib.strictEq(r,"package"))return t[r]?{name:t[r]}:{name:await e.$.get("package")};return{}}parseOrderBy(e,t){return[]}parseCursor(e,t){return[]}allocateTransientId(){return this._lastTransientId=typesLib.sub(this._lastTransientId,1),String(this._lastTransientId)}getKeyValues(e,t,r){return{package:t.package,screenId:t.screenId,key:t.key}}isKeyPropertyTransient(e,t){return false}isReverseReferenceProperty(e){return false}get defaultOrderBy(){return this.factory.keyProperties.reduce((e,t)=>(e[t.name]=1,e),{})}getId(e,t){return String(t._id)}canCreate(e){return e}canUpdate(e){return e}canDelete(e){return e}canDeleteMany(e){return e}}exports.InsightStorageManager=InsightStorageManager;
//# sourceMappingURL=insight-storage-manager.js.map