"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.variableFilters = void 0;
exports.variableFilters = {
    and: (...filters) => (r) => filters.every(f => f(r)),
    or: (...filters) => (r) => filters.some(f => f(r)),
    not: (filter) => (r) => !filter(r),
    any: () => true,
    isBoolean: (r) => r.type === 'Boolean',
    isString: (r) => r.type === 'String',
    isNumeric: (r) => r.type === 'Decimal' || r.type === 'Float' || r.type === 'Int',
    isInteger: (r) => r.type === 'Int',
    isDate: (r) => r.type === 'Date',
    isDateTime: (r) => r.type === 'DateTime',
    isReference: (nodeName) => (r) => (r.type === 'Reference' ||
        r.type === 'IntReference' ||
        r.type === 'ExternalReference' ||
        r.type === 'IntOrString') &&
        (r.node === nodeName || nodeName == null),
    isAssignableTo(variable) {
        switch (variable.type) {
            case 'Boolean':
                return exports.variableFilters.isBoolean;
            case 'String':
                return exports.variableFilters.isString;
            case 'Decimal':
            case 'Float':
                return exports.variableFilters.isNumeric;
            case 'Int':
                return exports.variableFilters.isInteger;
            case 'Date':
                return exports.variableFilters.isDate;
            case 'DateTime':
                return exports.variableFilters.isDateTime;
            case 'Reference':
                return exports.variableFilters.isReference(variable.node);
            default:
                return exports.variableFilters.any;
        }
    },
    isOld(variable) {
        return variable.path.startsWith('$old.');
    },
};
//# sourceMappingURL=workflow.js.map