import { NodeDetails } from './ui-shared-types';
export interface WorkflowNode {
    key: string;
    title: string;
    description: string;
    color: string;
    icon: string;
    configurationPage: string;
    type: string;
    defaultConfig: string;
}
export interface WorkflowError {
    stepId: string;
    message: string;
}
export type WorkflowVariableType = NodeDetails['type'];
export interface WorkflowVariable {
    title: string;
    path: string;
    type: WorkflowVariableType;
    node?: string;
    enumType?: string;
    enumValues?: string[];
    /**
     * Is the variable a custom field ?
     */
    isCustom?: boolean;
}
export type VariableFilter = (r: WorkflowVariable) => boolean;
export declare const variableFilters: {
    and: (...filters: VariableFilter[]) => (r: WorkflowVariable) => boolean;
    or: (...filters: VariableFilter[]) => (r: WorkflowVariable) => boolean;
    not: (filter: VariableFilter) => (r: WorkflowVariable) => boolean;
    any: () => boolean;
    isBoolean: (r: WorkflowVariable) => boolean;
    isString: (r: WorkflowVariable) => boolean;
    isNumeric: (r: WorkflowVariable) => boolean;
    isInteger: (r: WorkflowVariable) => boolean;
    isDate: (r: WorkflowVariable) => boolean;
    isDateTime: (r: WorkflowVariable) => boolean;
    isReference: (nodeName?: string) => (r: WorkflowVariable) => boolean;
    isAssignableTo(variable: WorkflowVariable): VariableFilter;
    isOld(variable: WorkflowVariable): boolean;
};
//# sourceMappingURL=workflow.d.ts.map