"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validator = void 0;
exports.validator = {
    isAlphaNumericName(value, options) {
        if (!/^[a-zA-Z]\w*$/.test(value)) {
            if (options?.throw)
                throw new Error(`Invalid ${options?.throw.name} value: '${value}'.`);
            return false;
        }
        return true;
    },
    isEmail(value, options) {
        // from https://owasp.org/www-community/OWASP_Validation_Regex_Repository
        if (!/^[a-zA-Z0-9_+&*-]+(?:\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}$/.test(value)) {
            if (options?.throw)
                throw new Error(`Invalid ${options?.throw.name} value: '${value}'.`);
            return false;
        }
        return true;
    },
};
//# sourceMappingURL=validator.js.map