import type { DeepPartial } from 'ts-essentials';
import { IsStrictlyAny } from './ui-shared-types';
export { DeepPartial };
export declare const pascalCase: (s: string) => string;
/**
 * Converts an identifier to a title
 * Lodash startCase does it but it capitalizes every word. We only want to capitalize the first one.
 */
export declare function titleCase(str: string | undefined): string;
/**
 * Type name for the graphql schema
 * @param fullName fully qualified name in the form of @vendor/package/ArtifactName. Example: @sage/x3-sales/SalesOrder
 */
export declare function schemaTypeName(fullName: string, suffix?: string): string;
export declare function nameToSqlName(name: string): string;
/** Useful to make OR condition between properties in our interface. If we put the two properties Typescript returns an a type error.
 * E.G RequireOnlyOne<interface, 'key1' | 'key2'> */
export declare type RequireOnlyOne<T, Keys extends keyof T = keyof T> = Pick<T, Exclude<keyof T, Keys>> & {
    [K in Keys]-?: Required<Pick<T, K>> & Partial<Record<Exclude<Keys, K>, undefined>>;
}[Keys];
/**
 * @TJS-additionalProperties true
 */
export interface Dict<T> {
    [key: string]: T;
}
/**
 * A JSON value (string, boolean, number, null, array, plain object)
 */
export type Json = string | boolean | number | null | Json[] | Dict<Json>;
export type MakeAllRequired<T> = {
    [P in keyof T]-?: MakeAllRequired<NonNullable<T[P]>>;
};
/**
 * Flattens an input object into a one-level deep object
 * having as keys dot-notated strings that represent object paths.
 * E.g.
 *
 * { a: 'a', b: { c: 'c', d: { e: 'e' } } } => { a: 'a', 'b.c': 'c', 'b.d.e': 'e' }
 *
 *
 * @export
 * @param {object} [obj={}] the input object
 * @param {string} [prefix=''] an optional prefix
 * @param {string} [suffix=''] an optional suffix
 * @returns {Dict<string>} a dot-notated object with paths as keys
 */
export declare function flat(obj?: object, prefix?: string, suffix?: string): Dict<string>;
export type Maybe<T> = T | undefined;
/**
 * Remove all the instrumentation code added by the code coverage
 * @param str
 */
export declare function removeCodeCoverageInstrumentation(str: string): string;
/**
 * Access status values
 * - authorized - user is authorized to access the property or operation
 * - unauthorized - user is unauthorized to access the property or operation
 * - unavailable - property or operation is disabled by a service option
 * - readonly - property is readonly
 * - inactive - operation is inactive
 */
export type AccessStatus = 'authorized' | 'unauthorized' | 'unavailable' | 'readonly' | 'inactive';
export type PromisifyProperties<T> = {
    [K in keyof T]: Promise<T[K] | T[K]>;
};
export interface ArrayMoveResult<R> {
    success?: boolean;
    data: R[];
}
export declare const deepMerge: <T = any>(first: T, second: T | DeepPartial<T>, useArrayAsStart?: boolean, overrideArrays?: boolean) => T;
export declare function arrayMoveMutable<T>(array: T[], fromIndex: number, toIndex: number): void;
export declare function arrayMoveImmutable<T>(array: T[], fromIndex: number, toIndex: number): T[];
export declare function arrayMovePreservingOrder<R extends Record<string, any>, K extends keyof R>({ fromIndex, toValue, orderByKey, data, }: {
    fromIndex: number;
    toValue: R[K];
    orderByKey: K;
    data: R[];
}): ArrayMoveResult<R>;
export type KeysOfValue<T, Condition> = {
    [K in keyof T]: T[K] extends Condition ? K : never;
}[keyof T];
export declare function arrayOrderContiguous<R extends {
    _id: string;
}, K extends KeysOfValue<R, number>>({ orderedData, key, }: {
    orderedData: R[];
    key: K;
}): {
    columnId: K;
    rowId: string;
    value: R[K];
    rowData: R;
}[];
export declare function remapObjectByKey(obj: any, keyToRemap: string, remapFunction: (value: any) => any): any;
export type MakeNodeType<T> = {
    [Prop in Exclude<keyof T, '_id'>]: T[Prop] extends Promise<{
        _sourceId: Promise<string>;
        _etag: Promise<string>;
    }> ? Promise<MakeNodeType<T[Prop]>> : T[Prop] extends Promise<any> ? T[Prop] : Promise<T[Prop]>;
} & {
    _id: string | number;
};
export declare function defaultStringCompare(s1: string, s2: string): number;
export type StringKeyMapper<T> = {
    [K in keyof T]: K extends string ? K : K extends number ? `${K}` : never;
}[keyof T];
export type KeyCaster<T, M> = keyof {
    [K in M as keyof T]: any;
} & string;
export type KeysOf<T> = IsStrictlyAny<T> extends true ? KeyCaster<T, StringKeyMapper<T>> : T extends readonly unknown[] ? number extends T['length'] ? KeyCaster<T[number], StringKeyMapper<T>> : keyof T & `${number}` : T extends object ? KeyCaster<T, StringKeyMapper<T>> : never;
export declare function objectKeys<T = any>(obj: T): KeysOf<T>[];
export type NotAny<T> = T[] extends true[] ? T : T[] extends false[] ? T : never;
export type AssertMatch<T, Expected> = NotAny<T extends Expected ? true : false>;
declare class ExtraPropertiesError<T> {
    protected never: T;
}
export type Exact<T1, T2> = T1 extends T2 ? Exclude<keyof T1, keyof T2> extends never ? T1 : ExtraPropertiesError<T2> : never;
export declare function strictTypeMatch<T, Expected>(_arg: AssertMatch<T, Exact<T, Expected>>): void;
export declare function typeMatch<T, Expected>(_arg: AssertMatch<T, Expected>): void;
export interface Unit {
    symbol?: string;
    id?: string;
    decimalDigits?: number;
}
//# sourceMappingURL=util.d.ts.map