"use strict";
/**
 * This file contains types that are shared between the xtrem-ui, xtrem-ui-components and other front-end folder files.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ATTR_BREAK_PAGE_AFTER = exports.BLOCK_AGGREGATION_ROLLING_PROPERTY_NAME = exports.BLOCK_AGGREGATION_PROPERTY_NAME = exports.PROPERTY_CLASS = exports.QUERY_TABLE_CLASS = exports.RECORD_CONTEXT_CLASS = exports.ATTR_PROPERTY_PARENT_CONTEXT_TYPE = exports.ATTR_QUERY_TABLE_HIDDEN_ROW = exports.ATTR_FOOTER_GROUP = exports.ATTR_ALIAS = exports.ATTR_PROPERTY_DATA_TYPE = exports.ATTR_PROPERTY_DATA_FORMAT = exports.ATTR_PROPERTY_NAME = exports.ATTR_PROPERTY_DISPLAY_LABEL = exports.ATTR_CONTEXT_LIST_ORDER = exports.ATTR_CONTEXT_CONDITION = exports.ATTR_CONTEXT_FILTER = exports.ATTR_CONTEXT_OBJECT_PATH = exports.ATTR_CONTEXT_OBJECT_TYPE = exports.presentationEditorGraphqlMapping = exports.presentationGraphqlMapping = exports.numericFields = exports.FieldKey = exports.filterGraphqlMapping = exports.EnumType = exports.stringFilter = exports.rangeFilter = exports.emptyOrNotEmpty = exports.equalOrNotEqual = exports.enumFilter = exports.RANGE_DIVIDER = exports.NOT_EMPTY = exports.EMPTY = exports.SET = exports.MULTI_NOT_EQUALS = exports.NOT_EQUALS = exports.EQUALS = exports.MATCHES = exports.NOT_CONTAINS = exports.ENDS_WITH = exports.STARTS_WITH = exports.CONTAINS = exports.GREATER_THAN_EQUAL = exports.GREATER_THAN = exports.MULTIPLE_RANGE = exports.RANGE = exports.LESS_THAN_EQUAL = exports.LESS_THAN = exports.textStreams = exports.GraphQLTypes = void 0;
exports.sortingTranslations = exports.aggregationTranslations = exports.sortingGraphqlMapping = exports.aggregationsGraphqlMapping = exports.OTHER_AGGREGATIONS = exports.DATE_AGGREGATIONS = exports.NUMBER_AGGREGATIONS = exports.STRING_AGGREGATIONS = exports.SORTING_OPTIONS = exports.Sortings = exports.Aggregations = exports.ATTR_CLASS = void 0;
const lodash_1 = require("lodash");
// eslint-disable-next-line @typescript-eslint/naming-convention
var GraphQLTypes;
(function (GraphQLTypes) {
    GraphQLTypes["Boolean"] = "Boolean";
    GraphQLTypes["Date"] = "Date";
    GraphQLTypes["DateTime"] = "datetime";
    GraphQLTypes["Decimal"] = "Decimal";
    GraphQLTypes["Enum"] = "Enum";
    GraphQLTypes["ExternalReference"] = "ExternalReference";
    GraphQLTypes["Float"] = "Float";
    GraphQLTypes["Id"] = "Id";
    GraphQLTypes["_InputStream"] = "_InputStream";
    GraphQLTypes["_InputTextStream"] = "_InputTextStream";
    GraphQLTypes["_OutputTextStream"] = "_OutputTextStream";
    GraphQLTypes["Int"] = "Int";
    GraphQLTypes["IntOrString"] = "IntOrString";
    GraphQLTypes["IntReference"] = "IntReference";
    GraphQLTypes["Json"] = "Json";
    GraphQLTypes["String"] = "String";
    GraphQLTypes["Collection"] = "Collection";
})(GraphQLTypes || (exports.GraphQLTypes = GraphQLTypes = {}));
exports.textStreams = [GraphQLTypes._OutputTextStream, GraphQLTypes._InputTextStream];
exports.LESS_THAN = 'lessThan';
exports.LESS_THAN_EQUAL = 'lessThanOrEqual';
exports.RANGE = 'inRange';
exports.MULTIPLE_RANGE = 'multipleRange';
exports.GREATER_THAN = 'greaterThan';
exports.GREATER_THAN_EQUAL = 'greaterThanOrEqual';
exports.CONTAINS = 'contains';
exports.STARTS_WITH = 'startsWith';
exports.ENDS_WITH = 'endsWith';
exports.NOT_CONTAINS = 'notContains';
exports.MATCHES = 'matches'; // Regex
exports.EQUALS = 'equals'; // Exact match
exports.NOT_EQUALS = 'notEqual';
exports.MULTI_NOT_EQUALS = 'multiNotEqual';
exports.SET = 'set';
exports.EMPTY = 'empty';
exports.NOT_EMPTY = 'notEmpty';
exports.RANGE_DIVIDER = '~';
exports.enumFilter = [exports.SET, exports.MULTI_NOT_EQUALS];
exports.equalOrNotEqual = [exports.EQUALS, exports.NOT_EQUALS];
exports.emptyOrNotEmpty = [exports.EMPTY, exports.NOT_EMPTY];
exports.rangeFilter = [
    exports.LESS_THAN,
    exports.LESS_THAN_EQUAL,
    exports.EQUALS,
    exports.NOT_EQUALS,
    exports.GREATER_THAN,
    exports.GREATER_THAN_EQUAL,
    exports.RANGE,
];
exports.stringFilter = [
    exports.CONTAINS,
    exports.ENDS_WITH,
    exports.EQUALS,
    exports.GREATER_THAN_EQUAL,
    exports.GREATER_THAN,
    exports.LESS_THAN_EQUAL,
    exports.LESS_THAN,
    exports.MATCHES,
    exports.NOT_EQUALS,
    exports.SET,
    exports.STARTS_WITH,
    exports.EMPTY,
    exports.NOT_EMPTY,
    exports.NOT_CONTAINS,
];
class EnumType {
}
exports.EnumType = EnumType;
exports.filterGraphqlMapping = {
    [GraphQLTypes.Boolean]: [exports.MATCHES],
    [GraphQLTypes.Date]: [...exports.rangeFilter, ...exports.emptyOrNotEmpty],
    [GraphQLTypes.DateTime]: [...exports.rangeFilter, ...exports.emptyOrNotEmpty],
    [GraphQLTypes.Decimal]: [...exports.rangeFilter, ...exports.emptyOrNotEmpty],
    [GraphQLTypes.Enum]: exports.enumFilter,
    [GraphQLTypes.ExternalReference]: undefined,
    [GraphQLTypes.Float]: [...exports.rangeFilter, ...exports.emptyOrNotEmpty],
    [GraphQLTypes.Id]: exports.equalOrNotEqual,
    [GraphQLTypes._InputStream]: undefined,
    [GraphQLTypes._OutputTextStream]: undefined,
    [GraphQLTypes._InputTextStream]: undefined,
    [GraphQLTypes.Int]: [...exports.rangeFilter, ...exports.emptyOrNotEmpty],
    [GraphQLTypes.IntOrString]: exports.equalOrNotEqual,
    [GraphQLTypes.IntReference]: exports.equalOrNotEqual,
    [GraphQLTypes.Json]: undefined,
    [GraphQLTypes.String]: exports.stringFilter.filter(f => f !== exports.MATCHES && f !== exports.SET),
    [GraphQLTypes.Collection]: undefined,
};
var FieldKey;
(function (FieldKey) {
    FieldKey["Aggregate"] = "Aggregate";
    FieldKey["Button"] = "Button";
    FieldKey["Calendar"] = "Calendar";
    FieldKey["Card"] = "Card";
    FieldKey["Chart"] = "Chart";
    FieldKey["Checkbox"] = "Checkbox";
    FieldKey["ContentTable"] = "ContentTable";
    FieldKey["Count"] = "Count";
    FieldKey["Date"] = "Date";
    FieldKey["DetailList"] = "DetailList";
    FieldKey["DropdownList"] = "DropdownList";
    FieldKey["DynamicSelect"] = "DynamicSelect";
    FieldKey["DynamicPod"] = "DynamicPod";
    FieldKey["File"] = "File";
    FieldKey["FileDeposit"] = "FileDeposit";
    FieldKey["FilterEditor"] = "FilterEditor";
    FieldKey["FilterSelect"] = "FilterSelect";
    FieldKey["FormDesigner"] = "FormDesigner";
    FieldKey["Icon"] = "Icon";
    FieldKey["Image"] = "Image";
    FieldKey["Label"] = "Label";
    FieldKey["Link"] = "Link";
    FieldKey["Message"] = "Message";
    FieldKey["MultiDropdown"] = "MultiDropdown";
    FieldKey["MultiFileDeposit"] = "MultiFileDeposit";
    FieldKey["MultiReference"] = "MultiReference";
    FieldKey["NestedGrid"] = "NestedGrid";
    FieldKey["NodeBrowserTree"] = "NodeBrowserTree";
    FieldKey["Numeric"] = "Numeric";
    FieldKey["Preview"] = "Preview";
    FieldKey["Plugin"] = "Plugin";
    FieldKey["Pod"] = "Pod";
    FieldKey["PodCollection"] = "PodCollection";
    FieldKey["Progress"] = "Progress";
    FieldKey["Radio"] = "Radio";
    FieldKey["Reference"] = "Reference";
    FieldKey["RelativeDate"] = "RelativeDate";
    FieldKey["RichText"] = "RichText";
    FieldKey["Select"] = "Select";
    FieldKey["SelectionCard"] = "SelectionCard";
    FieldKey["Separator"] = "Separator";
    FieldKey["StaticContent"] = "StaticContent";
    FieldKey["StepSequence"] = "StepSequence";
    FieldKey["Switch"] = "Switch";
    FieldKey["Table"] = "Table";
    FieldKey["TableSummary"] = "TableSummary";
    FieldKey["Technical"] = "Technical";
    FieldKey["TechnicalJson"] = "TechnicalJson";
    FieldKey["Text"] = "Text";
    FieldKey["TextArea"] = "TextArea";
    FieldKey["Time"] = "Time";
    FieldKey["Datetime"] = "Datetime";
    FieldKey["DatetimeRange"] = "DatetimeRange";
    FieldKey["Toggle"] = "ToggleButton";
    FieldKey["Tree"] = "Tree";
    FieldKey["VisualProcess"] = "VisualProcess";
    FieldKey["VitalPod"] = "VitalPod";
    FieldKey["Workflow"] = "Workflow";
})(FieldKey || (exports.FieldKey = FieldKey = {}));
const numericPresentation = [FieldKey.Numeric, FieldKey.Label, FieldKey.Text, FieldKey.Progress];
const numericEditorPresentation = [FieldKey.Numeric];
exports.numericFields = [
    GraphQLTypes.Decimal,
    GraphQLTypes.Float,
    GraphQLTypes.Int,
    GraphQLTypes.IntReference,
];
const datePresentation = [FieldKey.Date];
const textPresentation = [FieldKey.Text];
const collectionPresentation = [
    FieldKey.Table,
    FieldKey.TableSummary,
    FieldKey.Tree,
    FieldKey.PodCollection,
    FieldKey.NestedGrid,
];
exports.presentationGraphqlMapping = {
    [GraphQLTypes.Boolean]: [FieldKey.Checkbox],
    [GraphQLTypes.Date]: datePresentation,
    [GraphQLTypes.DateTime]: datePresentation,
    [GraphQLTypes.Decimal]: numericPresentation,
    [GraphQLTypes.Enum]: [FieldKey.Text, FieldKey.Label],
    [GraphQLTypes.ExternalReference]: textPresentation,
    [GraphQLTypes.Float]: numericPresentation,
    ID: textPresentation,
    InputStream: textPresentation,
    [GraphQLTypes._InputTextStream]: textPresentation,
    [GraphQLTypes._OutputTextStream]: textPresentation,
    [GraphQLTypes._InputStream]: textPresentation,
    [GraphQLTypes.Int]: numericPresentation,
    [GraphQLTypes.IntOrString]: textPresentation,
    [GraphQLTypes.Id]: textPresentation,
    [GraphQLTypes.IntReference]: numericPresentation,
    [GraphQLTypes.Json]: textPresentation,
    [GraphQLTypes.String]: textPresentation,
    [GraphQLTypes.Collection]: collectionPresentation,
};
exports.presentationEditorGraphqlMapping = {
    [GraphQLTypes.Boolean]: [FieldKey.Checkbox],
    [GraphQLTypes.Date]: datePresentation,
    [GraphQLTypes.DateTime]: datePresentation,
    [GraphQLTypes.Decimal]: numericEditorPresentation,
    [GraphQLTypes.Enum]: [FieldKey.Text, FieldKey.Label],
    [GraphQLTypes.ExternalReference]: textPresentation,
    [GraphQLTypes.Float]: numericEditorPresentation,
    ID: textPresentation,
    [GraphQLTypes._InputStream]: textPresentation,
    InputStream: textPresentation,
    [GraphQLTypes._OutputTextStream]: textPresentation,
    [GraphQLTypes._InputTextStream]: textPresentation,
    [GraphQLTypes.Int]: numericEditorPresentation,
    [GraphQLTypes.IntOrString]: textPresentation,
    [GraphQLTypes.Id]: textPresentation,
    [GraphQLTypes.IntReference]: numericEditorPresentation,
    [GraphQLTypes.Json]: textPresentation,
    [GraphQLTypes.String]: textPresentation,
    [GraphQLTypes.Collection]: collectionPresentation,
};
exports.ATTR_CONTEXT_OBJECT_TYPE = 'data-context-object-type';
exports.ATTR_CONTEXT_OBJECT_PATH = 'data-context-object-path';
exports.ATTR_CONTEXT_FILTER = 'data-context-filter';
exports.ATTR_CONTEXT_CONDITION = 'data-context-condition';
exports.ATTR_CONTEXT_LIST_ORDER = 'data-context-list-order';
exports.ATTR_PROPERTY_DISPLAY_LABEL = 'data-property-display-label';
exports.ATTR_PROPERTY_NAME = 'data-property-name';
exports.ATTR_PROPERTY_DATA_FORMAT = 'data-property-data-format';
exports.ATTR_PROPERTY_DATA_TYPE = 'data-property-data-type';
exports.ATTR_ALIAS = 'data-alias';
exports.ATTR_FOOTER_GROUP = 'data-footer-group';
exports.ATTR_QUERY_TABLE_HIDDEN_ROW = 'data-hidden';
/** Used for ensuring integrity of the context and their children when the properties are dragged or copied */
exports.ATTR_PROPERTY_PARENT_CONTEXT_TYPE = 'data-property-parent-context';
exports.RECORD_CONTEXT_CLASS = 'record-context';
exports.QUERY_TABLE_CLASS = 'query-table';
exports.PROPERTY_CLASS = 'property';
exports.BLOCK_AGGREGATION_PROPERTY_NAME = '_blockAggregatedData';
exports.BLOCK_AGGREGATION_ROLLING_PROPERTY_NAME = '_blockAggregatedRollingData';
exports.ATTR_BREAK_PAGE_AFTER = 'data-break-page-after';
exports.ATTR_CLASS = 'class';
var Aggregations;
(function (Aggregations) {
    Aggregations["min"] = "min";
    Aggregations["max"] = "max";
    Aggregations["sum"] = "sum";
    Aggregations["avg"] = "avg";
    Aggregations["distinctCount"] = "distinctCount";
})(Aggregations || (exports.Aggregations = Aggregations = {}));
var Sortings;
(function (Sortings) {
    Sortings["ascending"] = "ascending";
    Sortings["descending"] = "descending";
})(Sortings || (exports.Sortings = Sortings = {}));
exports.SORTING_OPTIONS = [Sortings.ascending, Sortings.descending];
exports.STRING_AGGREGATIONS = [Aggregations.distinctCount];
exports.NUMBER_AGGREGATIONS = [
    Aggregations.min,
    Aggregations.max,
    Aggregations.sum,
    Aggregations.avg,
    Aggregations.distinctCount,
];
exports.DATE_AGGREGATIONS = [Aggregations.min, Aggregations.max, Aggregations.distinctCount];
exports.OTHER_AGGREGATIONS = [Aggregations.distinctCount];
exports.aggregationsGraphqlMapping = {
    [GraphQLTypes.Boolean]: [Aggregations.distinctCount],
    [GraphQLTypes.Date]: exports.DATE_AGGREGATIONS,
    [GraphQLTypes.DateTime]: exports.DATE_AGGREGATIONS,
    [GraphQLTypes.Decimal]: exports.NUMBER_AGGREGATIONS,
    [GraphQLTypes.Enum]: [Aggregations.distinctCount],
    [GraphQLTypes.ExternalReference]: [Aggregations.distinctCount],
    [GraphQLTypes.Float]: exports.NUMBER_AGGREGATIONS,
    [GraphQLTypes.Id]: exports.NUMBER_AGGREGATIONS,
    [GraphQLTypes._InputStream]: [Aggregations.distinctCount],
    [GraphQLTypes._OutputTextStream]: undefined,
    [GraphQLTypes._InputTextStream]: undefined,
    [GraphQLTypes.Int]: exports.NUMBER_AGGREGATIONS,
    [GraphQLTypes.IntOrString]: [Aggregations.distinctCount],
    [GraphQLTypes.IntReference]: [Aggregations.distinctCount],
    [GraphQLTypes.Json]: [Aggregations.distinctCount],
    [GraphQLTypes.String]: exports.STRING_AGGREGATIONS,
    [GraphQLTypes.Collection]: undefined,
};
exports.sortingGraphqlMapping = {
    [GraphQLTypes.Boolean]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Date]: exports.SORTING_OPTIONS,
    [GraphQLTypes.DateTime]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Decimal]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Enum]: exports.SORTING_OPTIONS,
    [GraphQLTypes.ExternalReference]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Float]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Id]: exports.SORTING_OPTIONS,
    [GraphQLTypes._InputStream]: exports.SORTING_OPTIONS,
    [GraphQLTypes._OutputTextStream]: undefined,
    [GraphQLTypes._InputTextStream]: undefined,
    [GraphQLTypes.Int]: exports.SORTING_OPTIONS,
    [GraphQLTypes.IntOrString]: exports.SORTING_OPTIONS,
    [GraphQLTypes.IntReference]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Json]: exports.SORTING_OPTIONS,
    [GraphQLTypes.String]: exports.SORTING_OPTIONS,
    [GraphQLTypes.Collection]: undefined,
};
exports.aggregationTranslations = (0, lodash_1.memoize)((localize) => ({
    [Aggregations.min]: localize('@sage/xtrem-ui/minimum', 'Minimum'),
    [Aggregations.max]: localize('@sage/xtrem-ui/maximum', 'Maximum'),
    [Aggregations.sum]: localize('@sage/xtrem-ui/sum', 'Sum'),
    [Aggregations.avg]: localize('@sage/xtrem-ui/average', 'Average'),
    [Aggregations.distinctCount]: localize('@sage/xtrem-ui/distinct-count', 'Distinct count'),
}));
exports.sortingTranslations = (0, lodash_1.memoize)((localize) => ({
    [Sortings.ascending]: localize('@sage/xtrem-ui-components/ascending', 'Ascending'),
    [Sortings.descending]: localize('@sage/xtrem-ui-components/descending', 'Descending'),
}));
//# sourceMappingURL=ui-shared-types.js.map