"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageName = getPackageName;
exports.getPackageQueueName = getPackageQueueName;
exports.limitSqsQueueName = limitSqsQueueName;
function getPackageName(packageJson) {
    return packageJson.xtrem?.packageName || packageJson.name;
}
function getPackageQueueName(packageJson) {
    if (!packageJson.xtrem?.queue) {
        throw new Error(`No queue name defined for package ${packageJson.name}, please set the queue property of the xtrem section in the package.json file.`);
    }
    return packageJson.xtrem?.queue;
}
/**
 * Limits the length of an SQS queue name to 75 characters, 80 with the .fifo extension.
 * If the name is already 75 characters or less, it is returned as is.
 * If the name is longer than 75 characters, it is truncated and appended with "---" in the middle.
 * @param name - The original queue name.
 * @returns The modified queue name.
 */
function limitSqsQueueName(name) {
    // limit is 80 with .fifo suffix. So limit to 75
    if (name.length <= 75)
        return name;
    return `${name.substring(0, 36)}---${name.substring(name.length - 36)}`;
}
//# sourceMappingURL=package.js.map