import { Dict } from './util';
export declare const locales: readonly ["en-US", "en-GB", "fr-FR", "es-ES", "pt-PT", "pt-BR", "ar-SA", "de-DE", "it-IT", "pl-PL", "zh-CN"];
export type Locale = (typeof locales)[number];
export type LocalizeLocale = Locale | 'base';
export declare const supportedLocales: LocalizeLocale[];
export type LocaleFallbacks = {
    [key in LocalizeLocale]: LocalizeLocale[];
};
/**
 * A JSON object that contains localized texts, indexed by locale.
 */
export type LocalizedText = Dict<string>;
export declare const localeFallbacks: LocaleFallbacks;
export interface LocalizeFunction {
    (key: string, _template: string, data?: object | any[], locale?: LocalizeLocale): string;
}
export interface LocalizeEnumFunction {
    (enumFullPathName: string, memberName: string): string;
}
/**
 * Extracts the text for the given locale from a LocalizedText object.
 * @param localizedText The JSON object that contains all the texts, indexed by locale.
 * @param locale The locale to extract the text for.
 */
export declare function getTextForLocale(localizedText: LocalizedText | undefined, locale: Locale | string | null): string | null;
/**
 * Merge the text for the given locale with the existing translations.
 *
 * @param localizedText The translations for the different locales.
 * @param textForLocale The text for the current locale.
 * @param locale The current locale.
 * @returns The merged translations.
 */
export declare function mergeLocalizedText(localizedText: LocalizedText | undefined, textForLocale: string | null | undefined, locale: Locale | string | null): LocalizedText;
//# sourceMappingURL=locale.d.ts.map