import type { BuiltInParserName, LiteralUnion } from 'prettier';
export declare const handleBars: (template: string, data?: any) => {
    result: string;
    variables: string[];
};
export declare const format: (literal: string, locale: string, data?: object | any[], noEscape?: boolean) => string;
export declare const dotNotate: (input: any, prefix?: string, target?: any) => any;
/**
 * Parses an object with JSON.parse. If JSON is not valid it returns defaultValue.
 *
 * @param {*} input
 * @returns {*}
 */
export declare const tryJsonParse: (input: string, defaultValue?: undefined) => any;
export declare const isJson: (input: string) => boolean;
/**
 * Code-formats a string using prettier standalone
 *
 * @param {string} input
 * @param {BuiltInParserName} parser
 * @returns {string}
 */
export declare const prettify: (input: string, parser: Extract<LiteralUnion<BuiltInParserName>, "html" | "css" | "json">) => Promise<string>;
//# sourceMappingURL=format-string.d.ts.map