"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rethrownError = rethrownError;
exports.withRethrow = withRethrow;
exports.asyncFireAndForget = asyncFireAndForget;
const errors_1 = require("./errors");
function rethrownError(mapped, cause) {
    if (mapped === cause)
        return mapped;
    if (mapped instanceof errors_1.BaseError && mapped.innerError === cause)
        return mapped;
    // mapError did not set cause correctly, so we wrap again to preserve cause
    // If we get this error we have to fix mapError because the error class is not being preserved.
    const remapped = new errors_1.SystemError(mapped.message, cause);
    return new errors_1.SystemError('invalid cause in rethrown error', remapped);
}
function withRethrow(body, mapError) {
    try {
        const result = body();
        if (result instanceof Promise) {
            return result.catch(error => {
                throw rethrownError(mapError(error), error);
            });
        }
        return result;
    }
    catch (error) {
        if (error instanceof errors_1.InterruptException)
            throw error;
        throw rethrownError(mapError(error), error);
    }
}
function asyncFireAndForget(fn, errorMessage, logger = console) {
    fn().catch(error => logger.error(new errors_1.SystemError(errorMessage, error)));
}
//# sourceMappingURL=error-helpers.js.map