import { AnyValue, AsyncResponse } from '@sage/xtrem-core';
export declare enum ExecutionMode {
    STANDALONE = "STANDALONE",
    INTEGRATED = "INTEGRATED"
}
export declare const plural: (a: string, b: string, count: number) => string;
/**
 * Raise an error when the command line could not be processed
 */
export declare function raiseErrorOnInvalidCommandLine(): never;
export declare const quitWithError: (mode: ExecutionMode, error: string | Error) => never;
export declare const printSuccess: (mode: ExecutionMode, message: string, logDuration?: boolean) => void;
export declare const printInfo: (mode: ExecutionMode, message: string) => void;
export declare const printWarning: (mode: ExecutionMode, message: string) => void;
export declare const printError: (mode: ExecutionMode, message: string) => void;
export declare const withTiming: <T extends AnyValue | void>(mode: ExecutionMode, options: {
    before?: () => string;
    body: () => AsyncResponse<T>;
    success?: (result: T) => string;
    fail?: (err: Error) => string;
}) => Promise<T>;
export declare const isDebugging: boolean;
//# sourceMappingURL=common.d.ts.map