import { ExecutionMode } from './utils';
export interface CliContext {
    executionMode: ExecutionMode;
    dir: string;
    withExecutionMode: (executionMode: ExecutionMode, body: () => void) => void;
}
declare class CliContextConcret implements CliContext {
    #private;
    constructor(executionMode: ExecutionMode, dir: string, options?: Record<string, any>);
    get executionMode(): ExecutionMode;
    set executionMode(executionMode: ExecutionMode);
    get options(): Record<string, any>;
    set options(options: Record<string, any>);
    get dir(): string;
    set dir(dir: string);
    withExecutionMode(executionMode: ExecutionMode, body: () => void): void;
    printSuccess(message: string, logDuration?: boolean): void;
    printInfo(message: string): void;
    printWarning(message: string): void;
    printError(message: string): void;
}
export declare const cliContext: CliContextConcret;
export {};
//# sourceMappingURL=cli-context.d.ts.map