"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xtrem_deployment_1 = require("@sage/xtrem-deployment");
const node_crypto_1 = require("node:crypto");
const dynamoDBAsyncContextRepository_1 = require("./dynamoDBAsyncContextRepository");
const asyncContextXtremRepository_1 = require("../asyncContextXtremRepository");
const persistableAsyncContext_1 = require("../../business/persistableAsyncContext");
/***
 * Used by xtrem to manipulate async contexts
 */
class XtremAsyncContextProvider extends asyncContextXtremRepository_1.AsyncContextXtremRepository {
    dynamoDbRegistry;
    thirdPartyConfig;
    constructor(config, thirdPartyConfig) {
        super();
        this.dynamoDbRegistry = new dynamoDBAsyncContextRepository_1.DynamoDBAsyncContextRepository(config);
        this.thirdPartyConfig = thirdPartyConfig;
    }
    createAsyncContext(context) {
        return this.dynamoDbRegistry.createAsyncContext(new persistableAsyncContext_1.PersistableAsyncContext(context));
    }
    deleteAsyncContext(contextId) {
        return this.dynamoDbRegistry.deleteAsyncContext(contextId);
    }
    getAsyncContext(contextId) {
        return this.dynamoDbRegistry.getAsyncContext(contextId);
    }
    async createThirdPartyCallbackAsyncContext(callbackContext) {
        if (!this.thirdPartyConfig || !this.thirdPartyConfig.callbackUrl || !this.thirdPartyConfig.signingKey) {
            throw new Error("callback config not set");
        }
        const context = {
            cluster: callbackContext.cluster,
            app: callbackContext.app?.trim() ? callbackContext.app : undefined,
            tenantId: callbackContext.tenantId,
            contextXtrem: callbackContext.contextXtrem,
            responseQueueName: callbackContext.responseQueueName ?? "service-fabric-notifications",
            nanoId: callbackContext.nanoId,
            expireDatetimeIso: callbackContext.expireDatetimeIso,
            contextKind: xtrem_deployment_1.ASYNC_CONTEXT_CONST.CONTEXT_SERVICE_FABRIC_NOTIFICATION,
            notifyTimeout: true
        };
        const contextId = await this.dynamoDbRegistry.createAsyncContext(new persistableAsyncContext_1.PersistableAsyncContext(context, true));
        const callbackUrlSignature = encodeURIComponent((0, node_crypto_1.createHash)("sha256").update(`${contextId}.${this.thirdPartyConfig.signingKey}`).digest("base64"));
        return {
            callbackUrl: `${this.thirdPartyConfig.callbackUrl}?contextId=${contextId}&signingKey=${callbackUrlSignature}`,
            id: contextId
        };
    }
}
exports.default = XtremAsyncContextProvider;
//# sourceMappingURL=xtremAsyncContextProvider.js.map