import { AsyncContext, CallbackAsyncContext } from "../../business/asyncContext";
import { DynamoDBAsyncContextIdProviderConfig, DynamoDBAsyncContextRepository } from "./dynamoDBAsyncContextRepository";
import { AsyncContextXtremRepository } from "../asyncContextXtremRepository";
import { ThirdPartyAsyncContextIdProviderConfig } from "../../business/callbackAsyncContextIdProviderConfig";
/***
 * Used by xtrem to manipulate async contexts
 */
export default class XtremAsyncContextProvider extends AsyncContextXtremRepository {
    protected dynamoDbRegistry: DynamoDBAsyncContextRepository;
    private readonly thirdPartyConfig;
    constructor(config: DynamoDBAsyncContextIdProviderConfig, thirdPartyConfig?: ThirdPartyAsyncContextIdProviderConfig);
    createAsyncContext(context: AsyncContext): Promise<string>;
    deleteAsyncContext(contextId: string): Promise<void>;
    getAsyncContext(contextId: string): Promise<AsyncContext | undefined>;
    createThirdPartyCallbackAsyncContext(callbackContext: CallbackAsyncContext): Promise<{
        callbackUrl: string;
        id: string;
    }>;
}
