"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const xtremAsyncContextProvider_1 = __importDefault(require("./xtremAsyncContextProvider"));
/***
 * Used by infra to manipulate async Context
 * Ex lambda to update md5 of uploaded file
 */
class InfraAsyncContextProvider extends xtremAsyncContextProvider_1.default {
    constructor(config) {
        super(config);
    }
    /**
     * Replaces the infra JSON object with a new one, used for instance to store that a given context was processed
     * @param contextId
     * @param infraContext
     */
    async replaceAsyncInfraContext(contextId, infraContext) {
        return this.dynamoDbRegistry.replaceAsyncInfraContext(contextId, infraContext);
    }
    async getAsyncContextsPerCluster(cluster, app) {
        return this.dynamoDbRegistry.getAsyncContextsForCluster(cluster, app);
    }
    async getExpiredAsyncContextsPerCluster(cluster, app) {
        return this.dynamoDbRegistry.getExpiredAsyncContexts(cluster, app);
    }
    async getExpiredAsyncContexts() {
        return this.dynamoDbRegistry.getExpiredAsyncContexts();
    }
}
exports.default = InfraAsyncContextProvider;
//# sourceMappingURL=infraAsyncContextProvider.js.map