import { AsyncContext } from "../../business/asyncContext";
import XtremAsyncContextProvider from "./xtremAsyncContextProvider";
import { DynamoDBAsyncContextIdProviderConfig } from "./dynamoDBAsyncContextRepository";
/***
 * Used by infra to manipulate async Context
 * Ex lambda to update md5 of uploaded file
 */
export default class InfraAsyncContextProvider extends XtremAsyncContextProvider {
    constructor(config: DynamoDBAsyncContextIdProviderConfig);
    /**
     * Replaces the infra JSON object with a new one, used for instance to store that a given context was processed
     * @param contextId
     * @param infraContext
     */
    replaceAsyncInfraContext(contextId: string, infraContext: any): Promise<void>;
    getAsyncContextsPerCluster(cluster: string, app?: string): Promise<AsyncContext[]>;
    getExpiredAsyncContextsPerCluster(cluster: string, app?: string): Promise<AsyncContext[]>;
    getExpiredAsyncContexts(): Promise<AsyncContext[]>;
}
