"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersistableAsyncContext = void 0;
// import { getErrorMsg } from "@sage/api-tools";
const nanoid = __importStar(require("nanoid"));
const xtrem_deployment_1 = require("@sage/xtrem-deployment");
const tool_1 = require("../tool");
const MIN_TENANT_ID_LENGTH = 3;
const MAX_MESSAGE_SIZE_IN_BYTES = 240 * 1024; // dynamoDB limit is 400, but SQS is 256 we keep 10kb as a spare for rest of the record
const DEFAULT_CONTEXT_TIMEOUT_SECONDS = 60 * 15;
/***
 * Represent an async context before it's persisted, allows to perform control checks
 */
class PersistableAsyncContext {
    nanoId;
    tenantId;
    cluster;
    contextKind;
    expireDatetimeIso;
    contextXtrem;
    responseQueueName;
    contextInfra;
    notifyTimeout;
    createdDateTimeIso;
    app;
    constructor(context, dontAddS3FileTTL = false) {
        this.ensureParamsAreValid(context);
        this.tenantId = context.tenantId;
        this.cluster = context.cluster;
        this.app = context.app;
        this.contextKind = context.contextKind;
        this.nanoId = context.nanoId || nanoid.nanoid();
        this.expireDatetimeIso = context.expireDatetimeIso || new Date(new Date().setSeconds(new Date().getSeconds() + DEFAULT_CONTEXT_TIMEOUT_SECONDS)).toISOString();
        this.responseQueueName = context.responseQueueName;
        this.contextXtrem = context.contextXtrem;
        this.contextInfra = context.contextInfra || {};
        if (!dontAddS3FileTTL) {
            this.contextInfra.s3FileTTL = context.s3FileTTL || xtrem_deployment_1.FileTimeToLive.Expire10Days;
        }
        this.createdDateTimeIso = new Date().toISOString();
        this.notifyTimeout = typeof (context.notifyTimeout) === "undefined" ? true : context.notifyTimeout;
    }
    ensureParamsAreValid(context) {
        if (context.expireDatetimeIso && new Date(context.expireDatetimeIso) < new Date()) {
            throw new Error("Bad timeout setting, must be in the future");
        }
        if (context.tenantId.length < MIN_TENANT_ID_LENGTH) {
            throw new Error(`TenantId provided ${context.tenantId} looks not valid`);
        }
        if (context.cluster.trim() === "") {
            throw new Error(`clusterId ${context.cluster} looks not valid`);
        }
    }
    /**
     * Make sure context from xtrem is writable and not too big
     * @param context
     */
    getWritableContextXtrem() {
        if (!this.contextXtrem) {
            // test both null and undefined with "==" "===" would omit undefined
            return "{}";
        }
        let writableContext = "";
        try {
            writableContext = JSON.stringify(this.contextXtrem);
        }
        catch (err) {
            throw new Error(`Cannot stringify the async request context : ${(0, tool_1.getErrorMsg)(err)}`);
        }
        const contextSize = Buffer.byteLength(Buffer.from(writableContext, "utf-8"));
        if (contextSize > MAX_MESSAGE_SIZE_IN_BYTES) {
            throw new Error(`Cannot persist context, the context size is too important (max payload is ${Math.round(MAX_MESSAGE_SIZE_IN_BYTES / 1024)} KB)`);
        }
        return writableContext;
    }
    getWritableContextInfra() {
        return PersistableAsyncContext.getWritableContextInfra(this.contextInfra);
    }
    /**
     * Get persistable context object for infra as string, does not perform length control we assume cirrus will remain frugal on the object size
     * Static because used in update without an async context existing
     */
    static getWritableContextInfra(contextValue) {
        if (!contextValue) {
            return "{}";
        }
        try {
            return JSON.stringify(contextValue);
        }
        catch (err) {
            throw new Error(`Cannot stringify the async request infra context : ${(0, tool_1.getErrorMsg)(err)}`);
        }
    }
}
exports.PersistableAsyncContext = PersistableAsyncContext;
//# sourceMappingURL=persistableAsyncContext.js.map