// From file: @sage/wh-product-data/build/index.d.ts
declare module '@sage/wh-product-data/index' {
	export * from '@sage/wh-product-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/index.d.ts
declare module '@sage/wh-product-data/lib/index' {
	export * as enums from '@sage/wh-product-data/lib/enums/index';
	export * as functions from '@sage/wh-product-data/lib/functions/index';
	export * as interfaces from '@sage/wh-product-data/lib/interfaces/index';
	export * as nodeExtensions from '@sage/wh-product-data/lib/node-extensions/index';
	export * as nodes from '@sage/wh-product-data/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-product-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/service-options/index.d.ts
declare module '@sage/wh-product-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/transport-category.d.ts
declare module '@sage/wh-product-data/lib/nodes/transport-category' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	export class TransportCategory extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly maximumMaterialQuantity: Promise<integer | null>;
	    readonly isUnlimited: Promise<boolean>;
	}
	//# sourceMappingURL=transport-category.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/supplier-upc.d.ts
declare module '@sage/wh-product-data/lib/nodes/supplier-upc' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class SupplierUpc extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly upcCode: Promise<string>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly container: Reference<sageWhProductData.nodes.Container>;
	    readonly supplier: Reference<sageWhMasterData.nodes.Supplier>;
	}
	//# sourceMappingURL=supplier-upc.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/sub-group.d.ts
declare module '@sage/wh-product-data/lib/nodes/sub-group' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SubGroup extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sub-group.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/sub-family.d.ts
declare module '@sage/wh-product-data/lib/nodes/sub-family' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SubFamily extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sub-family.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/risk.d.ts
declare module '@sage/wh-product-data/lib/nodes/risk' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Risk extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=risk.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/receipt-mode.d.ts
declare module '@sage/wh-product-data/lib/nodes/receipt-mode' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ReceiptMode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isCrossDocking: Promise<boolean>;
	    readonly isExceedQuantityControl: Promise<boolean>;
	    readonly cancelBalanceExpectedInputManagement: Promise<sageWhProductData.enums.CancelationOfEiShortage | null>;
	    readonly isReceiptControlListPrint: Promise<boolean>;
	    readonly isAutoAddressing: Promise<boolean>;
	    readonly isExpectedInputLinesNotSettled: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly siteDepositorIdentifier: Promise<string>;
	    readonly isDockAssignment: Promise<boolean>;
	    readonly isAutoCreationAuthorized: Promise<boolean>;
	    readonly isAutoDeletionAuthorized: Promise<boolean>;
	    readonly receivingDockStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly receivingDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly reference: Promise<sageWhProductData.enums.ReceiptReferenceType | null>;
	    readonly truckTrackingStatus: Reference<sageWhMasterData.nodes.TruckTrackingStatus | null>;
	    readonly occupationDuration: Promise<string>;
	}
	//# sourceMappingURL=receipt-mode.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product.d.ts
declare module '@sage/wh-product-data/lib/nodes/product' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection, BinaryStream } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class Product extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly otherCode: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedDescription2: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly family: Reference<sageWhProductData.nodes.Family | null>;
	    readonly subFamily: Reference<sageWhProductData.nodes.SubFamily | null>;
	    readonly group: Reference<sageWhProductData.nodes.Group | null>;
	    readonly subGroup: Reference<sageWhProductData.nodes.SubGroup | null>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly stockCountClass: Reference<sageWhMasterData.nodes.StockCountClass | null>;
	    readonly numberStockCount: Promise<integer>;
	    readonly isBlockedInInput: Promise<boolean>;
	    readonly isBlockedInOutput: Promise<boolean>;
	    readonly isBlockedInInput2: Promise<boolean>;
	    readonly isBlockedInOutput2: Promise<boolean>;
	    readonly isKeyInLotNumber: Promise<boolean>;
	    readonly isSingleLot: Promise<boolean>;
	    readonly isCrossDocking: Promise<boolean>;
	    readonly isHazardousMaterials: Promise<boolean>;
	    readonly isKeyInControlCode: Promise<boolean>;
	    readonly fifoDateNature: Promise<sageWhProductData.enums.FifoDate | null>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly inputMode: Reference<sageWhProductData.nodes.InputMode>;
	    readonly outputMode: Reference<sageWhProductData.nodes.OutputMode>;
	    readonly autoTransferMode: Promise<sageWhProductData.enums.MovementType>;
	    readonly detentionLength: Promise<integer | null>;
	    readonly detentionUnit: Promise<sageWhProductData.enums.UnitLength | null>;
	    readonly useByDateLength: Promise<integer | null>;
	    readonly useByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
	    readonly sendByDateLength: Promise<integer | null>;
	    readonly sendByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
	    readonly sellByDateLength: Promise<integer | null>;
	    readonly sellByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
	    readonly fifoTolerance: Promise<integer | null>;
	    readonly fifoGapUnit: Promise<sageWhProductData.enums.UnitLength | null>;
	    readonly netWeight: Promise<decimal | null>;
	    readonly netVolume: Promise<decimal | null>;
	    readonly pureAlcoholVolume: Promise<decimal | null>;
	    readonly price: Promise<decimal | null>;
	    readonly material: Reference<sageWhProductData.nodes.Risk | null>;
	    readonly minimumStock: Promise<decimal | null>;
	    readonly alertStock: Promise<decimal | null>;
	    readonly maximumStock: Promise<decimal | null>;
	    readonly firstArrival: Promise<date | null>;
	    readonly lastReceipt: Promise<date | null>;
	    readonly lastOutput: Promise<date | null>;
	    readonly lastStockCount: Promise<date | null>;
	    readonly defaultContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly defaultContainerLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
	    readonly endOfLife: Promise<date | null>;
	    readonly isQualityControlManagement: Promise<boolean>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly isSingleLotControl: Promise<boolean>;
	    readonly samplingType: Promise<sageWhProductData.enums.SamplingType | null>;
	    readonly generalLevelOfInspection: Promise<string>;
	    readonly aql: Promise<decimal | null>;
	    readonly freezingPoint: Promise<integer | null>;
	    readonly freezingReversibility: Promise<sageWhProductData.enums.ReversibleFreezing | null>;
	    readonly ammNo: Promise<string>;
	    readonly referredQuantity: Promise<decimal | null>;
	    readonly referredUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly icpeClass: Reference<sageWhProductData.nodes.IcpeClasses | null>;
	    readonly flashPoint: Promise<integer | null>;
	    readonly transportCategory: Reference<sageWhProductData.nodes.TransportCategory | null>;
	    readonly hazardousMaterialClass: Reference<sageWhProductData.nodes.HazardousMaterialsClass | null>;
	    readonly tunnelRestriction: Promise<string>;
	    readonly classificationCode: Promise<string>;
	    readonly packagingGroup: Promise<sageWhProductData.enums.PackagingGroup | null>;
	    readonly onuCodes: Reference<sageWhProductData.nodes.OnuCode | null>;
	    readonly solventCode: Promise<string>;
	    readonly technicalField: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly isStockUnitManagement: Promise<boolean>;
	    readonly stockUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	    readonly siteDepositorIdentifier: Promise<string>;
	    readonly pictureRef: Reference<sageWhMasterData.nodes.CommonImage | null>;
	    readonly suppliersUpcs: Collection<sageWhProductData.nodes.SupplierUpc>;
	    readonly productContainers: Collection<sageWhProductData.nodes.ProductContainer>;
	    readonly picture: Promise<BinaryStream>;
	    readonly activeMatters: Collection<sageWhProductData.nodes.ProductActiveMatters>;
	    readonly isPrintableDescriptions: Collection<sageWhProductData.nodes.ProductIsPrintableDescriptions>;
	    readonly percentageActiveMatters: Collection<sageWhProductData.nodes.ProductPercentageActiveMatters>;
	}
	//# sourceMappingURL=product.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-percentage-active-matters.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-percentage-active-matters' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductPercentageActiveMatters extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.Product>;
	    readonly percentageActiveMatter: Promise<decimal | null>;
	}
	//# sourceMappingURL=product-percentage-active-matters.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-is-printable-descriptions.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-is-printable-descriptions' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductIsPrintableDescriptions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.Product>;
	    readonly isPrintableDescription: Promise<boolean>;
	}
	//# sourceMappingURL=product-is-printable-descriptions.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-container.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-container' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductContainer extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly container: Reference<sageWhProductData.nodes.Container>;
	    readonly upcCode: Promise<string>;
	    readonly containerLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly inferiorContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly numberInferiorContainer: Promise<decimal | null>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly minimumReserveOutput: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly grossWeight: Promise<decimal>;
	    readonly width: Promise<decimal>;
	    readonly depth: Promise<decimal>;
	    readonly height: Promise<decimal>;
	    readonly volume: Promise<decimal | null>;
	    readonly linearMeters: Promise<decimal | null>;
	    readonly isNesting: Promise<boolean>;
	    readonly maximumNesting: Promise<integer | null>;
	    readonly umpteenthProductWidthNesting: Promise<decimal | null>;
	    readonly umpteenthProductDepthNesting: Promise<decimal | null>;
	    readonly umpteenthProductHeightNesting: Promise<decimal | null>;
	    readonly umpteenthProductVolumeNesting: Promise<decimal | null>;
	    readonly isInputAllowed: Promise<boolean>;
	    readonly sequenceCode: Reference<sageWhMasterData.nodes.StoreChaining>;
	    readonly percentageOfRupture: Promise<integer | null>;
	    readonly maximumNumberOfContainers: Promise<decimal | null>;
	    readonly stackingCoefficient: Promise<integer | null>;
	    readonly stackingCorrective: Promise<integer | null>;
	    readonly isKeyInSupportNumbers: Promise<boolean>;
	    readonly rotationClass: Reference<sageWhMasterData.nodes.RotationClass | null>;
	    readonly assignmentClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
	    readonly homogeneousLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly isOutputAllowed: Promise<boolean>;
	    readonly dispatchableInState: Promise<sageWhProductData.enums.DispatchableInState | null>;
	    readonly isPackingPattern: Promise<boolean>;
	    readonly containerTare: Promise<decimal | null>;
	    readonly parcelRangeShippedAsIsStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly parcelTypeShippedAsIsStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
	    readonly parcelRangeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly parcelTypeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
	    readonly isActive: Promise<boolean>;
	    readonly numberOfStockUnit: Promise<decimal | null>;
	    readonly density: Promise<decimal | null>;
	    readonly unitWeight: Promise<decimal | null>;
	    readonly unitVolume: Promise<decimal | null>;
	    readonly containersInferior: Collection<sageWhProductData.nodes.ProductContainerContainersInferior>;
	    readonly numberOfConsumptionUnitPerLevels: Collection<sageWhProductData.nodes.ProductContainerNumberOfConsumptionUnitPerLevels>;
	    readonly numberOfStockUnitPerLevels: Collection<sageWhProductData.nodes.ProductContainerNumberOfStockUnitPerLevels>;
	    readonly prohibitedClasses: Collection<sageWhProductData.nodes.ProductContainerProhibitedClasses>;
	}
	//# sourceMappingURL=product-container.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-container-prohibited-classes.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-container-prohibited-classes' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductContainerProhibitedClasses extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly product: Promise<string>;
	    readonly container: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly prohibitedClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
	}
	//# sourceMappingURL=product-container-prohibited-classes.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-container-number-of-stock-unit-per-levels.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-container-number-of-stock-unit-per-levels' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductContainerNumberOfStockUnitPerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly product: Promise<string>;
	    readonly container: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly numberOfStockUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=product-container-number-of-stock-unit-per-levels.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-container-number-of-consumption-unit-per-levels.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-container-number-of-consumption-unit-per-levels' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductContainerNumberOfConsumptionUnitPerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly product: Promise<string>;
	    readonly container: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly numberOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=product-container-number-of-consumption-unit-per-levels.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-container-containers-inferior.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-container-containers-inferior' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductContainerContainersInferior extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly product: Promise<string>;
	    readonly container: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly containerInferior: Reference<sageWhProductData.nodes.ProductContainer | null>;
	}
	//# sourceMappingURL=product-container-containers-inferior.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/product-active-matters.d.ts
declare module '@sage/wh-product-data/lib/nodes/product-active-matters' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class ProductActiveMatters extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.Product>;
	    readonly activeMatter: Reference<sageWhProductData.nodes.ActiveMatter | null>;
	}
	//# sourceMappingURL=product-active-matters.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/picking-mode.d.ts
declare module '@sage/wh-product-data/lib/nodes/picking-mode' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class PickingMode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isExclusiveReservation: Promise<boolean>;
	    readonly isMergingOfFlows: Promise<boolean>;
	    readonly crossDockingRule: Promise<sageWhProductData.enums.CrossDocking | null>;
	    readonly isExclusiveFifoDate: Promise<boolean>;
	    readonly isSingleLotInOutput: Promise<boolean>;
	    readonly isPreparationOrderMixed: Promise<boolean>;
	    readonly isPreparationOrderSingleDeliveryOrderPerPicking: Promise<boolean>;
	    readonly isPreparationOrderSingleDeliveryOrderPerReserve: Promise<boolean>;
	    readonly isPreparationOrderSinglePickArea: Promise<boolean>;
	    readonly preparationAreaForParcel: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly preparationAreaForKit: Reference<sageWhMasterData.nodes.PreparationArea>;
	    readonly isPreparationOrderSingleOutputLevel: Promise<boolean>;
	    readonly isSingleShippingRoundPerPreparationOrder: Promise<boolean>;
	    readonly isSingleShipToCustomerPerPreparationOrder: Promise<boolean>;
	    readonly isPickingPreparationOrder: Promise<boolean>;
	    readonly isReservePreparationOrder: Promise<boolean>;
	    readonly packingManagement: Promise<sageWhProductData.enums.Packing | null>;
	    readonly isPreparationOrderPrint: Promise<boolean>;
	    readonly preparationOrderPrintSequence: Promise<sageWhProductData.enums.PoPrintSequence | null>;
	    readonly isGroupedMovements: Promise<boolean>;
	    readonly isParcelLabelPrint: Promise<boolean>;
	    readonly isShippingUnitLabelPrint: Promise<boolean>;
	    readonly isMultiplePicking: Promise<boolean>;
	    readonly isPrepalletization: Promise<boolean>;
	    readonly loadSplit: Promise<sageWhProductData.enums.LoadSplit | null>;
	    readonly isContractDate: Promise<boolean>;
	    readonly handledGroupingRule: Promise<sageWhProductData.enums.VtGroupingCriteria | null>;
	    readonly isActive: Promise<boolean>;
	    readonly siteDepositorIdentifier: Promise<string>;
	}
	//# sourceMappingURL=picking-mode.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/output-mode.d.ts
declare module '@sage/wh-product-data/lib/nodes/output-mode' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class OutputMode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isPickingStockAllowed: Promise<boolean>;
	    readonly isPickingPivotAllowed: Promise<boolean>;
	    readonly isSingleDeliveryOrderReplenishmentForPickingPivotAllowed: Promise<boolean>;
	    readonly isSingleWaveReplenishmentForPickingPivotAllowed: Promise<boolean>;
	    readonly reserveOutputAuthorizedRule: Promise<sageWhProductData.enums.ReserveOutputAuthorized | null>;
	    readonly isReserveProhibited: Promise<boolean>;
	    readonly percentagePickingCapacityForReserveOutputAuthorizedRule: Promise<integer | null>;
	    readonly isAutomaticChoiceOfPicking: Promise<boolean>;
	    readonly inCompleteContainerPickingAuthorizedRule: Promise<sageWhProductData.enums.IncompleteOutputAuthorized | null>;
	    readonly isIncompletePalletCreatedAuthorized: Promise<boolean>;
	    readonly isStockOutReplenishmentAllowed: Promise<boolean>;
	    readonly isPreventiveReplenishmentAllowed: Promise<boolean>;
	    readonly isSerialNumberInInputAllowed: Promise<boolean>;
	    readonly isSerialNumberInOutputAllowed: Promise<boolean>;
	    readonly bigVolumeLimit: Promise<decimal | null>;
	    readonly isDynamicPickingAllowed: Promise<boolean>;
	    readonly isMultiplePickingAllowed: Promise<boolean>;
	    readonly isDeliveryOrderSinglePickingForMultiplePickingAllowed: Promise<boolean>;
	    readonly isPriorityOutputToReplenishmentForMultiplePickingAllowed: Promise<boolean>;
	    readonly isSingleAddressReplenishmentForMultiplePickingAllowed: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly siteDepositorIdentifier: Promise<string>;
	    readonly isLocalizedSerialNumberAllowed: Promise<boolean>;
	    readonly isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed: Promise<boolean>;
	    readonly outputsPriority: Collection<sageWhProductData.nodes.OutputModeOutputsPriority>;
	    readonly pickingsPriority: Collection<sageWhProductData.nodes.OutputModePickingsPriority>;
	    readonly replenishmentsPriority: Collection<sageWhProductData.nodes.OutputModeReplenishmentsPriority>;
	    readonly replenishmentsPrioritySorting: Collection<sageWhProductData.nodes.OutputModeReplenishmentsPrioritySorting>;
	}
	//# sourceMappingURL=output-mode.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/output-mode-replenishments-priority.d.ts
declare module '@sage/wh-product-data/lib/nodes/output-mode-replenishments-priority' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class OutputModeReplenishmentsPriority extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.OutputMode>;
	    readonly replenishmentPriority: Promise<sageWhProductData.enums.OutputOfTheReserve | null>;
	}
	//# sourceMappingURL=output-mode-replenishments-priority.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/output-mode-replenishments-priority-sorting.d.ts
declare module '@sage/wh-product-data/lib/nodes/output-mode-replenishments-priority-sorting' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class OutputModeReplenishmentsPrioritySorting extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.OutputMode>;
	    readonly replenishmentPrioritySorting: Promise<sageWhSystem.enums.SortOrder | null>;
	}
	//# sourceMappingURL=output-mode-replenishments-priority-sorting.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/output-mode-pickings-priority.d.ts
declare module '@sage/wh-product-data/lib/nodes/output-mode-pickings-priority' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class OutputModePickingsPriority extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.OutputMode>;
	    readonly pickingPriority: Promise<sageWhProductData.enums.MultiPickingIssue | null>;
	}
	//# sourceMappingURL=output-mode-pickings-priority.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/output-mode-outputs-priority.d.ts
declare module '@sage/wh-product-data/lib/nodes/output-mode-outputs-priority' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class OutputModeOutputsPriority extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.OutputMode>;
	    readonly outputPriority: Promise<sageWhProductData.enums.OutputOfTheReserve | null>;
	}
	//# sourceMappingURL=output-mode-outputs-priority.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/origin.d.ts
declare module '@sage/wh-product-data/lib/nodes/origin' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Origin extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=origin.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/onu-code.d.ts
declare module '@sage/wh-product-data/lib/nodes/onu-code' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class OnuCode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	}
	//# sourceMappingURL=onu-code.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/kits.d.ts
declare module '@sage/wh-product-data/lib/nodes/kits' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class Kits extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly kit: Reference<sageWhProductData.nodes.Product>;
	    readonly lineOrder: Promise<integer | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly numberOfConsumptionUnits: Promise<decimal | null>;
	}
	//# sourceMappingURL=kits.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/input-mode.d.ts
declare module '@sage/wh-product-data/lib/nodes/input-mode' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class InputMode extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly priorityPickingLocation: Promise<sageWhProductData.enums.PickingLocationPriority | null>;
	    readonly isProximityPickingAllowed: Promise<boolean>;
	    readonly isPartialObjectInPickingAllowed: Promise<boolean>;
	    readonly availableSpaceInPickingManagement: Promise<sageWhProductData.enums.ThresholdPalletAlways | null>;
	    readonly isRotationClassesChaining: Promise<boolean>;
	    readonly isAssignmentClassesChaining: Promise<boolean>;
	    readonly isContainerCorrespondence: Promise<boolean>;
	    readonly isSingleContainer: Promise<boolean>;
	    readonly isSingleProduct: Promise<boolean>;
	    readonly isIncompleteObjectCorrespondence: Promise<boolean>;
	    readonly mergingInInputManagement: Promise<sageWhProductData.enums.MergingInInput | null>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly isUniqueMergingStore: Promise<boolean>;
	    readonly isCompleteQuantityInSingleLocation: Promise<boolean>;
	    readonly homogeneousCrossDockingContainerLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly isAutoCrossDockingPreparationOrder: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly siteDepositorIdentifier: Promise<string>;
	    readonly isPartialObjectCapacityExcessAllowed: Promise<boolean>;
	    readonly creationOfSeparateMovements: Collection<sageWhProductData.nodes.InputModeCreationOfSeparateMovements>;
	    readonly inputPriorityInReserveLocations: Collection<sageWhProductData.nodes.InputModeInputPriorityInReserveLocations>;
	    readonly movementLevels: Collection<sageWhProductData.nodes.InputModeMovementLevels>;
	}
	//# sourceMappingURL=input-mode.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/input-mode-movement-levels.d.ts
declare module '@sage/wh-product-data/lib/nodes/input-mode-movement-levels' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class InputModeMovementLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.InputMode>;
	    readonly movementLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	}
	//# sourceMappingURL=input-mode-movement-levels.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/input-mode-input-priority-in-reserve-locations.d.ts
declare module '@sage/wh-product-data/lib/nodes/input-mode-input-priority-in-reserve-locations' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class InputModeInputPriorityInReserveLocations extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.InputMode>;
	    readonly inputPriorityInReserveLocation: Promise<sageWhProductData.enums.Class | null>;
	}
	//# sourceMappingURL=input-mode-input-priority-in-reserve-locations.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/input-mode-creation-of-separate-movements.d.ts
declare module '@sage/wh-product-data/lib/nodes/input-mode-creation-of-separate-movements' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class InputModeCreationOfSeparateMovements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhProductData.nodes.InputMode>;
	    readonly isCreationOfSeparateMovements: Promise<boolean>;
	}
	//# sourceMappingURL=input-mode-creation-of-separate-movements.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/index.d.ts
declare module '@sage/wh-product-data/lib/nodes/index' {
	export * from '@sage/wh-product-data/lib/nodes/active-matter';
	export * from '@sage/wh-product-data/lib/nodes/container';
	export * from '@sage/wh-product-data/lib/nodes/containers-type';
	export * from '@sage/wh-product-data/lib/nodes/family';
	export * from '@sage/wh-product-data/lib/nodes/group';
	export * from '@sage/wh-product-data/lib/nodes/hazardous-materials-class';
	export * from '@sage/wh-product-data/lib/nodes/icpe-classes';
	export * from '@sage/wh-product-data/lib/nodes/input-mode-creation-of-separate-movements';
	export * from '@sage/wh-product-data/lib/nodes/input-mode-input-priority-in-reserve-locations';
	export * from '@sage/wh-product-data/lib/nodes/input-mode-movement-levels';
	export * from '@sage/wh-product-data/lib/nodes/input-mode';
	export * from '@sage/wh-product-data/lib/nodes/kits';
	export * from '@sage/wh-product-data/lib/nodes/onu-code';
	export * from '@sage/wh-product-data/lib/nodes/origin';
	export * from '@sage/wh-product-data/lib/nodes/output-mode-outputs-priority';
	export * from '@sage/wh-product-data/lib/nodes/output-mode-pickings-priority';
	export * from '@sage/wh-product-data/lib/nodes/output-mode-replenishments-priority-sorting';
	export * from '@sage/wh-product-data/lib/nodes/output-mode-replenishments-priority';
	export * from '@sage/wh-product-data/lib/nodes/output-mode';
	export * from '@sage/wh-product-data/lib/nodes/picking-mode';
	export * from '@sage/wh-product-data/lib/nodes/product-active-matters';
	export * from '@sage/wh-product-data/lib/nodes/product-container-containers-inferior';
	export * from '@sage/wh-product-data/lib/nodes/product-container-number-of-consumption-unit-per-levels';
	export * from '@sage/wh-product-data/lib/nodes/product-container-number-of-stock-unit-per-levels';
	export * from '@sage/wh-product-data/lib/nodes/product-container-prohibited-classes';
	export * from '@sage/wh-product-data/lib/nodes/product-container';
	export * from '@sage/wh-product-data/lib/nodes/product-is-printable-descriptions';
	export * from '@sage/wh-product-data/lib/nodes/product-percentage-active-matters';
	export * from '@sage/wh-product-data/lib/nodes/product';
	export * from '@sage/wh-product-data/lib/nodes/receipt-mode';
	export * from '@sage/wh-product-data/lib/nodes/risk';
	export * from '@sage/wh-product-data/lib/nodes/sub-family';
	export * from '@sage/wh-product-data/lib/nodes/sub-group';
	export * from '@sage/wh-product-data/lib/nodes/supplier-upc';
	export * from '@sage/wh-product-data/lib/nodes/transport-category';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/icpe-classes.d.ts
declare module '@sage/wh-product-data/lib/nodes/icpe-classes' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	export class IcpeClasses extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly maximumQuantityAllowedOnSite: Promise<integer | null>;
	}
	//# sourceMappingURL=icpe-classes.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/hazardous-materials-class.d.ts
declare module '@sage/wh-product-data/lib/nodes/hazardous-materials-class' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class HazardousMaterialsClass extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	}
	//# sourceMappingURL=hazardous-materials-class.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/group.d.ts
declare module '@sage/wh-product-data/lib/nodes/group' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Group extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=group.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/family.d.ts
declare module '@sage/wh-product-data/lib/nodes/family' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Family extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly parcelRange: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly parcelGroup: Promise<string>;
	}
	//# sourceMappingURL=family.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/containers-type.d.ts
declare module '@sage/wh-product-data/lib/nodes/containers-type' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class ContainersType extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly mergingOfFlowsGroup: Promise<string>;
	    readonly containerManagementType: Promise<sageWhMasterData.enums.ContainerManagementType>;
	}
	//# sourceMappingURL=containers-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/container.d.ts
declare module '@sage/wh-product-data/lib/nodes/container' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class Container extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly containerType: Reference<sageWhProductData.nodes.ContainersType>;
	    readonly containerLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly height: Promise<decimal>;
	    readonly width: Promise<decimal>;
	    readonly depth: Promise<decimal>;
	    readonly volume: Promise<decimal | null>;
	    readonly parcelRangeShippedAsIsStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly parcelTypeShippedAsIsStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
	    readonly parcelRangeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
	    readonly parcelTypeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
	    readonly shippingUnitDispatchableAsIs: Reference<sageWhMasterData.nodes.ShippingUnitType | null>;
	    readonly isShippingUnitPalettizableAsIs: Promise<boolean>;
	    readonly maximumQuantityAllowedInInputOutput: Promise<integer | null>;
	    readonly palletBaseHeight: Promise<decimal | null>;
	    readonly palletBaseGrossWeight: Promise<decimal | null>;
	    readonly isActive: Promise<boolean>;
	    readonly containerManagementType: Promise<sageWhMasterData.enums.ContainerManagementType>;
	    readonly unitWeight: Promise<decimal | null>;
	    readonly unitVolume: Promise<decimal | null>;
	}
	//# sourceMappingURL=container.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/nodes/active-matter.d.ts
declare module '@sage/wh-product-data/lib/nodes/active-matter' {
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class ActiveMatter extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly isSaleWithdrawal: Promise<boolean>;
	}
	//# sourceMappingURL=active-matter.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/node-extensions/location-extension.d.ts
declare module '@sage/wh-product-data/lib/node-extensions/location-extension' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhProductData from '@sage/wh-product-data/lib/index';
	export class LocationExtension extends NodeExtension<sageWhMasterData.nodes.Location> {
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly container: Reference<sageWhProductData.nodes.Container | null>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly referenceContainer: Reference<sageWhProductData.nodes.Container | null>;
	    readonly presentContainer: Reference<sageWhProductData.nodes.Container | null>;
	    readonly superiorContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	}
	declare module '@sage/wh-master-data/lib/nodes/location' {
	    interface Location extends LocationExtension {
	    }
	}
	//# sourceMappingURL=location-extension.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-product-data/lib/node-extensions/index' {
	export * from '@sage/wh-product-data/lib/node-extensions/location-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/interfaces/index.d.ts
declare module '@sage/wh-product-data/lib/interfaces/index' {
	export * from '@sage/wh-product-data/lib/interfaces/environnement';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/interfaces/environnement.d.ts
declare module '@sage/wh-product-data/lib/interfaces/environnement' {
	export interface ConsumptionUnit {
	    _id: string;
	    code: string;
	    numberOfConsumptionUnit: number;
	    numberOfDecimals?: number;
	    stockUnit?: string;
	}
	export interface ContainerOfProduct {
	    _id: string;
	    containerLevel: string;
	    container: {
	        _id: string;
	        code: string;
	        containerManagementType: string;
	    };
	}
	export interface ContainerUnit extends ContainerOfProduct, ConsumptionUnit {
	    homogeneousLevel: string;
	    containerLevel: string;
	    inferiorContainer?: ContainerOfProduct;
	    isKeyInSupportNumbers: boolean;
	}
	export type ContainerUnits = ContainerUnit[];
	export interface ContainerProductUnit extends Omit<ContainerUnit, 'code' | 'numberOfConsumptionUnit' | 'numberOfDecimals' | 'stockUnit'> {
	    numberOfConsumptionUnit: string;
	}
	export interface ContainerUnitAndOptions {
	    containerUnit: ContainerUnit | undefined;
	    containerOptions: string[];
	}
	export interface FifoManagementErrorMessages {
	    manufacturedDateError?: string;
	    detentionDateError?: string;
	    sellByDateError: string;
	    useByDateError: string;
	    shipByDateError: string;
	    fifoDateError?: string;
	}
	export interface MovementPlan {
	    inputContainerCode: string | undefined;
	    homogeneousContainerCode: string | undefined;
	    numberOfContainers: number;
	    numberOfHomogeneousContainers: number;
	}
	export interface ProductConfiguration {
	    code: string;
	    localizedDescription: string;
	    isSerialNumberInInputAllowed: boolean;
	    isSerialNumberInOutputAllowed: boolean;
	    isLocalizedSerialNumberAllowed: boolean;
	    isKeyInControlCode: boolean;
	    isKeyInLotNumber: boolean;
	    isStockUnitManagement: boolean;
	    stockUnitCode?: string;
	    numberOfDecimals?: number;
	    defaultContainerCode: string;
	    defaultContainerLevel: string;
	    fifoDateNature: string;
	    detentionLength: number;
	    detentionUnit: string;
	    useByDateLength: number;
	    useByDateUnit: string;
	    sendByDateLength: number;
	    sendByDateUnit: string;
	    sellByDateLength: number;
	    sellByDateUnit: string;
	}
	//# sourceMappingURL=environnement.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/functions/index.d.ts
declare module '@sage/wh-product-data/lib/functions/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/zone-type.d.ts
declare module '@sage/wh-product-data/lib/enums/zone-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ZoneTypeEnum {
	    alphanumeric = 1,
	    numeric = 2,
	    date = 3,
	    boolean = 4,
	    text = 5
	}
	export interface ZoneType$EnumInterface {
	    alphanumeric: 1;
	    numeric: 2;
	    date: 3;
	    boolean: 4;
	    text: 5;
	}
	export type ZoneType = keyof ZoneType$EnumInterface;
	export const zoneTypeDatatype: X3EnumDataType<keyof ZoneType$EnumInterface, unknown>;
	//# sourceMappingURL=zone-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/wave-type.d.ts
declare module '@sage/wh-product-data/lib/enums/wave-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WaveTypeEnum {
	    normal = 1,
	    mergingOfFlows = 2,
	    assembling = 3,
	    disassembling = 4
	}
	export interface WaveType$EnumInterface {
	    normal: 1;
	    mergingOfFlows: 2;
	    assembling: 3;
	    disassembling: 4;
	}
	export type WaveType = keyof WaveType$EnumInterface;
	export const waveTypeDatatype: X3EnumDataType<keyof WaveType$EnumInterface, unknown>;
	//# sourceMappingURL=wave-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/wave-type-409.d.ts
declare module '@sage/wh-product-data/lib/enums/wave-type-409' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WaveType409Enum {
	    automaticallyGeneratedWaves = 1,
	    manuallyGeneratedWaves = 2
	}
	export interface WaveType409$EnumInterface {
	    automaticallyGeneratedWaves: 1;
	    manuallyGeneratedWaves: 2;
	}
	export type WaveType409 = keyof WaveType409$EnumInterface;
	export const waveType409Datatype: X3EnumDataType<keyof WaveType409$EnumInterface, unknown>;
	//# sourceMappingURL=wave-type-409.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/wave-status.d.ts
declare module '@sage/wh-product-data/lib/enums/wave-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WaveStatusEnum {
	    waitToLaunch = 1,
	    notUsed2 = 2,
	    waitToTransfer = 3,
	    wait2ndStep = 4,
	    ended = 5
	}
	export interface WaveStatus$EnumInterface {
	    waitToLaunch: 1;
	    notUsed2: 2;
	    waitToTransfer: 3;
	    wait2ndStep: 4;
	    ended: 5;
	}
	export type WaveStatus = keyof WaveStatus$EnumInterface;
	export const waveStatusDatatype: X3EnumDataType<keyof WaveStatus$EnumInterface, unknown>;
	//# sourceMappingURL=wave-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/vt-grouping-criteria.d.ts
declare module '@sage/wh-product-data/lib/enums/vt-grouping-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VtGroupingCriteriaEnum {
	    none = 1,
	    customer = 2,
	    do = 3,
	    doLine = 4
	}
	export interface VtGroupingCriteria$EnumInterface {
	    none: 1;
	    customer: 2;
	    do: 3;
	    doLine: 4;
	}
	export type VtGroupingCriteria = keyof VtGroupingCriteria$EnumInterface;
	export const vtGroupingCriteriaDatatype: X3EnumDataType<keyof VtGroupingCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=vt-grouping-criteria.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/view-type.d.ts
declare module '@sage/wh-product-data/lib/enums/view-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ViewTypeEnum {
	    do = 1,
	    round = 2
	}
	export interface ViewType$EnumInterface {
	    do: 1;
	    round: 2;
	}
	export type ViewType = keyof ViewType$EnumInterface;
	export const viewTypeDatatype: X3EnumDataType<keyof ViewType$EnumInterface, unknown>;
	//# sourceMappingURL=view-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/validation-process.d.ts
declare module '@sage/wh-product-data/lib/enums/validation-process' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValidationProcessEnum {
	    manual = 1,
	    semiAutomatic = 2,
	    automatic = 3
	}
	export interface ValidationProcess$EnumInterface {
	    manual: 1;
	    semiAutomatic: 2;
	    automatic: 3;
	}
	export type ValidationProcess = keyof ValidationProcess$EnumInterface;
	export const validationProcessDatatype: X3EnumDataType<keyof ValidationProcess$EnumInterface, unknown>;
	//# sourceMappingURL=validation-process.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/unit-length.d.ts
declare module '@sage/wh-product-data/lib/enums/unit-length' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnitLengthEnum {
	    days = 1,
	    month = 2,
	    no = 3
	}
	export interface UnitLength$EnumInterface {
	    days: 1;
	    month: 2;
	    no: 3;
	}
	export type UnitLength = keyof UnitLength$EnumInterface;
	export const unitLengthDatatype: X3EnumDataType<keyof UnitLength$EnumInterface, unknown>;
	//# sourceMappingURL=unit-length.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/unavailability-type.d.ts
declare module '@sage/wh-product-data/lib/enums/unavailability-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UnavailabilityTypeEnum {
	    resource = 1,
	    material = 2,
	    mission = 3
	}
	export interface UnavailabilityType$EnumInterface {
	    resource: 1;
	    material: 2;
	    mission: 3;
	}
	export type UnavailabilityType = keyof UnavailabilityType$EnumInterface;
	export const unavailabilityTypeDatatype: X3EnumDataType<keyof UnavailabilityType$EnumInterface, unknown>;
	//# sourceMappingURL=unavailability-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/type.d.ts
declare module '@sage/wh-product-data/lib/enums/type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeEnum {
	    assembling = 1,
	    disassembling = 2
	}
	export interface Type$EnumInterface {
	    assembling: 1;
	    disassembling: 2;
	}
	export type Type = keyof Type$EnumInterface;
	export const typeDatatype: X3EnumDataType<keyof Type$EnumInterface, unknown>;
	//# sourceMappingURL=type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/type-of-entity.d.ts
declare module '@sage/wh-product-data/lib/enums/type-of-entity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfEntityEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3
	}
	export interface TypeOfEntity$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	}
	export type TypeOfEntity = keyof TypeOfEntity$EnumInterface;
	export const typeOfEntityDatatype: X3EnumDataType<keyof TypeOfEntity$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-entity.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/type-of-analysis.d.ts
declare module '@sage/wh-product-data/lib/enums/type-of-analysis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAnalysisEnum {
	    empty = 1,
	    ei = 2,
	    do = 3,
	    appRound = 4,
	    receipt = 5,
	    di = 6,
	    sl = 7,
	    inputMovement = 8,
	    transferMovement = 9,
	    wave = 10,
	    po = 11,
	    outputMovement = 12,
	    doToBePrepared = 13,
	    doPickingOnTheWave = 14,
	    doToBeShipped = 15,
	    doPickingOnRound = 16,
	    appointment = 17
	}
	export interface TypeOfAnalysis$EnumInterface {
	    empty: 1;
	    ei: 2;
	    do: 3;
	    appRound: 4;
	    receipt: 5;
	    di: 6;
	    sl: 7;
	    inputMovement: 8;
	    transferMovement: 9;
	    wave: 10;
	    po: 11;
	    outputMovement: 12;
	    doToBePrepared: 13;
	    doPickingOnTheWave: 14;
	    doToBeShipped: 15;
	    doPickingOnRound: 16;
	    appointment: 17;
	}
	export type TypeOfAnalysis = keyof TypeOfAnalysis$EnumInterface;
	export const typeOfAnalysisDatatype: X3EnumDataType<keyof TypeOfAnalysis$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-analysis.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/type-of-activity.d.ts
declare module '@sage/wh-product-data/lib/enums/type-of-activity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfActivityEnum {
	    inputs = 1,
	    outputs = 2,
	    stocks = 3,
	    other = 4,
	    notDefined = 5
	}
	export interface TypeOfActivity$EnumInterface {
	    inputs: 1;
	    outputs: 2;
	    stocks: 3;
	    other: 4;
	    notDefined: 5;
	}
	export type TypeOfActivity = keyof TypeOfActivity$EnumInterface;
	export const typeOfActivityDatatype: X3EnumDataType<keyof TypeOfActivity$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-activity.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/type-815.d.ts
declare module '@sage/wh-product-data/lib/enums/type-815' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Type815Enum {
	    movement = 1,
	    so = 2
	}
	export interface Type815$EnumInterface {
	    movement: 1;
	    so: 2;
	}
	export type Type815 = keyof Type815$EnumInterface;
	export const type815Datatype: X3EnumDataType<keyof Type815$EnumInterface, unknown>;
	//# sourceMappingURL=type-815.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/transmission-l-3.d.ts
declare module '@sage/wh-product-data/lib/enums/transmission-l-3' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransmissionL3Enum {
	    none = 1,
	    yes = 2,
	    mounted = 3
	}
	export interface TransmissionL3$EnumInterface {
	    none: 1;
	    yes: 2;
	    mounted: 3;
	}
	export type TransmissionL3 = keyof TransmissionL3$EnumInterface;
	export const transmissionL3Datatype: X3EnumDataType<keyof TransmissionL3$EnumInterface, unknown>;
	//# sourceMappingURL=transmission-l-3.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/transfer-validation.d.ts
declare module '@sage/wh-product-data/lib/enums/transfer-validation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferValidationEnum {
	    validation = 1,
	    cancellation = 2,
	    picking = 3,
	    relocation = 4,
	    none = 5
	}
	export interface TransferValidation$EnumInterface {
	    validation: 1;
	    cancellation: 2;
	    picking: 3;
	    relocation: 4;
	    none: 5;
	}
	export type TransferValidation = keyof TransferValidation$EnumInterface;
	export const transferValidationDatatype: X3EnumDataType<keyof TransferValidation$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-validation.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/transfer-to-store.d.ts
declare module '@sage/wh-product-data/lib/enums/transfer-to-store' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferToStoreEnum {
	    towardsInternalStore = 1,
	    towardsExternalStore = 2
	}
	export interface TransferToStore$EnumInterface {
	    towardsInternalStore: 1;
	    towardsExternalStore: 2;
	}
	export type TransferToStore = keyof TransferToStore$EnumInterface;
	export const transferToStoreDatatype: X3EnumDataType<keyof TransferToStore$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-to-store.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/transfer-phase.d.ts
declare module '@sage/wh-product-data/lib/enums/transfer-phase' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferPhaseEnum {
	    removal = 1,
	    repositioning = 2
	}
	export interface TransferPhase$EnumInterface {
	    removal: 1;
	    repositioning: 2;
	}
	export type TransferPhase = keyof TransferPhase$EnumInterface;
	export const transferPhaseDatatype: X3EnumDataType<keyof TransferPhase$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-phase.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/trace-level.d.ts
declare module '@sage/wh-product-data/lib/enums/trace-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TraceLevelEnum {
	    none = 1,
	    average = 2,
	    high = 3
	}
	export interface TraceLevel$EnumInterface {
	    none: 1;
	    average: 2;
	    high: 3;
	}
	export type TraceLevel = keyof TraceLevel$EnumInterface;
	export const traceLevelDatatype: X3EnumDataType<keyof TraceLevel$EnumInterface, unknown>;
	//# sourceMappingURL=trace-level.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/total-statistics.d.ts
declare module '@sage/wh-product-data/lib/enums/total-statistics' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TotalStatisticsEnum {
	    spaceAvailableRefCont = 1,
	    occupancyRate = 2,
	    authorizedFlowsInpOut = 3,
	    weight = 4,
	    volume = 5,
	    cu = 6,
	    containers = 7,
	    price = 8,
	    movementsInProgressInpOut = 9,
	    validatedMovements = 10,
	    numberOfLocations = 11,
	    stk = 12
	}
	export interface TotalStatistics$EnumInterface {
	    spaceAvailableRefCont: 1;
	    occupancyRate: 2;
	    authorizedFlowsInpOut: 3;
	    weight: 4;
	    volume: 5;
	    cu: 6;
	    containers: 7;
	    price: 8;
	    movementsInProgressInpOut: 9;
	    validatedMovements: 10;
	    numberOfLocations: 11;
	    stk: 12;
	}
	export type TotalStatistics = keyof TotalStatistics$EnumInterface;
	export const totalStatisticsDatatype: X3EnumDataType<keyof TotalStatistics$EnumInterface, unknown>;
	//# sourceMappingURL=total-statistics.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/time-slots.d.ts
declare module '@sage/wh-product-data/lib/enums/time-slots' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeSlotsEnum {
	    morning = 1,
	    noon = 2,
	    afternoon = 3,
	    evening = 4
	}
	export interface TimeSlots$EnumInterface {
	    morning: 1;
	    noon: 2;
	    afternoon: 3;
	    evening: 4;
	}
	export type TimeSlots = keyof TimeSlots$EnumInterface;
	export const timeSlotsDatatype: X3EnumDataType<keyof TimeSlots$EnumInterface, unknown>;
	//# sourceMappingURL=time-slots.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/threshold-pallet-always.d.ts
declare module '@sage/wh-product-data/lib/enums/threshold-pallet-always' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ThresholdPalletAlwaysEnum {
	    threshold = 1,
	    object = 2,
	    always = 3
	}
	export interface ThresholdPalletAlways$EnumInterface {
	    threshold: 1;
	    object: 2;
	    always: 3;
	}
	export type ThresholdPalletAlways = keyof ThresholdPalletAlways$EnumInterface;
	export const thresholdPalletAlwaysDatatype: X3EnumDataType<keyof ThresholdPalletAlways$EnumInterface, unknown>;
	//# sourceMappingURL=threshold-pallet-always.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/support-status.d.ts
declare module '@sage/wh-product-data/lib/enums/support-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupportStatusEnum {
	    free = 1,
	    inProgress = 2,
	    used = 3,
	    shipped = 4,
	    notForUse = 5,
	    obsolete = 6
	}
	export interface SupportStatus$EnumInterface {
	    free: 1;
	    inProgress: 2;
	    used: 3;
	    shipped: 4;
	    notForUse: 5;
	    obsolete: 6;
	}
	export type SupportStatus = keyof SupportStatus$EnumInterface;
	export const supportStatusDatatype: X3EnumDataType<keyof SupportStatus$EnumInterface, unknown>;
	//# sourceMappingURL=support-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/su-creation-type.d.ts
declare module '@sage/wh-product-data/lib/enums/su-creation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuCreationTypeEnum {
	    prepalletization = 1,
	    autoPalletization = 2,
	    palletization = 3
	}
	export interface SuCreationType$EnumInterface {
	    prepalletization: 1;
	    autoPalletization: 2;
	    palletization: 3;
	}
	export type SuCreationType = keyof SuCreationType$EnumInterface;
	export const suCreationTypeDatatype: X3EnumDataType<keyof SuCreationType$EnumInterface, unknown>;
	//# sourceMappingURL=su-creation-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/storing-list-purchase-order-status.d.ts
declare module '@sage/wh-product-data/lib/enums/storing-list-purchase-order-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StoringListPurchaseOrderStatusEnum {
	    notValidated = 1,
	    notUsed2 = 2,
	    partiallyValidated = 3,
	    validated = 4,
	    beingCreated = 5
	}
	export interface StoringListPurchaseOrderStatus$EnumInterface {
	    notValidated: 1;
	    notUsed2: 2;
	    partiallyValidated: 3;
	    validated: 4;
	    beingCreated: 5;
	}
	export type StoringListPurchaseOrderStatus = keyof StoringListPurchaseOrderStatus$EnumInterface;
	export const storingListPurchaseOrderStatusDatatype: X3EnumDataType<keyof StoringListPurchaseOrderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=storing-list-purchase-order-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/stock-on-quay-validation-type.d.ts
declare module '@sage/wh-product-data/lib/enums/stock-on-quay-validation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockOnQuayValidationTypeEnum {
	    immediate = 1,
	    deferred = 2
	}
	export interface StockOnQuayValidationType$EnumInterface {
	    immediate: 1;
	    deferred: 2;
	}
	export type StockOnQuayValidationType = keyof StockOnQuayValidationType$EnumInterface;
	export const stockOnQuayValidationTypeDatatype: X3EnumDataType<keyof StockOnQuayValidationType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-on-quay-validation-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/stock-on-quay-grouping-type.d.ts
declare module '@sage/wh-product-data/lib/enums/stock-on-quay-grouping-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockOnQuayGroupingTypeEnum {
	    byDockLocation = 1,
	    byDockLocationStatus = 2,
	    detailed = 3
	}
	export interface StockOnQuayGroupingType$EnumInterface {
	    byDockLocation: 1;
	    byDockLocationStatus: 2;
	    detailed: 3;
	}
	export type StockOnQuayGroupingType = keyof StockOnQuayGroupingType$EnumInterface;
	export const stockOnQuayGroupingTypeDatatype: X3EnumDataType<keyof StockOnQuayGroupingType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-on-quay-grouping-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/stock-object-type.d.ts
declare module '@sage/wh-product-data/lib/enums/stock-object-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockObjectTypeEnum {
	    normal = 1,
	    link = 2,
	    master = 3
	}
	export interface StockObjectType$EnumInterface {
	    normal: 1;
	    link: 2;
	    master: 3;
	}
	export type StockObjectType = keyof StockObjectType$EnumInterface;
	export const stockObjectTypeDatatype: X3EnumDataType<keyof StockObjectType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-object-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/stock-count-creation-origin.d.ts
declare module '@sage/wh-product-data/lib/enums/stock-count-creation-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountCreationOriginEnum {
	    manual = 1,
	    stockCountGeneration = 2,
	    simplifiedStockCount = 3
	}
	export interface StockCountCreationOrigin$EnumInterface {
	    manual: 1;
	    stockCountGeneration: 2;
	    simplifiedStockCount: 3;
	}
	export type StockCountCreationOrigin = keyof StockCountCreationOrigin$EnumInterface;
	export const stockCountCreationOriginDatatype: X3EnumDataType<keyof StockCountCreationOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-creation-origin.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/sorting-of-on-quay-parcels.d.ts
declare module '@sage/wh-product-data/lib/enums/sorting-of-on-quay-parcels' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortingOfOnQuayParcelsEnum {
	    byLocation = 1,
	    byStore = 2
	}
	export interface SortingOfOnQuayParcels$EnumInterface {
	    byLocation: 1;
	    byStore: 2;
	}
	export type SortingOfOnQuayParcels = keyof SortingOfOnQuayParcels$EnumInterface;
	export const sortingOfOnQuayParcelsDatatype: X3EnumDataType<keyof SortingOfOnQuayParcels$EnumInterface, unknown>;
	//# sourceMappingURL=sorting-of-on-quay-parcels.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/sort-stock.d.ts
declare module '@sage/wh-product-data/lib/enums/sort-stock' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortStockEnum {
	    byItem = 1,
	    byAddress = 2
	}
	export interface SortStock$EnumInterface {
	    byItem: 1;
	    byAddress: 2;
	}
	export type SortStock = keyof SortStock$EnumInterface;
	export const sortStockDatatype: X3EnumDataType<keyof SortStock$EnumInterface, unknown>;
	//# sourceMappingURL=sort-stock.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/sort-order-478.d.ts
declare module '@sage/wh-product-data/lib/enums/sort-order-478' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortOrder478Enum {
	    ascending = 1,
	    decreasing = 2
	}
	export interface SortOrder478$EnumInterface {
	    ascending: 1;
	    decreasing: 2;
	}
	export type SortOrder478 = keyof SortOrder478$EnumInterface;
	export const sortOrder478Datatype: X3EnumDataType<keyof SortOrder478$EnumInterface, unknown>;
	//# sourceMappingURL=sort-order-478.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/so-type.d.ts
declare module '@sage/wh-product-data/lib/enums/so-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SoTypeEnum {
	    neitherLocationNorSo = 1,
	    allSoLocationNoEditingOfIOMvts = 2,
	    allSoLocationIOMvts = 3,
	    onlySoWithIOMvtsLocation = 4
	}
	export interface SoType$EnumInterface {
	    neitherLocationNorSo: 1;
	    allSoLocationNoEditingOfIOMvts: 2;
	    allSoLocationIOMvts: 3;
	    onlySoWithIOMvtsLocation: 4;
	}
	export type SoType = keyof SoType$EnumInterface;
	export const soTypeDatatype: X3EnumDataType<keyof SoType$EnumInterface, unknown>;
	//# sourceMappingURL=so-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/simplified-stock-count-status.d.ts
declare module '@sage/wh-product-data/lib/enums/simplified-stock-count-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SimplifiedStockCountStatusEnum {
	    pending = 1,
	    nonComplying = 2,
	    withDiscrepancy = 3,
	    withoutDiscrepancy = 4,
	    validated = 5,
	    closed = 6
	}
	export interface SimplifiedStockCountStatus$EnumInterface {
	    pending: 1;
	    nonComplying: 2;
	    withDiscrepancy: 3;
	    withoutDiscrepancy: 4;
	    validated: 5;
	    closed: 6;
	}
	export type SimplifiedStockCountStatus = keyof SimplifiedStockCountStatus$EnumInterface;
	export const simplifiedStockCountStatusDatatype: X3EnumDataType<keyof SimplifiedStockCountStatus$EnumInterface, unknown>;
	//# sourceMappingURL=simplified-stock-count-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/shipping-unit-status.d.ts
declare module '@sage/wh-product-data/lib/enums/shipping-unit-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShippingUnitStatusEnum {
	    notUsed1 = 1,
	    notUsed2 = 2,
	    notUsed3 = 3,
	    notValidated = 4,
	    notUsed5 = 5,
	    preparationPending = 6,
	    waitingToLoad = 7,
	    waitToShip = 8,
	    shipped = 9
	}
	export interface ShippingUnitStatus$EnumInterface {
	    notUsed1: 1;
	    notUsed2: 2;
	    notUsed3: 3;
	    notValidated: 4;
	    notUsed5: 5;
	    preparationPending: 6;
	    waitingToLoad: 7;
	    waitToShip: 8;
	    shipped: 9;
	}
	export type ShippingUnitStatus = keyof ShippingUnitStatus$EnumInterface;
	export const shippingUnitStatusDatatype: X3EnumDataType<keyof ShippingUnitStatus$EnumInterface, unknown>;
	//# sourceMappingURL=shipping-unit-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/setup-type.d.ts
declare module '@sage/wh-product-data/lib/enums/setup-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SetupTypeEnum {
	    none = 1,
	    input = 2,
	    output = 3,
	    inputOutput = 4
	}
	export interface SetupType$EnumInterface {
	    none: 1;
	    input: 2;
	    output: 3;
	    inputOutput: 4;
	}
	export type SetupType = keyof SetupType$EnumInterface;
	export const setupTypeDatatype: X3EnumDataType<keyof SetupType$EnumInterface, unknown>;
	//# sourceMappingURL=setup-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/serial-action.d.ts
declare module '@sage/wh-product-data/lib/enums/serial-action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SerialActionEnum {
	    inputOnDi = 1,
	    diCancellation = 2,
	    diInterface = 3,
	    vtStorageInput = 4,
	    inputOnSl = 5,
	    slValidation = 6,
	    outputOnPo = 7,
	    outputOnDo = 8,
	    doCancellation = 9,
	    outputOnParcel = 10,
	    declaredPacking = 11,
	    outputOnVtPicking = 12,
	    shipmentCancellation = 13,
	    shipmentPostponement = 14,
	    shipmentRenewal = 15,
	    inputOnAdjustment = 16,
	    outputOnAdjustment = 17,
	    transfer = 18
	}
	export interface SerialAction$EnumInterface {
	    inputOnDi: 1;
	    diCancellation: 2;
	    diInterface: 3;
	    vtStorageInput: 4;
	    inputOnSl: 5;
	    slValidation: 6;
	    outputOnPo: 7;
	    outputOnDo: 8;
	    doCancellation: 9;
	    outputOnParcel: 10;
	    declaredPacking: 11;
	    outputOnVtPicking: 12;
	    shipmentCancellation: 13;
	    shipmentPostponement: 14;
	    shipmentRenewal: 15;
	    inputOnAdjustment: 16;
	    outputOnAdjustment: 17;
	    transfer: 18;
	}
	export type SerialAction = keyof SerialAction$EnumInterface;
	export const serialActionDatatype: X3EnumDataType<keyof SerialAction$EnumInterface, unknown>;
	//# sourceMappingURL=serial-action.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/search-type.d.ts
declare module '@sage/wh-product-data/lib/enums/search-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SearchTypeEnum {
	    scripts = 1,
	    screens = 2,
	    windows = 3
	}
	export interface SearchType$EnumInterface {
	    scripts: 1;
	    screens: 2;
	    windows: 3;
	}
	export type SearchType = keyof SearchType$EnumInterface;
	export const searchTypeDatatype: X3EnumDataType<keyof SearchType$EnumInterface, unknown>;
	//# sourceMappingURL=search-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/sampling-type.d.ts
declare module '@sage/wh-product-data/lib/enums/sampling-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SamplingTypeEnum {
	    none = 1,
	    simple = 2
	}
	export interface SamplingType$EnumInterface {
	    none: 1;
	    simple: 2;
	}
	export type SamplingType = keyof SamplingType$EnumInterface;
	export const samplingTypeDatatype: X3EnumDataType<keyof SamplingType$EnumInterface, unknown>;
	//# sourceMappingURL=sampling-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/sample-status.d.ts
declare module '@sage/wh-product-data/lib/enums/sample-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SampleStatusEnum {
	    notQualified = 1,
	    rejected = 2,
	    accepted = 3
	}
	export interface SampleStatus$EnumInterface {
	    notQualified: 1;
	    rejected: 2;
	    accepted: 3;
	}
	export type SampleStatus = keyof SampleStatus$EnumInterface;
	export const sampleStatusDatatype: X3EnumDataType<keyof SampleStatus$EnumInterface, unknown>;
	//# sourceMappingURL=sample-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/rotation-class-calcul-type.d.ts
declare module '@sage/wh-product-data/lib/enums/rotation-class-calcul-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RotationClassCalculTypeEnum {
	    byItem = 1,
	    byItemContainer = 2
	}
	export interface RotationClassCalculType$EnumInterface {
	    byItem: 1;
	    byItemContainer: 2;
	}
	export type RotationClassCalculType = keyof RotationClassCalculType$EnumInterface;
	export const rotationClassCalculTypeDatatype: X3EnumDataType<keyof RotationClassCalculType$EnumInterface, unknown>;
	//# sourceMappingURL=rotation-class-calcul-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/reversible-freezing.d.ts
declare module '@sage/wh-product-data/lib/enums/reversible-freezing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReversibleFreezingEnum {
	    no = 1,
	    yes = 2,
	    notUsed3 = 3
	}
	export interface ReversibleFreezing$EnumInterface {
	    no: 1;
	    yes: 2;
	    notUsed3: 3;
	}
	export type ReversibleFreezing = keyof ReversibleFreezing$EnumInterface;
	export const reversibleFreezingDatatype: X3EnumDataType<keyof ReversibleFreezing$EnumInterface, unknown>;
	//# sourceMappingURL=reversible-freezing.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/reserve-output-authorized.d.ts
declare module '@sage/wh-product-data/lib/enums/reserve-output-authorized' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReserveOutputAuthorizedEnum {
	    no = 1,
	    requestObject = 2,
	    requestPickingCapacity = 3,
	    always = 4
	}
	export interface ReserveOutputAuthorized$EnumInterface {
	    no: 1;
	    requestObject: 2;
	    requestPickingCapacity: 3;
	    always: 4;
	}
	export type ReserveOutputAuthorized = keyof ReserveOutputAuthorized$EnumInterface;
	export const reserveOutputAuthorizedDatatype: X3EnumDataType<keyof ReserveOutputAuthorized$EnumInterface, unknown>;
	//# sourceMappingURL=reserve-output-authorized.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/replenisment-transfer.d.ts
declare module '@sage/wh-product-data/lib/enums/replenisment-transfer' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplenismentTransferEnum {
	    replenishment = 1,
	    transfer = 2
	}
	export interface ReplenismentTransfer$EnumInterface {
	    replenishment: 1;
	    transfer: 2;
	}
	export type ReplenismentTransfer = keyof ReplenismentTransfer$EnumInterface;
	export const replenismentTransferDatatype: X3EnumDataType<keyof ReplenismentTransfer$EnumInterface, unknown>;
	//# sourceMappingURL=replenisment-transfer.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/replenishment-type.d.ts
declare module '@sage/wh-product-data/lib/enums/replenishment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplenishmentTypeEnum {
	    thresholdReplenishment = 1,
	    systematicReplenishment = 2
	}
	export interface ReplenishmentType$EnumInterface {
	    thresholdReplenishment: 1;
	    systematicReplenishment: 2;
	}
	export type ReplenishmentType = keyof ReplenishmentType$EnumInterface;
	export const replenishmentTypeDatatype: X3EnumDataType<keyof ReplenishmentType$EnumInterface, unknown>;
	//# sourceMappingURL=replenishment-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/replenishment-movement-type.d.ts
declare module '@sage/wh-product-data/lib/enums/replenishment-movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplenishmentMovementTypeEnum {
	    notUsed1 = 1,
	    notUsed2 = 2,
	    addressed = 3,
	    notUsed4 = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    transfertPending = 7,
	    validated = 8,
	    cancelled = 9
	}
	export interface ReplenishmentMovementType$EnumInterface {
	    notUsed1: 1;
	    notUsed2: 2;
	    addressed: 3;
	    notUsed4: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    transfertPending: 7;
	    validated: 8;
	    cancelled: 9;
	}
	export type ReplenishmentMovementType = keyof ReplenishmentMovementType$EnumInterface;
	export const replenishmentMovementTypeDatatype: X3EnumDataType<keyof ReplenishmentMovementType$EnumInterface, unknown>;
	//# sourceMappingURL=replenishment-movement-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/receipt-status.d.ts
declare module '@sage/wh-product-data/lib/enums/receipt-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptStatusEnum {
	    declared = 1,
	    pending = 2,
	    partiallyValidated = 3,
	    validated = 4
	}
	export interface ReceiptStatus$EnumInterface {
	    declared: 1;
	    pending: 2;
	    partiallyValidated: 3;
	    validated: 4;
	}
	export type ReceiptStatus = keyof ReceiptStatus$EnumInterface;
	export const receiptStatusDatatype: X3EnumDataType<keyof ReceiptStatus$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/receipt-status-877.d.ts
declare module '@sage/wh-product-data/lib/enums/receipt-status-877' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptStatus877Enum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface ReceiptStatus877$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type ReceiptStatus877 = keyof ReceiptStatus877$EnumInterface;
	export const receiptStatus877Datatype: X3EnumDataType<keyof ReceiptStatus877$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-status-877.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/receipt-reference-type.d.ts
declare module '@sage/wh-product-data/lib/enums/receipt-reference-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptReferenceTypeEnum {
	    none = 1,
	    expectedInputReference = 2,
	    orderReference = 3,
	    reference = 4
	}
	export interface ReceiptReferenceType$EnumInterface {
	    none: 1;
	    expectedInputReference: 2;
	    orderReference: 3;
	    reference: 4;
	}
	export type ReceiptReferenceType = keyof ReceiptReferenceType$EnumInterface;
	export const receiptReferenceTypeDatatype: X3EnumDataType<keyof ReceiptReferenceType$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-reference-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/receipt-line-status.d.ts
declare module '@sage/wh-product-data/lib/enums/receipt-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReceiptLineStatusEnum {
	    generated = 1,
	    dripAndDropRequested = 2,
	    dripAndDropInProcess = 3,
	    dripAndDropValidated = 4,
	    validated = 5
	}
	export interface ReceiptLineStatus$EnumInterface {
	    generated: 1;
	    dripAndDropRequested: 2;
	    dripAndDropInProcess: 3;
	    dripAndDropValidated: 4;
	    validated: 5;
	}
	export type ReceiptLineStatus = keyof ReceiptLineStatus$EnumInterface;
	export const receiptLineStatusDatatype: X3EnumDataType<keyof ReceiptLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=receipt-line-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/real-time-view-type.d.ts
declare module '@sage/wh-product-data/lib/enums/real-time-view-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RealTimeViewTypeEnum {
	    wave = 1,
	    round = 2
	}
	export interface RealTimeViewType$EnumInterface {
	    wave: 1;
	    round: 2;
	}
	export type RealTimeViewType = keyof RealTimeViewType$EnumInterface;
	export const realTimeViewTypeDatatype: X3EnumDataType<keyof RealTimeViewType$EnumInterface, unknown>;
	//# sourceMappingURL=real-time-view-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/print-dn.d.ts
declare module '@sage/wh-product-data/lib/enums/print-dn' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintDnEnum {
	    temporary = 1,
	    final = 2,
	    rePrint = 3
	}
	export interface PrintDn$EnumInterface {
	    temporary: 1;
	    final: 2;
	    rePrint: 3;
	}
	export type PrintDn = keyof PrintDn$EnumInterface;
	export const printDnDatatype: X3EnumDataType<keyof PrintDn$EnumInterface, unknown>;
	//# sourceMappingURL=print-dn.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/po-type.d.ts
declare module '@sage/wh-product-data/lib/enums/po-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PoTypeEnum {
	    picking = 1,
	    reserve = 2,
	    mixed = 3
	}
	export interface PoType$EnumInterface {
	    picking: 1;
	    reserve: 2;
	    mixed: 3;
	}
	export type PoType = keyof PoType$EnumInterface;
	export const poTypeDatatype: X3EnumDataType<keyof PoType$EnumInterface, unknown>;
	//# sourceMappingURL=po-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/po-print-sequence.d.ts
declare module '@sage/wh-product-data/lib/enums/po-print-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PoPrintSequenceEnum {
	    preparationAreaDo = 1,
	    doPreparationArea = 2
	}
	export interface PoPrintSequence$EnumInterface {
	    preparationAreaDo: 1;
	    doPreparationArea: 2;
	}
	export type PoPrintSequence = keyof PoPrintSequence$EnumInterface;
	export const poPrintSequenceDatatype: X3EnumDataType<keyof PoPrintSequence$EnumInterface, unknown>;
	//# sourceMappingURL=po-print-sequence.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/picking-location-priority.d.ts
declare module '@sage/wh-product-data/lib/enums/picking-location-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickingLocationPriorityEnum {
	    no = 1,
	    yesAlways = 2,
	    yesIfReserveIsEmpty = 3
	}
	export interface PickingLocationPriority$EnumInterface {
	    no: 1;
	    yesAlways: 2;
	    yesIfReserveIsEmpty: 3;
	}
	export type PickingLocationPriority = keyof PickingLocationPriority$EnumInterface;
	export const pickingLocationPriorityDatatype: X3EnumDataType<keyof PickingLocationPriority$EnumInterface, unknown>;
	//# sourceMappingURL=picking-location-priority.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/picking-dynamisation-status.d.ts
declare module '@sage/wh-product-data/lib/enums/picking-dynamisation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickingDynamisationStatusEnum {
	    waitIdealClasses = 1,
	    waitCurrentPickingBlockage = 2,
	    waitReallocation = 3,
	    waitTransferGeneration = 4,
	    waitMovementValidations = 5,
	    cancelled = 6,
	    validated = 7
	}
	export interface PickingDynamisationStatus$EnumInterface {
	    waitIdealClasses: 1;
	    waitCurrentPickingBlockage: 2;
	    waitReallocation: 3;
	    waitTransferGeneration: 4;
	    waitMovementValidations: 5;
	    cancelled: 6;
	    validated: 7;
	}
	export type PickingDynamisationStatus = keyof PickingDynamisationStatus$EnumInterface;
	export const pickingDynamisationStatusDatatype: X3EnumDataType<keyof PickingDynamisationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=picking-dynamisation-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/pending-mode.d.ts
declare module '@sage/wh-product-data/lib/enums/pending-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PendingModeEnum {
	    normal = 1
	}
	export interface PendingMode$EnumInterface {
	    normal: 1;
	}
	export type PendingMode = keyof PendingMode$EnumInterface;
	export const pendingModeDatatype: X3EnumDataType<"normal", unknown>;
	//# sourceMappingURL=pending-mode.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/parcel-su-print.d.ts
declare module '@sage/wh-product-data/lib/enums/parcel-su-print' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParcelSuPrintEnum {
	    parcel = 1,
	    su = 2,
	    suAndParcel = 3
	}
	export interface ParcelSuPrint$EnumInterface {
	    parcel: 1;
	    su: 2;
	    suAndParcel: 3;
	}
	export type ParcelSuPrint = keyof ParcelSuPrint$EnumInterface;
	export const parcelSuPrintDatatype: X3EnumDataType<keyof ParcelSuPrint$EnumInterface, unknown>;
	//# sourceMappingURL=parcel-su-print.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/parcel-status.d.ts
declare module '@sage/wh-product-data/lib/enums/parcel-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParcelStatusEnum {
	    notUsed1 = 1,
	    notUsed2 = 2,
	    creationPending = 3,
	    notValidated = 4,
	    autoPalletization = 5,
	    waitToPalletized = 6,
	    waitToLoad = 7,
	    waitToShip = 8,
	    shipped = 9
	}
	export interface ParcelStatus$EnumInterface {
	    notUsed1: 1;
	    notUsed2: 2;
	    creationPending: 3;
	    notValidated: 4;
	    autoPalletization: 5;
	    waitToPalletized: 6;
	    waitToLoad: 7;
	    waitToShip: 8;
	    shipped: 9;
	}
	export type ParcelStatus = keyof ParcelStatus$EnumInterface;
	export const parcelStatusDatatype: X3EnumDataType<keyof ParcelStatus$EnumInterface, unknown>;
	//# sourceMappingURL=parcel-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/parcel-action.d.ts
declare module '@sage/wh-product-data/lib/enums/parcel-action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParcelActionEnum {
	    creation = 1,
	    validation = 2,
	    suClosing3 = 3,
	    loading = 4,
	    unloading = 5,
	    palletization = 6,
	    depalletization = 7,
	    shipping8 = 8,
	    repacking = 9,
	    declarativePackingParcelCreation = 10,
	    dockTransferValidation = 11,
	    dockTransfer = 12,
	    carrierParcelUpdate = 13,
	    suOpening = 14,
	    report = 15,
	    reintegration = 16,
	    shipping = 17,
	    groupingParcelCreation = 18,
	    splittingDestinationParcelCreation = 19,
	    splittingDestinationParcelModification = 20,
	    splittingOriginalParcelCreation = 21,
	    parcelModification = 22,
	    suDeletion = 23,
	    parcelDeletion = 24,
	    shippingCancellation = 25,
	    suClosing = 26,
	    declarativePackingParcelModification = 27,
	    suGroupingSuCreation = 28,
	    suSplittingParcelPalletizationOnSu = 29,
	    suSplittingCreationOfSuDestination = 30,
	    suSplittingParcelDepalletizationOfASu = 31,
	    suModification = 32,
	    suSplittingSuParcelChange = 33,
	    suGroupingSuParcelChange = 34,
	    suGroupingSuDeletion = 35,
	    suSplittingSuDeletion = 36,
	    suValidation = 37,
	    prepalletization = 38,
	    autoPalletizationCancellation = 39
	}
	export interface ParcelAction$EnumInterface {
	    creation: 1;
	    validation: 2;
	    suClosing3: 3;
	    loading: 4;
	    unloading: 5;
	    palletization: 6;
	    depalletization: 7;
	    shipping8: 8;
	    repacking: 9;
	    declarativePackingParcelCreation: 10;
	    dockTransferValidation: 11;
	    dockTransfer: 12;
	    carrierParcelUpdate: 13;
	    suOpening: 14;
	    report: 15;
	    reintegration: 16;
	    shipping: 17;
	    groupingParcelCreation: 18;
	    splittingDestinationParcelCreation: 19;
	    splittingDestinationParcelModification: 20;
	    splittingOriginalParcelCreation: 21;
	    parcelModification: 22;
	    suDeletion: 23;
	    parcelDeletion: 24;
	    shippingCancellation: 25;
	    suClosing: 26;
	    declarativePackingParcelModification: 27;
	    suGroupingSuCreation: 28;
	    suSplittingParcelPalletizationOnSu: 29;
	    suSplittingCreationOfSuDestination: 30;
	    suSplittingParcelDepalletizationOfASu: 31;
	    suModification: 32;
	    suSplittingSuParcelChange: 33;
	    suGroupingSuParcelChange: 34;
	    suGroupingSuDeletion: 35;
	    suSplittingSuDeletion: 36;
	    suValidation: 37;
	    prepalletization: 38;
	    autoPalletizationCancellation: 39;
	}
	export type ParcelAction = keyof ParcelAction$EnumInterface;
	export const parcelActionDatatype: X3EnumDataType<keyof ParcelAction$EnumInterface, unknown>;
	//# sourceMappingURL=parcel-action.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/parameter-values.d.ts
declare module '@sage/wh-product-data/lib/enums/parameter-values' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterValuesEnum {
	    none = 1,
	    parameters = 2,
	    parametersParameterValues = 3
	}
	export interface ParameterValues$EnumInterface {
	    none: 1;
	    parameters: 2;
	    parametersParameterValues: 3;
	}
	export type ParameterValues = keyof ParameterValues$EnumInterface;
	export const parameterValuesDatatype: X3EnumDataType<keyof ParameterValues$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-values.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/palletization-type.d.ts
declare module '@sage/wh-product-data/lib/enums/palletization-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PalletizationTypeEnum {
	    prepalletization = 1,
	    autoPalletization = 2
	}
	export interface PalletizationType$EnumInterface {
	    prepalletization: 1;
	    autoPalletization: 2;
	}
	export type PalletizationType = keyof PalletizationType$EnumInterface;
	export const palletizationTypeDatatype: X3EnumDataType<keyof PalletizationType$EnumInterface, unknown>;
	//# sourceMappingURL=palletization-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/packing.d.ts
declare module '@sage/wh-product-data/lib/enums/packing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingEnum {
	    withoutPacking = 1,
	    prePacking = 2,
	    declarativePacking = 3
	}
	export interface Packing$EnumInterface {
	    withoutPacking: 1;
	    prePacking: 2;
	    declarativePacking: 3;
	}
	export type Packing = keyof Packing$EnumInterface;
	export const packingDatatype: X3EnumDataType<keyof Packing$EnumInterface, unknown>;
	//# sourceMappingURL=packing.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/packaging-group.d.ts
declare module '@sage/wh-product-data/lib/enums/packaging-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackagingGroupEnum {
	    i = 1,
	    ii = 2,
	    iii = 3,
	    notUsed4 = 4
	}
	export interface PackagingGroup$EnumInterface {
	    i: 1;
	    ii: 2;
	    iii: 3;
	    notUsed4: 4;
	}
	export type PackagingGroup = keyof PackagingGroup$EnumInterface;
	export const packagingGroupDatatype: X3EnumDataType<keyof PackagingGroup$EnumInterface, unknown>;
	//# sourceMappingURL=packaging-group.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/owner-type.d.ts
declare module '@sage/wh-product-data/lib/enums/owner-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OwnerTypeEnum {
	    company = 1,
	    site = 2,
	    supplier = 3
	}
	export interface OwnerType$EnumInterface {
	    company: 1;
	    site: 2;
	    supplier: 3;
	}
	export type OwnerType = keyof OwnerType$EnumInterface;
	export const ownerTypeDatatype: X3EnumDataType<keyof OwnerType$EnumInterface, unknown>;
	//# sourceMappingURL=owner-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/output-of-the-reserve.d.ts
declare module '@sage/wh-product-data/lib/enums/output-of-the-reserve' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OutputOfTheReserveEnum {
	    fifoDate = 1,
	    occupation = 2,
	    cuStkQuantity = 3,
	    store = 4,
	    fifoBracket = 5,
	    lotNumber = 6
	}
	export interface OutputOfTheReserve$EnumInterface {
	    fifoDate: 1;
	    occupation: 2;
	    cuStkQuantity: 3;
	    store: 4;
	    fifoBracket: 5;
	    lotNumber: 6;
	}
	export type OutputOfTheReserve = keyof OutputOfTheReserve$EnumInterface;
	export const outputOfTheReserveDatatype: X3EnumDataType<keyof OutputOfTheReserve$EnumInterface, unknown>;
	//# sourceMappingURL=output-of-the-reserve.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/output-mvt-sort.d.ts
declare module '@sage/wh-product-data/lib/enums/output-mvt-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OutputMvtSortEnum {
	    product = 1,
	    family = 2,
	    subFamily = 3,
	    group = 4,
	    subGroup = 5,
	    netWeight = 6,
	    netVolume = 7,
	    fifoDate = 8,
	    lot = 9,
	    supportNo = 10,
	    store = 11,
	    address = 12,
	    travelSequence = 13,
	    orderCustomer = 14,
	    shippedToCustomer = 15,
	    genericRound = 16,
	    round = 17,
	    roundPosition = 18,
	    dock = 19,
	    formula = 20,
	    reservation = 21,
	    postalCode = 22
	}
	export interface OutputMvtSort$EnumInterface {
	    product: 1;
	    family: 2;
	    subFamily: 3;
	    group: 4;
	    subGroup: 5;
	    netWeight: 6;
	    netVolume: 7;
	    fifoDate: 8;
	    lot: 9;
	    supportNo: 10;
	    store: 11;
	    address: 12;
	    travelSequence: 13;
	    orderCustomer: 14;
	    shippedToCustomer: 15;
	    genericRound: 16;
	    round: 17;
	    roundPosition: 18;
	    dock: 19;
	    formula: 20;
	    reservation: 21;
	    postalCode: 22;
	}
	export type OutputMvtSort = keyof OutputMvtSort$EnumInterface;
	export const outputMvtSortDatatype: X3EnumDataType<keyof OutputMvtSort$EnumInterface, unknown>;
	//# sourceMappingURL=output-mvt-sort.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/output-movement-status.d.ts
declare module '@sage/wh-product-data/lib/enums/output-movement-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OutputMovementStatusEnum {
	    beingAddressed = 1,
	    notUsed2 = 2,
	    addressed = 3,
	    inShortage = 4,
	    cancelledInThePreparation = 5,
	    cancelledInTheShipment = 6,
	    deferredInTheShipment = 7,
	    validated = 8,
	    shipped = 9
	}
	export interface OutputMovementStatus$EnumInterface {
	    beingAddressed: 1;
	    notUsed2: 2;
	    addressed: 3;
	    inShortage: 4;
	    cancelledInThePreparation: 5;
	    cancelledInTheShipment: 6;
	    deferredInTheShipment: 7;
	    validated: 8;
	    shipped: 9;
	}
	export type OutputMovementStatus = keyof OutputMovementStatus$EnumInterface;
	export const outputMovementStatusDatatype: X3EnumDataType<keyof OutputMovementStatus$EnumInterface, unknown>;
	//# sourceMappingURL=output-movement-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/order-category.d.ts
declare module '@sage/wh-product-data/lib/enums/order-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderCategoryEnum {
	    creation = 1,
	    modification = 2,
	    suppression = 3,
	    read = 4
	}
	export interface OrderCategory$EnumInterface {
	    creation: 1;
	    modification: 2;
	    suppression: 3;
	    read: 4;
	}
	export type OrderCategory = keyof OrderCategory$EnumInterface;
	export const orderCategoryDatatype: X3EnumDataType<keyof OrderCategory$EnumInterface, unknown>;
	//# sourceMappingURL=order-category.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/no-yes-blank.d.ts
declare module '@sage/wh-product-data/lib/enums/no-yes-blank' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesBlankEnum {
	    no = 1,
	    yes = 2,
	    substituteValue3 = 3
	}
	export interface NoYesBlank$EnumInterface {
	    no: 1;
	    yes: 2;
	    substituteValue3: 3;
	}
	export type NoYesBlank = keyof NoYesBlank$EnumInterface;
	export const noYesBlankDatatype: X3EnumDataType<keyof NoYesBlank$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-blank.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/multi-picking-issue.d.ts
declare module '@sage/wh-product-data/lib/enums/multi-picking-issue' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MultiPickingIssueEnum {
	    fifoDate = 1,
	    occupation = 2,
	    cuQuantity = 3,
	    pickingPriority = 4,
	    fifoBracket = 5
	}
	export interface MultiPickingIssue$EnumInterface {
	    fifoDate: 1;
	    occupation: 2;
	    cuQuantity: 3;
	    pickingPriority: 4;
	    fifoBracket: 5;
	}
	export type MultiPickingIssue = keyof MultiPickingIssue$EnumInterface;
	export const multiPickingIssueDatatype: X3EnumDataType<keyof MultiPickingIssue$EnumInterface, unknown>;
	//# sourceMappingURL=multi-picking-issue.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/movement-type.d.ts
declare module '@sage/wh-product-data/lib/enums/movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementTypeEnum {
	    normal = 1,
	    mergingWithAccrual = 2,
	    mergingWithoutAccrual = 3,
	    stockOutReplenishment = 4,
	    preventiveReplenishment = 5,
	    transferEntireContainer = 6,
	    mergingFlowsTransfer = 7,
	    mergingFlowsReplenishment = 8,
	    componentTransfer = 9,
	    componentReplen = 10,
	    kitTransfer = 11,
	    kitReorder = 12
	}
	export interface MovementType$EnumInterface {
	    normal: 1;
	    mergingWithAccrual: 2;
	    mergingWithoutAccrual: 3;
	    stockOutReplenishment: 4;
	    preventiveReplenishment: 5;
	    transferEntireContainer: 6;
	    mergingFlowsTransfer: 7;
	    mergingFlowsReplenishment: 8;
	    componentTransfer: 9;
	    componentReplen: 10;
	    kitTransfer: 11;
	    kitReorder: 12;
	}
	export type MovementType = keyof MovementType$EnumInterface;
	export const movementTypeDatatype: X3EnumDataType<keyof MovementType$EnumInterface, unknown>;
	//# sourceMappingURL=movement-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/movement-type-465.d.ts
declare module '@sage/wh-product-data/lib/enums/movement-type-465' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementType465Enum {
	    input = 1,
	    transferRepositioning = 2,
	    adjustment = 3,
	    transferRemoval = 4,
	    output = 5,
	    assembly = 6
	}
	export interface MovementType465$EnumInterface {
	    input: 1;
	    transferRepositioning: 2;
	    adjustment: 3;
	    transferRemoval: 4;
	    output: 5;
	    assembly: 6;
	}
	export type MovementType465 = keyof MovementType465$EnumInterface;
	export const movementType465Datatype: X3EnumDataType<keyof MovementType465$EnumInterface, unknown>;
	//# sourceMappingURL=movement-type-465.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/movement-type-416.d.ts
declare module '@sage/wh-product-data/lib/enums/movement-type-416' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementType416Enum {
	    input = 1,
	    depositTrf = 2,
	    depositRepl = 3,
	    deposit2P = 4,
	    output = 5,
	    pickTrf = 6,
	    pickRepl = 7,
	    pick2P = 8
	}
	export interface MovementType416$EnumInterface {
	    input: 1;
	    depositTrf: 2;
	    depositRepl: 3;
	    deposit2P: 4;
	    output: 5;
	    pickTrf: 6;
	    pickRepl: 7;
	    pick2P: 8;
	}
	export type MovementType416 = keyof MovementType416$EnumInterface;
	export const movementType416Datatype: X3EnumDataType<keyof MovementType416$EnumInterface, unknown>;
	//# sourceMappingURL=movement-type-416.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/movement-origin.d.ts
declare module '@sage/wh-product-data/lib/enums/movement-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MovementOriginEnum {
	    picking = 1,
	    replenishment = 2,
	    inventoryLines = 3
	}
	export interface MovementOrigin$EnumInterface {
	    picking: 1;
	    replenishment: 2;
	    inventoryLines: 3;
	}
	export type MovementOrigin = keyof MovementOrigin$EnumInterface;
	export const movementOriginDatatype: X3EnumDataType<keyof MovementOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=movement-origin.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/mission-status.d.ts
declare module '@sage/wh-product-data/lib/enums/mission-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MissionStatusEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9
	}
	export interface MissionStatus$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	}
	export type MissionStatus = keyof MissionStatus$EnumInterface;
	export const missionStatusDatatype: X3EnumDataType<keyof MissionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=mission-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/mission-area-type.d.ts
declare module '@sage/wh-product-data/lib/enums/mission-area-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MissionAreaTypeEnum {
	    receivingDock = 1,
	    shippingDock = 2,
	    bufferArea = 3,
	    travelSequence = 4
	}
	export interface MissionAreaType$EnumInterface {
	    receivingDock: 1;
	    shippingDock: 2;
	    bufferArea: 3;
	    travelSequence: 4;
	}
	export type MissionAreaType = keyof MissionAreaType$EnumInterface;
	export const missionAreaTypeDatatype: X3EnumDataType<keyof MissionAreaType$EnumInterface, unknown>;
	//# sourceMappingURL=mission-area-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/merging-in-input.d.ts
declare module '@sage/wh-product-data/lib/enums/merging-in-input' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MergingInInputEnum {
	    no = 1,
	    yes = 2,
	    yesIfIncomplete = 3,
	    yesIfNotStandard = 4
	}
	export interface MergingInInput$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesIfIncomplete: 3;
	    yesIfNotStandard: 4;
	}
	export type MergingInInput = keyof MergingInInput$EnumInterface;
	export const mergingInInputDatatype: X3EnumDataType<keyof MergingInInput$EnumInterface, unknown>;
	//# sourceMappingURL=merging-in-input.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/material-type.d.ts
declare module '@sage/wh-product-data/lib/enums/material-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialTypeEnum {
	    liquidMaterial = 1,
	    solidMaterial = 2
	}
	export interface MaterialType$EnumInterface {
	    liquidMaterial: 1;
	    solidMaterial: 2;
	}
	export type MaterialType = keyof MaterialType$EnumInterface;
	export const materialTypeDatatype: X3EnumDataType<keyof MaterialType$EnumInterface, unknown>;
	//# sourceMappingURL=material-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/lu-selection-type.d.ts
declare module '@sage/wh-product-data/lib/enums/lu-selection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LuSelectionTypeEnum {
	    parcel = 1,
	    su = 2
	}
	export interface LuSelectionType$EnumInterface {
	    parcel: 1;
	    su: 2;
	}
	export type LuSelectionType = keyof LuSelectionType$EnumInterface;
	export const luSelectionTypeDatatype: X3EnumDataType<keyof LuSelectionType$EnumInterface, unknown>;
	//# sourceMappingURL=lu-selection-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/location-type-467.d.ts
declare module '@sage/wh-product-data/lib/enums/location-type-467' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationType467Enum {
	    none = 1,
	    productLocation = 2,
	    productLocationPossibleLocations = 3
	}
	export interface LocationType467$EnumInterface {
	    none: 1;
	    productLocation: 2;
	    productLocationPossibleLocations: 3;
	}
	export type LocationType467 = keyof LocationType467$EnumInterface;
	export const locationType467Datatype: X3EnumDataType<keyof LocationType467$EnumInterface, unknown>;
	//# sourceMappingURL=location-type-467.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/load-split.d.ts
declare module '@sage/wh-product-data/lib/enums/load-split' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadSplitEnum {
	    parcel = 1,
	    su = 2
	}
	export interface LoadSplit$EnumInterface {
	    parcel: 1;
	    su: 2;
	}
	export type LoadSplit = keyof LoadSplit$EnumInterface;
	export const loadSplitDatatype: X3EnumDataType<keyof LoadSplit$EnumInterface, unknown>;
	//# sourceMappingURL=load-split.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/load-range-entity.d.ts
declare module '@sage/wh-product-data/lib/enums/load-range-entity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadRangeEntityEnum {
	    item = 1,
	    ei = 2,
	    eiLine = 3,
	    do = 4,
	    doLine = 5,
	    parcel = 6,
	    su = 7,
	    movement = 8,
	    appointment = 9
	}
	export interface LoadRangeEntity$EnumInterface {
	    item: 1;
	    ei: 2;
	    eiLine: 3;
	    do: 4;
	    doLine: 5;
	    parcel: 6;
	    su: 7;
	    movement: 8;
	    appointment: 9;
	}
	export type LoadRangeEntity = keyof LoadRangeEntity$EnumInterface;
	export const loadRangeEntityDatatype: X3EnumDataType<keyof LoadRangeEntity$EnumInterface, unknown>;
	//# sourceMappingURL=load-range-entity.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/line-status.d.ts
declare module '@sage/wh-product-data/lib/enums/line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineStatusEnum {
	    waiting = 1,
	    closed = 2,
	    validated = 3
	}
	export interface LineStatus$EnumInterface {
	    waiting: 1;
	    closed: 2;
	    validated: 3;
	}
	export type LineStatus = keyof LineStatus$EnumInterface;
	export const lineStatusDatatype: X3EnumDataType<keyof LineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=line-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/licence-info.d.ts
declare module '@sage/wh-product-data/lib/enums/licence-info' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LicenceInfoEnum {
	    routing = 1,
	    maxNrSites = 2,
	    maxNrDepositors = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9
	}
	export interface LicenceInfo$EnumInterface {
	    routing: 1;
	    maxNrSites: 2;
	    maxNrDepositors: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	}
	export type LicenceInfo = keyof LicenceInfo$EnumInterface;
	export const licenceInfoDatatype: X3EnumDataType<keyof LicenceInfo$EnumInterface, unknown>;
	//# sourceMappingURL=licence-info.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/invoice-status.d.ts
declare module '@sage/wh-product-data/lib/enums/invoice-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceStatusEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9
	}
	export interface InvoiceStatus$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	}
	export type InvoiceStatus = keyof InvoiceStatus$EnumInterface;
	export const invoiceStatusDatatype: X3EnumDataType<keyof InvoiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/invoice-line-type.d.ts
declare module '@sage/wh-product-data/lib/enums/invoice-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceLineTypeEnum {
	    proportional = 1,
	    fixed = 2,
	    byRange = 3
	}
	export interface InvoiceLineType$EnumInterface {
	    proportional: 1;
	    fixed: 2;
	    byRange: 3;
	}
	export type InvoiceLineType = keyof InvoiceLineType$EnumInterface;
	export const invoiceLineTypeDatatype: X3EnumDataType<keyof InvoiceLineType$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-line-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/inventory-type.d.ts
declare module '@sage/wh-product-data/lib/enums/inventory-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InventoryTypeEnum {
	    byAddress = 1,
	    byItem = 2
	}
	export interface InventoryType$EnumInterface {
	    byAddress: 1;
	    byItem: 2;
	}
	export type InventoryType = keyof InventoryType$EnumInterface;
	export const inventoryTypeDatatype: X3EnumDataType<keyof InventoryType$EnumInterface, unknown>;
	//# sourceMappingURL=inventory-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/inventory-status.d.ts
declare module '@sage/wh-product-data/lib/enums/inventory-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InventoryStatusEnum {
	    pending = 1,
	    closed = 2,
	    settled = 3,
	    partiallyClosed = 4
	}
	export interface InventoryStatus$EnumInterface {
	    pending: 1;
	    closed: 2;
	    settled: 3;
	    partiallyClosed: 4;
	}
	export type InventoryStatus = keyof InventoryStatus$EnumInterface;
	export const inventoryStatusDatatype: X3EnumDataType<keyof InventoryStatus$EnumInterface, unknown>;
	//# sourceMappingURL=inventory-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/inventory-line-type.d.ts
declare module '@sage/wh-product-data/lib/enums/inventory-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InventoryLineTypeEnum {
	    pending = 1,
	    closed = 2,
	    settled = 3,
	    canBeClosed = 4,
	    cannotBeClosed = 5
	}
	export interface InventoryLineType$EnumInterface {
	    pending: 1;
	    closed: 2;
	    settled: 3;
	    canBeClosed: 4;
	    cannotBeClosed: 5;
	}
	export type InventoryLineType = keyof InventoryLineType$EnumInterface;
	export const inventoryLineTypeDatatype: X3EnumDataType<keyof InventoryLineType$EnumInterface, unknown>;
	//# sourceMappingURL=inventory-line-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/inventory-discrepancy.d.ts
declare module '@sage/wh-product-data/lib/enums/inventory-discrepancy' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InventoryDiscrepancyEnum {
	    no = 1,
	    yes = 2,
	    adjustedInPart = 3,
	    adjusted = 4,
	    notAdjusted = 5
	}
	export interface InventoryDiscrepancy$EnumInterface {
	    no: 1;
	    yes: 2;
	    adjustedInPart: 3;
	    adjusted: 4;
	    notAdjusted: 5;
	}
	export type InventoryDiscrepancy = keyof InventoryDiscrepancy$EnumInterface;
	export const inventoryDiscrepancyDatatype: X3EnumDataType<keyof InventoryDiscrepancy$EnumInterface, unknown>;
	//# sourceMappingURL=inventory-discrepancy.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/interface-type.d.ts
declare module '@sage/wh-product-data/lib/enums/interface-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterfaceTypeEnum {
	    transmission = 1,
	    receipt = 2
	}
	export interface InterfaceType$EnumInterface {
	    transmission: 1;
	    receipt: 2;
	}
	export type InterfaceType = keyof InterfaceType$EnumInterface;
	export const interfaceTypeDatatype: X3EnumDataType<keyof InterfaceType$EnumInterface, unknown>;
	//# sourceMappingURL=interface-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/input-report.d.ts
declare module '@sage/wh-product-data/lib/enums/input-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InputReportEnum {
	    directInput = 1,
	    inputLine = 2,
	    movement = 3
	}
	export interface InputReport$EnumInterface {
	    directInput: 1;
	    inputLine: 2;
	    movement: 3;
	}
	export type InputReport = keyof InputReport$EnumInterface;
	export const inputReportDatatype: X3EnumDataType<keyof InputReport$EnumInterface, unknown>;
	//# sourceMappingURL=input-report.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/input-movement-status.d.ts
declare module '@sage/wh-product-data/lib/enums/input-movement-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InputMovementStatusEnum {
	    notAddressed = 1,
	    notUsed2 = 2,
	    notUsed3 = 3,
	    addressed = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    storedClosed = 8
	}
	export interface InputMovementStatus$EnumInterface {
	    notAddressed: 1;
	    notUsed2: 2;
	    notUsed3: 3;
	    addressed: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    storedClosed: 8;
	}
	export type InputMovementStatus = keyof InputMovementStatus$EnumInterface;
	export const inputMovementStatusDatatype: X3EnumDataType<keyof InputMovementStatus$EnumInterface, unknown>;
	//# sourceMappingURL=input-movement-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/input-line-status.d.ts
declare module '@sage/wh-product-data/lib/enums/input-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InputLineStatusEnum {
	    notAddressed = 1,
	    notUsed2 = 2,
	    notUsed3 = 3,
	    addressed = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    storedClosed = 8
	}
	export interface InputLineStatus$EnumInterface {
	    notAddressed: 1;
	    notUsed2: 2;
	    notUsed3: 3;
	    addressed: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    storedClosed: 8;
	}
	export type InputLineStatus = keyof InputLineStatus$EnumInterface;
	export const inputLineStatusDatatype: X3EnumDataType<keyof InputLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=input-line-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/input-header-status.d.ts
declare module '@sage/wh-product-data/lib/enums/input-header-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InputHeaderStatusEnum {
	    notAdressed = 1,
	    inControl = 2,
	    notUsed3 = 3,
	    adressed = 4,
	    notUset5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    storedClosed = 8
	}
	export interface InputHeaderStatus$EnumInterface {
	    notAdressed: 1;
	    inControl: 2;
	    notUsed3: 3;
	    adressed: 4;
	    notUset5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    storedClosed: 8;
	}
	export type InputHeaderStatus = keyof InputHeaderStatus$EnumInterface;
	export const inputHeaderStatusDatatype: X3EnumDataType<keyof InputHeaderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=input-header-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/index.d.ts
declare module '@sage/wh-product-data/lib/enums/index' {
	export * from '@sage/wh-product-data/lib/enums/action-458';
	export * from '@sage/wh-product-data/lib/enums/action-type';
	export * from '@sage/wh-product-data/lib/enums/action';
	export * from '@sage/wh-product-data/lib/enums/ad-status';
	export * from '@sage/wh-product-data/lib/enums/address-structure';
	export * from '@sage/wh-product-data/lib/enums/allocation-method';
	export * from '@sage/wh-product-data/lib/enums/appointment-weight';
	export * from '@sage/wh-product-data/lib/enums/assembly-movement-status';
	export * from '@sage/wh-product-data/lib/enums/assembly-order-status';
	export * from '@sage/wh-product-data/lib/enums/auto-palletization-status';
	export * from '@sage/wh-product-data/lib/enums/blocking-reason';
	export * from '@sage/wh-product-data/lib/enums/blocking-type';
	export * from '@sage/wh-product-data/lib/enums/cancelation-of-ei-shortage';
	export * from '@sage/wh-product-data/lib/enums/circulation-direction';
	export * from '@sage/wh-product-data/lib/enums/circulation-type';
	export * from '@sage/wh-product-data/lib/enums/class';
	export * from '@sage/wh-product-data/lib/enums/code-128-police';
	export * from '@sage/wh-product-data/lib/enums/colis';
	export * from '@sage/wh-product-data/lib/enums/consumable-mvt-origin';
	export * from '@sage/wh-product-data/lib/enums/consumable-mvt-sorting';
	export * from '@sage/wh-product-data/lib/enums/consumable-mvt-type-429';
	export * from '@sage/wh-product-data/lib/enums/consumable-sorting';
	export * from '@sage/wh-product-data/lib/enums/control-type-397';
	export * from '@sage/wh-product-data/lib/enums/counting-print';
	export * from '@sage/wh-product-data/lib/enums/counting-type';
	export * from '@sage/wh-product-data/lib/enums/cross-docking-cover';
	export * from '@sage/wh-product-data/lib/enums/cross-docking';
	export * from '@sage/wh-product-data/lib/enums/crystal-report-dgg';
	export * from '@sage/wh-product-data/lib/enums/crystal-report';
	export * from '@sage/wh-product-data/lib/enums/custk';
	export * from '@sage/wh-product-data/lib/enums/data-file-type-461';
	export * from '@sage/wh-product-data/lib/enums/date-contract-unit';
	export * from '@sage/wh-product-data/lib/enums/delivery-order-line-status';
	export * from '@sage/wh-product-data/lib/enums/dispatchable-in-state';
	export * from '@sage/wh-product-data/lib/enums/do-line-type';
	export * from '@sage/wh-product-data/lib/enums/edi-level';
	export * from '@sage/wh-product-data/lib/enums/edi-mngt-status';
	export * from '@sage/wh-product-data/lib/enums/end-day';
	export * from '@sage/wh-product-data/lib/enums/expected-input-line-status';
	export * from '@sage/wh-product-data/lib/enums/expected-input-status';
	export * from '@sage/wh-product-data/lib/enums/fifo-date';
	export * from '@sage/wh-product-data/lib/enums/formula-type-406';
	export * from '@sage/wh-product-data/lib/enums/geode-edition';
	export * from '@sage/wh-product-data/lib/enums/incomplete-output-authorized';
	export * from '@sage/wh-product-data/lib/enums/input-header-status';
	export * from '@sage/wh-product-data/lib/enums/input-line-status';
	export * from '@sage/wh-product-data/lib/enums/input-movement-status';
	export * from '@sage/wh-product-data/lib/enums/input-report';
	export * from '@sage/wh-product-data/lib/enums/interface-type';
	export * from '@sage/wh-product-data/lib/enums/inventory-discrepancy';
	export * from '@sage/wh-product-data/lib/enums/inventory-line-type';
	export * from '@sage/wh-product-data/lib/enums/inventory-status';
	export * from '@sage/wh-product-data/lib/enums/inventory-type';
	export * from '@sage/wh-product-data/lib/enums/invoice-line-type';
	export * from '@sage/wh-product-data/lib/enums/invoice-status';
	export * from '@sage/wh-product-data/lib/enums/licence-info';
	export * from '@sage/wh-product-data/lib/enums/line-status';
	export * from '@sage/wh-product-data/lib/enums/load-range-entity';
	export * from '@sage/wh-product-data/lib/enums/load-split';
	export * from '@sage/wh-product-data/lib/enums/location-type-467';
	export * from '@sage/wh-product-data/lib/enums/lu-selection-type';
	export * from '@sage/wh-product-data/lib/enums/material-type';
	export * from '@sage/wh-product-data/lib/enums/merging-in-input';
	export * from '@sage/wh-product-data/lib/enums/mission-area-type';
	export * from '@sage/wh-product-data/lib/enums/mission-status';
	export * from '@sage/wh-product-data/lib/enums/movement-origin';
	export * from '@sage/wh-product-data/lib/enums/movement-type-416';
	export * from '@sage/wh-product-data/lib/enums/movement-type-465';
	export * from '@sage/wh-product-data/lib/enums/movement-type';
	export * from '@sage/wh-product-data/lib/enums/multi-picking-issue';
	export * from '@sage/wh-product-data/lib/enums/no-yes-blank';
	export * from '@sage/wh-product-data/lib/enums/order-category';
	export * from '@sage/wh-product-data/lib/enums/output-movement-status';
	export * from '@sage/wh-product-data/lib/enums/output-mvt-sort';
	export * from '@sage/wh-product-data/lib/enums/output-of-the-reserve';
	export * from '@sage/wh-product-data/lib/enums/owner-type';
	export * from '@sage/wh-product-data/lib/enums/packaging-group';
	export * from '@sage/wh-product-data/lib/enums/packing';
	export * from '@sage/wh-product-data/lib/enums/palletization-type';
	export * from '@sage/wh-product-data/lib/enums/parameter-values';
	export * from '@sage/wh-product-data/lib/enums/parcel-action';
	export * from '@sage/wh-product-data/lib/enums/parcel-status';
	export * from '@sage/wh-product-data/lib/enums/parcel-su-print';
	export * from '@sage/wh-product-data/lib/enums/pending-mode';
	export * from '@sage/wh-product-data/lib/enums/picking-dynamisation-status';
	export * from '@sage/wh-product-data/lib/enums/picking-location-priority';
	export * from '@sage/wh-product-data/lib/enums/po-print-sequence';
	export * from '@sage/wh-product-data/lib/enums/po-type';
	export * from '@sage/wh-product-data/lib/enums/print-dn';
	export * from '@sage/wh-product-data/lib/enums/real-time-view-type';
	export * from '@sage/wh-product-data/lib/enums/receipt-line-status';
	export * from '@sage/wh-product-data/lib/enums/receipt-reference-type';
	export * from '@sage/wh-product-data/lib/enums/receipt-status-877';
	export * from '@sage/wh-product-data/lib/enums/receipt-status';
	export * from '@sage/wh-product-data/lib/enums/replenishment-movement-type';
	export * from '@sage/wh-product-data/lib/enums/replenishment-type';
	export * from '@sage/wh-product-data/lib/enums/replenisment-transfer';
	export * from '@sage/wh-product-data/lib/enums/reserve-output-authorized';
	export * from '@sage/wh-product-data/lib/enums/reversible-freezing';
	export * from '@sage/wh-product-data/lib/enums/rotation-class-calcul-type';
	export * from '@sage/wh-product-data/lib/enums/sample-status';
	export * from '@sage/wh-product-data/lib/enums/sampling-type';
	export * from '@sage/wh-product-data/lib/enums/search-type';
	export * from '@sage/wh-product-data/lib/enums/serial-action';
	export * from '@sage/wh-product-data/lib/enums/setup-type';
	export * from '@sage/wh-product-data/lib/enums/shipping-unit-status';
	export * from '@sage/wh-product-data/lib/enums/simplified-stock-count-status';
	export * from '@sage/wh-product-data/lib/enums/so-type';
	export * from '@sage/wh-product-data/lib/enums/sort-order-478';
	export * from '@sage/wh-product-data/lib/enums/sort-stock';
	export * from '@sage/wh-product-data/lib/enums/sorting-of-on-quay-parcels';
	export * from '@sage/wh-product-data/lib/enums/stock-count-creation-origin';
	export * from '@sage/wh-product-data/lib/enums/stock-object-type';
	export * from '@sage/wh-product-data/lib/enums/stock-on-quay-grouping-type';
	export * from '@sage/wh-product-data/lib/enums/stock-on-quay-validation-type';
	export * from '@sage/wh-product-data/lib/enums/storing-list-purchase-order-status';
	export * from '@sage/wh-product-data/lib/enums/su-creation-type';
	export * from '@sage/wh-product-data/lib/enums/support-status';
	export * from '@sage/wh-product-data/lib/enums/threshold-pallet-always';
	export * from '@sage/wh-product-data/lib/enums/time-slots';
	export * from '@sage/wh-product-data/lib/enums/total-statistics';
	export * from '@sage/wh-product-data/lib/enums/trace-level';
	export * from '@sage/wh-product-data/lib/enums/transfer-phase';
	export * from '@sage/wh-product-data/lib/enums/transfer-to-store';
	export * from '@sage/wh-product-data/lib/enums/transfer-validation';
	export * from '@sage/wh-product-data/lib/enums/transmission-l-3';
	export * from '@sage/wh-product-data/lib/enums/type-815';
	export * from '@sage/wh-product-data/lib/enums/type-of-activity';
	export * from '@sage/wh-product-data/lib/enums/type-of-analysis';
	export * from '@sage/wh-product-data/lib/enums/type-of-entity';
	export * from '@sage/wh-product-data/lib/enums/type';
	export * from '@sage/wh-product-data/lib/enums/unavailability-type';
	export * from '@sage/wh-product-data/lib/enums/unit-length';
	export * from '@sage/wh-product-data/lib/enums/validation-process';
	export * from '@sage/wh-product-data/lib/enums/view-type';
	export * from '@sage/wh-product-data/lib/enums/vt-grouping-criteria';
	export * from '@sage/wh-product-data/lib/enums/wave-status';
	export * from '@sage/wh-product-data/lib/enums/wave-type-409';
	export * from '@sage/wh-product-data/lib/enums/wave-type';
	export * from '@sage/wh-product-data/lib/enums/zone-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/incomplete-output-authorized.d.ts
declare module '@sage/wh-product-data/lib/enums/incomplete-output-authorized' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IncompleteOutputAuthorizedEnum {
	    no = 1,
	    requestStandardQuantity = 2,
	    always = 3
	}
	export interface IncompleteOutputAuthorized$EnumInterface {
	    no: 1;
	    requestStandardQuantity: 2;
	    always: 3;
	}
	export type IncompleteOutputAuthorized = keyof IncompleteOutputAuthorized$EnumInterface;
	export const incompleteOutputAuthorizedDatatype: X3EnumDataType<keyof IncompleteOutputAuthorized$EnumInterface, unknown>;
	//# sourceMappingURL=incomplete-output-authorized.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/geode-edition.d.ts
declare module '@sage/wh-product-data/lib/enums/geode-edition' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GeodeEditionEnum {
	    standardEdition = 1,
	    advancedEdition = 2,
	    premiumEdition = 3
	}
	export interface GeodeEdition$EnumInterface {
	    standardEdition: 1;
	    advancedEdition: 2;
	    premiumEdition: 3;
	}
	export type GeodeEdition = keyof GeodeEdition$EnumInterface;
	export const geodeEditionDatatype: X3EnumDataType<keyof GeodeEdition$EnumInterface, unknown>;
	//# sourceMappingURL=geode-edition.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/formula-type-406.d.ts
declare module '@sage/wh-product-data/lib/enums/formula-type-406' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FormulaType406Enum {
	    rotationClasses = 1,
	    receipts = 2
	}
	export interface FormulaType406$EnumInterface {
	    rotationClasses: 1;
	    receipts: 2;
	}
	export type FormulaType406 = keyof FormulaType406$EnumInterface;
	export const formulaType406Datatype: X3EnumDataType<keyof FormulaType406$EnumInterface, unknown>;
	//# sourceMappingURL=formula-type-406.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/fifo-date.d.ts
declare module '@sage/wh-product-data/lib/enums/fifo-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FifoDateEnum {
	    input = 1,
	    manufacturing = 2,
	    sellByDate = 3,
	    maximumConservationLimit = 4,
	    sendByDateLimit = 5
	}
	export interface FifoDate$EnumInterface {
	    input: 1;
	    manufacturing: 2;
	    sellByDate: 3;
	    maximumConservationLimit: 4;
	    sendByDateLimit: 5;
	}
	export type FifoDate = keyof FifoDate$EnumInterface;
	export const fifoDateDatatype: X3EnumDataType<keyof FifoDate$EnumInterface, unknown>;
	//# sourceMappingURL=fifo-date.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/expected-input-status.d.ts
declare module '@sage/wh-product-data/lib/enums/expected-input-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpectedInputStatusEnum {
	    notReceived = 1,
	    partialReceipt = 2,
	    firstReceiptPending = 3,
	    fourthReceiptPending = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    receivedClosed = 8
	}
	export interface ExpectedInputStatus$EnumInterface {
	    notReceived: 1;
	    partialReceipt: 2;
	    firstReceiptPending: 3;
	    fourthReceiptPending: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    receivedClosed: 8;
	}
	export type ExpectedInputStatus = keyof ExpectedInputStatus$EnumInterface;
	export const expectedInputStatusDatatype: X3EnumDataType<keyof ExpectedInputStatus$EnumInterface, unknown>;
	//# sourceMappingURL=expected-input-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/expected-input-line-status.d.ts
declare module '@sage/wh-product-data/lib/enums/expected-input-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpectedInputLineStatusEnum {
	    notReceived = 1,
	    partialReceipt = 2,
	    notUsed3 = 3,
	    notUsed4 = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    receivedClosed = 8
	}
	export interface ExpectedInputLineStatus$EnumInterface {
	    notReceived: 1;
	    partialReceipt: 2;
	    notUsed3: 3;
	    notUsed4: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    receivedClosed: 8;
	}
	export type ExpectedInputLineStatus = keyof ExpectedInputLineStatus$EnumInterface;
	export const expectedInputLineStatusDatatype: X3EnumDataType<keyof ExpectedInputLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=expected-input-line-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/end-day.d.ts
declare module '@sage/wh-product-data/lib/enums/end-day' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EndDayEnum {
	    d = 1,
	    d1 = 2
	}
	export interface EndDay$EnumInterface {
	    d: 1;
	    d1: 2;
	}
	export type EndDay = keyof EndDay$EnumInterface;
	export const endDayDatatype: X3EnumDataType<keyof EndDay$EnumInterface, unknown>;
	//# sourceMappingURL=end-day.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/edi-mngt-status.d.ts
declare module '@sage/wh-product-data/lib/enums/edi-mngt-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EdiMngtStatusEnum {
	    pending = 1,
	    finished = 2,
	    notConcerned = 3
	}
	export interface EdiMngtStatus$EnumInterface {
	    pending: 1;
	    finished: 2;
	    notConcerned: 3;
	}
	export type EdiMngtStatus = keyof EdiMngtStatus$EnumInterface;
	export const ediMngtStatusDatatype: X3EnumDataType<keyof EdiMngtStatus$EnumInterface, unknown>;
	//# sourceMappingURL=edi-mngt-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/edi-level.d.ts
declare module '@sage/wh-product-data/lib/enums/edi-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EdiLevelEnum {
	    parcel = 1,
	    dn = 2,
	    cr = 3,
	    su = 4
	}
	export interface EdiLevel$EnumInterface {
	    parcel: 1;
	    dn: 2;
	    cr: 3;
	    su: 4;
	}
	export type EdiLevel = keyof EdiLevel$EnumInterface;
	export const ediLevelDatatype: X3EnumDataType<keyof EdiLevel$EnumInterface, unknown>;
	//# sourceMappingURL=edi-level.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/do-line-type.d.ts
declare module '@sage/wh-product-data/lib/enums/do-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DoLineTypeEnum {
	    item = 1,
	    kit = 2,
	    component = 3,
	    commentary = 4
	}
	export interface DoLineType$EnumInterface {
	    item: 1;
	    kit: 2;
	    component: 3;
	    commentary: 4;
	}
	export type DoLineType = keyof DoLineType$EnumInterface;
	export const doLineTypeDatatype: X3EnumDataType<keyof DoLineType$EnumInterface, unknown>;
	//# sourceMappingURL=do-line-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/dispatchable-in-state.d.ts
declare module '@sage/wh-product-data/lib/enums/dispatchable-in-state' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DispatchableInStateEnum {
	    no = 1,
	    yes = 2,
	    yesIfStandard = 3
	}
	export interface DispatchableInState$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesIfStandard: 3;
	}
	export type DispatchableInState = keyof DispatchableInState$EnumInterface;
	export const dispatchableInStateDatatype: X3EnumDataType<keyof DispatchableInState$EnumInterface, unknown>;
	//# sourceMappingURL=dispatchable-in-state.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/delivery-order-line-status.d.ts
declare module '@sage/wh-product-data/lib/enums/delivery-order-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryOrderLineStatusEnum {
	    waitFirstPick = 1,
	    waitNthPick = 2,
	    selectedForPreparation = 3,
	    preparationInProcess = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    waitToShip = 8,
	    shippedClosed = 9
	}
	export interface DeliveryOrderLineStatus$EnumInterface {
	    waitFirstPick: 1;
	    waitNthPick: 2;
	    selectedForPreparation: 3;
	    preparationInProcess: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    waitToShip: 8;
	    shippedClosed: 9;
	}
	export type DeliveryOrderLineStatus = keyof DeliveryOrderLineStatus$EnumInterface;
	export const deliveryOrderLineStatusDatatype: X3EnumDataType<keyof DeliveryOrderLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-order-line-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/date-contract-unit.d.ts
declare module '@sage/wh-product-data/lib/enums/date-contract-unit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DateContractUnitEnum {
	    day = 1,
	    month = 2
	}
	export interface DateContractUnit$EnumInterface {
	    day: 1;
	    month: 2;
	}
	export type DateContractUnit = keyof DateContractUnit$EnumInterface;
	export const dateContractUnitDatatype: X3EnumDataType<keyof DateContractUnit$EnumInterface, unknown>;
	//# sourceMappingURL=date-contract-unit.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/data-file-type-461.d.ts
declare module '@sage/wh-product-data/lib/enums/data-file-type-461' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DataFileType461Enum {
	    delineated = 1,
	    fixedLength = 2,
	    xml = 3
	}
	export interface DataFileType461$EnumInterface {
	    delineated: 1;
	    fixedLength: 2;
	    xml: 3;
	}
	export type DataFileType461 = keyof DataFileType461$EnumInterface;
	export const dataFileType461Datatype: X3EnumDataType<keyof DataFileType461$EnumInterface, unknown>;
	//# sourceMappingURL=data-file-type-461.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/custk.d.ts
declare module '@sage/wh-product-data/lib/enums/custk' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustkEnum {
	    cu = 1,
	    stk = 2
	}
	export interface Custk$EnumInterface {
	    cu: 1;
	    stk: 2;
	}
	export type Custk = keyof Custk$EnumInterface;
	export const custkDatatype: X3EnumDataType<keyof Custk$EnumInterface, unknown>;
	//# sourceMappingURL=custk.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/crystal-report.d.ts
declare module '@sage/wh-product-data/lib/enums/crystal-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportEnum {
	    provisional = 1,
	    final = 2,
	    reprint = 3,
	    all4 = 4,
	    page = 5,
	    multiZonesDn = 6,
	    facility = 7,
	    selection = 8,
	    depositor9 = 9,
	    printingType = 10,
	    wave = 11,
	    round = 12,
	    dONumber = 13,
	    dlNumber = 14,
	    preparationZone = 15,
	    sender = 16,
	    deliveryAddress = 17,
	    loadRecapitulation = 18,
	    deliveryNote = 19,
	    ourReferences = 20,
	    from21 = 21,
	    customerCode = 22,
	    doReferences = 23,
	    yourReferences = 24,
	    order = 25,
	    n = 26,
	    invoiceAddress = 27,
	    carriage = 28,
	    mode = 29,
	    postageType = 30,
	    line = 31,
	    itemCode = 32,
	    description = 33,
	    ucQuantity = 34,
	    weight = 35,
	    volume = 36,
	    suN37 = 37,
	    parcelN38 = 38,
	    packingList = 39,
	    suN = 40,
	    parcelN = 41,
	    dimension = 42,
	    hWD = 43,
	    yes = 44,
	    no = 45,
	    all = 46,
	    picking = 47,
	    reserve = 48,
	    mixed = 49,
	    level = 50,
	    carrier = 51,
	    multiZonesPo = 52,
	    byDo = 53,
	    byItem = 54,
	    byLocation55 = 55,
	    input = 56,
	    output = 57,
	    transfer = 58,
	    adjustment = 59,
	    consignee = 60,
	    from = 61,
	    cu = 62,
	    transferReplenishment = 63,
	    difference = 64,
	    stock = 65,
	    merging = 66,
	    stockObject = 67,
	    conform = 68,
	    anomaly = 69,
	    pendingDn = 70,
	    finishedDn = 71,
	    numberOfConformedFinishedDnXTheoreticalShipdate = 72,
	    requestN = 73,
	    di = 74,
	    receipt = 75,
	    ei = 76,
	    direct = 77,
	    byConsumable = 78,
	    byDate = 79,
	    byQuantity = 80,
	    byProduct = 81,
	    byPrompting = 82,
	    byLocation = 83,
	    byStore = 84,
	    roundSite = 85,
	    aoNumber = 86,
	    byAo = 87,
	    store = 88,
	    assembly = 89,
	    range = 90,
	    type = 91,
	    shipAsIs = 92,
	    suType = 93,
	    doNo = 94,
	    doRef = 95,
	    pickingMode = 96,
	    intersiteDeliveryNote = 97,
	    cuStkQuantity = 98,
	    serviceProvision = 99,
	    address = 100,
	    product = 101,
	    cuStkTotal = 102,
	    cuStkNo = 103,
	    unitPrice = 104,
	    valuation = 105,
	    storeAddress = 106,
	    serialNumbers = 107,
	    depositor = 108,
	    status = 109,
	    srn1 = 110,
	    srn2 = 111
	}
	export interface CrystalReport$EnumInterface {
	    provisional: 1;
	    final: 2;
	    reprint: 3;
	    all4: 4;
	    page: 5;
	    multiZonesDn: 6;
	    facility: 7;
	    selection: 8;
	    depositor9: 9;
	    printingType: 10;
	    wave: 11;
	    round: 12;
	    dONumber: 13;
	    dlNumber: 14;
	    preparationZone: 15;
	    sender: 16;
	    deliveryAddress: 17;
	    loadRecapitulation: 18;
	    deliveryNote: 19;
	    ourReferences: 20;
	    from21: 21;
	    customerCode: 22;
	    doReferences: 23;
	    yourReferences: 24;
	    order: 25;
	    n: 26;
	    invoiceAddress: 27;
	    carriage: 28;
	    mode: 29;
	    postageType: 30;
	    line: 31;
	    itemCode: 32;
	    description: 33;
	    ucQuantity: 34;
	    weight: 35;
	    volume: 36;
	    suN37: 37;
	    parcelN38: 38;
	    packingList: 39;
	    suN: 40;
	    parcelN: 41;
	    dimension: 42;
	    hWD: 43;
	    yes: 44;
	    no: 45;
	    all: 46;
	    picking: 47;
	    reserve: 48;
	    mixed: 49;
	    level: 50;
	    carrier: 51;
	    multiZonesPo: 52;
	    byDo: 53;
	    byItem: 54;
	    byLocation55: 55;
	    input: 56;
	    output: 57;
	    transfer: 58;
	    adjustment: 59;
	    consignee: 60;
	    from: 61;
	    cu: 62;
	    transferReplenishment: 63;
	    difference: 64;
	    stock: 65;
	    merging: 66;
	    stockObject: 67;
	    conform: 68;
	    anomaly: 69;
	    pendingDn: 70;
	    finishedDn: 71;
	    numberOfConformedFinishedDnXTheoreticalShipdate: 72;
	    requestN: 73;
	    di: 74;
	    receipt: 75;
	    ei: 76;
	    direct: 77;
	    byConsumable: 78;
	    byDate: 79;
	    byQuantity: 80;
	    byProduct: 81;
	    byPrompting: 82;
	    byLocation: 83;
	    byStore: 84;
	    roundSite: 85;
	    aoNumber: 86;
	    byAo: 87;
	    store: 88;
	    assembly: 89;
	    range: 90;
	    type: 91;
	    shipAsIs: 92;
	    suType: 93;
	    doNo: 94;
	    doRef: 95;
	    pickingMode: 96;
	    intersiteDeliveryNote: 97;
	    cuStkQuantity: 98;
	    serviceProvision: 99;
	    address: 100;
	    product: 101;
	    cuStkTotal: 102;
	    cuStkNo: 103;
	    unitPrice: 104;
	    valuation: 105;
	    storeAddress: 106;
	    serialNumbers: 107;
	    depositor: 108;
	    status: 109;
	    srn1: 110;
	    srn2: 111;
	}
	export type CrystalReport = keyof CrystalReport$EnumInterface;
	export const crystalReportDatatype: X3EnumDataType<keyof CrystalReport$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-report.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/crystal-report-dgg.d.ts
declare module '@sage/wh-product-data/lib/enums/crystal-report-dgg' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportDggEnum {
	    selections = 1,
	    site = 2,
	    depositor = 3,
	    shippedBy = 4,
	    icpeClass = 5,
	    activeMaterial6 = 6,
	    product7 = 7,
	    qtyInStock = 8,
	    qty = 9,
	    ubdUnit = 10,
	    weight = 11,
	    activeMaterialWeight = 12,
	    activeMaterialTotal = 13,
	    classTotal = 14,
	    detailedStockByIcpeClass = 15,
	    total16 = 16,
	    cumulatedStockByIcpeClass = 17,
	    flammableProductStock = 18,
	    flashPoint19 = 19,
	    liquidProducts = 20,
	    solideProducts = 21,
	    flashPoint = 22,
	    class = 23,
	    total = 24,
	    totalAllFlammableProducts = 25,
	    stockOfFlammableProductsInCorrectedTonnage = 26,
	    transportedProducts = 27,
	    transportClass = 28,
	    notClassified = 29,
	    generalTotal = 30,
	    dateRange = 31,
	    limitControlOfDangerousGoodsStorage = 32,
	    maxi = 33,
	    maxiQuantityAuthorized = 34,
	    expectedQty = 35,
	    roundNo = 36,
	    cnNo = 37,
	    dangerousSubstanceTransportDocument = 38,
	    simplifiedJointStockCompanyWithACapitalOf = 39,
	    vehicleRegistrationNumber = 40,
	    classification = 41,
	    packing = 42,
	    deposit = 43,
	    label = 44,
	    coefficient = 45,
	    onuCodeDescription = 46,
	    productDescription = 47,
	    cU = 48,
	    summary = 49,
	    actualWeight = 50,
	    weightedWeight = 51,
	    threshold = 52,
	    transportNotExceedingTheFreeLimitsRecommendedIn1136 = 53,
	    affixingOfOrangePannels = 54,
	    mandatoryLoadSignature = 55,
	    mandatoryDriverSignature = 56,
	    the = 57,
	    dnTransportDocumentNo = 58,
	    crNo = 59,
	    stockOnDockByIcpeClass = 60,
	    activeMaterial61 = 61,
	    weightOf = 62,
	    un = 63,
	    pg = 64,
	    transportCategoryDescription = 65,
	    categoryTotal = 66,
	    hazardMatQty = 67,
	    unit = 68,
	    transportExceedingThePrescriptionsOfChapter1136 = 69,
	    transportNotExceedingThePrescriptionsOfChapter1136 = 70,
	    actualMaterialQty = 71,
	    weighedMaterialQty = 72,
	    saleUnitQty = 73,
	    activeMaterialQty = 74,
	    category = 75,
	    youHaveBeenInformedThatTheStorageLimitOfHazardousMaterialsHasBeenExceeded = 76,
	    storageLimitExceededOnSite = 77,
	    activeMaterial = 78,
	    product = 79,
	    cuStk = 80
	}
	export interface CrystalReportDgg$EnumInterface {
	    selections: 1;
	    site: 2;
	    depositor: 3;
	    shippedBy: 4;
	    icpeClass: 5;
	    activeMaterial6: 6;
	    product7: 7;
	    qtyInStock: 8;
	    qty: 9;
	    ubdUnit: 10;
	    weight: 11;
	    activeMaterialWeight: 12;
	    activeMaterialTotal: 13;
	    classTotal: 14;
	    detailedStockByIcpeClass: 15;
	    total16: 16;
	    cumulatedStockByIcpeClass: 17;
	    flammableProductStock: 18;
	    flashPoint19: 19;
	    liquidProducts: 20;
	    solideProducts: 21;
	    flashPoint: 22;
	    class: 23;
	    total: 24;
	    totalAllFlammableProducts: 25;
	    stockOfFlammableProductsInCorrectedTonnage: 26;
	    transportedProducts: 27;
	    transportClass: 28;
	    notClassified: 29;
	    generalTotal: 30;
	    dateRange: 31;
	    limitControlOfDangerousGoodsStorage: 32;
	    maxi: 33;
	    maxiQuantityAuthorized: 34;
	    expectedQty: 35;
	    roundNo: 36;
	    cnNo: 37;
	    dangerousSubstanceTransportDocument: 38;
	    simplifiedJointStockCompanyWithACapitalOf: 39;
	    vehicleRegistrationNumber: 40;
	    classification: 41;
	    packing: 42;
	    deposit: 43;
	    label: 44;
	    coefficient: 45;
	    onuCodeDescription: 46;
	    productDescription: 47;
	    cU: 48;
	    summary: 49;
	    actualWeight: 50;
	    weightedWeight: 51;
	    threshold: 52;
	    transportNotExceedingTheFreeLimitsRecommendedIn1136: 53;
	    affixingOfOrangePannels: 54;
	    mandatoryLoadSignature: 55;
	    mandatoryDriverSignature: 56;
	    the: 57;
	    dnTransportDocumentNo: 58;
	    crNo: 59;
	    stockOnDockByIcpeClass: 60;
	    activeMaterial61: 61;
	    weightOf: 62;
	    un: 63;
	    pg: 64;
	    transportCategoryDescription: 65;
	    categoryTotal: 66;
	    hazardMatQty: 67;
	    unit: 68;
	    transportExceedingThePrescriptionsOfChapter1136: 69;
	    transportNotExceedingThePrescriptionsOfChapter1136: 70;
	    actualMaterialQty: 71;
	    weighedMaterialQty: 72;
	    saleUnitQty: 73;
	    activeMaterialQty: 74;
	    category: 75;
	    youHaveBeenInformedThatTheStorageLimitOfHazardousMaterialsHasBeenExceeded: 76;
	    storageLimitExceededOnSite: 77;
	    activeMaterial: 78;
	    product: 79;
	    cuStk: 80;
	}
	export type CrystalReportDgg = keyof CrystalReportDgg$EnumInterface;
	export const crystalReportDggDatatype: X3EnumDataType<keyof CrystalReportDgg$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-report-dgg.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/cross-docking.d.ts
declare module '@sage/wh-product-data/lib/enums/cross-docking' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrossDockingEnum {
	    no = 1,
	    yesIfShortage = 2,
	    yesPriority = 3
	}
	export interface CrossDocking$EnumInterface {
	    no: 1;
	    yesIfShortage: 2;
	    yesPriority: 3;
	}
	export type CrossDocking = keyof CrossDocking$EnumInterface;
	export const crossDockingDatatype: X3EnumDataType<keyof CrossDocking$EnumInterface, unknown>;
	//# sourceMappingURL=cross-docking.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/cross-docking-cover.d.ts
declare module '@sage/wh-product-data/lib/enums/cross-docking-cover' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrossDockingCoverEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3
	}
	export interface CrossDockingCover$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	}
	export type CrossDockingCover = keyof CrossDockingCover$EnumInterface;
	export const crossDockingCoverDatatype: X3EnumDataType<keyof CrossDockingCover$EnumInterface, unknown>;
	//# sourceMappingURL=cross-docking-cover.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/counting-type.d.ts
declare module '@sage/wh-product-data/lib/enums/counting-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountingTypeEnum {
	    inventoryLines = 1,
	    countDiscrepancies = 2,
	    gapBetween2Counts = 3
	}
	export interface CountingType$EnumInterface {
	    inventoryLines: 1;
	    countDiscrepancies: 2;
	    gapBetween2Counts: 3;
	}
	export type CountingType = keyof CountingType$EnumInterface;
	export const countingTypeDatatype: X3EnumDataType<keyof CountingType$EnumInterface, unknown>;
	//# sourceMappingURL=counting-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/counting-print.d.ts
declare module '@sage/wh-product-data/lib/enums/counting-print' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountingPrintEnum {
	    no = 1,
	    counting = 2,
	    stockObjects = 3
	}
	export interface CountingPrint$EnumInterface {
	    no: 1;
	    counting: 2;
	    stockObjects: 3;
	}
	export type CountingPrint = keyof CountingPrint$EnumInterface;
	export const countingPrintDatatype: X3EnumDataType<keyof CountingPrint$EnumInterface, unknown>;
	//# sourceMappingURL=counting-print.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/control-type-397.d.ts
declare module '@sage/wh-product-data/lib/enums/control-type-397' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlType397Enum {
	    valueList = 1,
	    ranges = 2,
	    noControl = 3
	}
	export interface ControlType397$EnumInterface {
	    valueList: 1;
	    ranges: 2;
	    noControl: 3;
	}
	export type ControlType397 = keyof ControlType397$EnumInterface;
	export const controlType397Datatype: X3EnumDataType<keyof ControlType397$EnumInterface, unknown>;
	//# sourceMappingURL=control-type-397.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/consumable-sorting.d.ts
declare module '@sage/wh-product-data/lib/enums/consumable-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumableSortingEnum {
	    byConsumable = 1,
	    byQuantity = 2
	}
	export interface ConsumableSorting$EnumInterface {
	    byConsumable: 1;
	    byQuantity: 2;
	}
	export type ConsumableSorting = keyof ConsumableSorting$EnumInterface;
	export const consumableSortingDatatype: X3EnumDataType<keyof ConsumableSorting$EnumInterface, unknown>;
	//# sourceMappingURL=consumable-sorting.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/consumable-mvt-type-429.d.ts
declare module '@sage/wh-product-data/lib/enums/consumable-mvt-type-429' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumableMvtType429Enum {
	    input = 1,
	    output = 2,
	    all = 3
	}
	export interface ConsumableMvtType429$EnumInterface {
	    input: 1;
	    output: 2;
	    all: 3;
	}
	export type ConsumableMvtType429 = keyof ConsumableMvtType429$EnumInterface;
	export const consumableMvtType429Datatype: X3EnumDataType<keyof ConsumableMvtType429$EnumInterface, unknown>;
	//# sourceMappingURL=consumable-mvt-type-429.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/consumable-mvt-sorting.d.ts
declare module '@sage/wh-product-data/lib/enums/consumable-mvt-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumableMvtSortingEnum {
	    byConsumable = 1,
	    byDate = 2
	}
	export interface ConsumableMvtSorting$EnumInterface {
	    byConsumable: 1;
	    byDate: 2;
	}
	export type ConsumableMvtSorting = keyof ConsumableMvtSorting$EnumInterface;
	export const consumableMvtSortingDatatype: X3EnumDataType<keyof ConsumableMvtSorting$EnumInterface, unknown>;
	//# sourceMappingURL=consumable-mvt-sorting.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/consumable-mvt-origin.d.ts
declare module '@sage/wh-product-data/lib/enums/consumable-mvt-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumableMvtOriginEnum {
	    direct = 1,
	    ei = 2,
	    receipt = 3,
	    di = 4,
	    do = 5,
	    round = 6,
	    all = 7
	}
	export interface ConsumableMvtOrigin$EnumInterface {
	    direct: 1;
	    ei: 2;
	    receipt: 3;
	    di: 4;
	    do: 5;
	    round: 6;
	    all: 7;
	}
	export type ConsumableMvtOrigin = keyof ConsumableMvtOrigin$EnumInterface;
	export const consumableMvtOriginDatatype: X3EnumDataType<keyof ConsumableMvtOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=consumable-mvt-origin.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/colis.d.ts
declare module '@sage/wh-product-data/lib/enums/colis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ColisEnum {
	    onDock = 1,
	    pendingTransfer = 2,
	    exDock = 3
	}
	export interface Colis$EnumInterface {
	    onDock: 1;
	    pendingTransfer: 2;
	    exDock: 3;
	}
	export type Colis = keyof Colis$EnumInterface;
	export const colisDatatype: X3EnumDataType<keyof Colis$EnumInterface, unknown>;
	//# sourceMappingURL=colis.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/code-128-police.d.ts
declare module '@sage/wh-product-data/lib/enums/code-128-police' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Code128PoliceEnum {
	    normal = 1,
	    large = 2,
	    narrow = 3
	}
	export interface Code128Police$EnumInterface {
	    normal: 1;
	    large: 2;
	    narrow: 3;
	}
	export type Code128Police = keyof Code128Police$EnumInterface;
	export const code128PoliceDatatype: X3EnumDataType<keyof Code128Police$EnumInterface, unknown>;
	//# sourceMappingURL=code-128-police.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/class.d.ts
declare module '@sage/wh-product-data/lib/enums/class' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClassEnum {
	    depositorItem = 1,
	    store = 2,
	    rotationClass = 3,
	    assignmentClass = 4,
	    container = 5
	}
	export interface Class$EnumInterface {
	    depositorItem: 1;
	    store: 2;
	    rotationClass: 3;
	    assignmentClass: 4;
	    container: 5;
	}
	export type Class = keyof Class$EnumInterface;
	export const classDatatype: X3EnumDataType<keyof Class$EnumInterface, unknown>;
	//# sourceMappingURL=class.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/circulation-type.d.ts
declare module '@sage/wh-product-data/lib/enums/circulation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CirculationTypeEnum {
	    rowLevel = 1,
	    levelRow = 2
	}
	export interface CirculationType$EnumInterface {
	    rowLevel: 1;
	    levelRow: 2;
	}
	export type CirculationType = keyof CirculationType$EnumInterface;
	export const circulationTypeDatatype: X3EnumDataType<keyof CirculationType$EnumInterface, unknown>;
	//# sourceMappingURL=circulation-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/circulation-direction.d.ts
declare module '@sage/wh-product-data/lib/enums/circulation-direction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CirculationDirectionEnum {
	    alternate = 1,
	    ascending = 2,
	    descending = 3
	}
	export interface CirculationDirection$EnumInterface {
	    alternate: 1;
	    ascending: 2;
	    descending: 3;
	}
	export type CirculationDirection = keyof CirculationDirection$EnumInterface;
	export const circulationDirectionDatatype: X3EnumDataType<keyof CirculationDirection$EnumInterface, unknown>;
	//# sourceMappingURL=circulation-direction.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/cancelation-of-ei-shortage.d.ts
declare module '@sage/wh-product-data/lib/enums/cancelation-of-ei-shortage' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CancelationOfEiShortageEnum {
	    no = 1,
	    closeTheLine = 2,
	    closeTheInput = 3
	}
	export interface CancelationOfEiShortage$EnumInterface {
	    no: 1;
	    closeTheLine: 2;
	    closeTheInput: 3;
	}
	export type CancelationOfEiShortage = keyof CancelationOfEiShortage$EnumInterface;
	export const cancelationOfEiShortageDatatype: X3EnumDataType<keyof CancelationOfEiShortage$EnumInterface, unknown>;
	//# sourceMappingURL=cancelation-of-ei-shortage.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/blocking-type.d.ts
declare module '@sage/wh-product-data/lib/enums/blocking-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BlockingTypeEnum {
	    noBlock = 1,
	    operationBlocking = 2,
	    statusBlock = 3,
	    newForm = 4
	}
	export interface BlockingType$EnumInterface {
	    noBlock: 1;
	    operationBlocking: 2;
	    statusBlock: 3;
	    newForm: 4;
	}
	export type BlockingType = keyof BlockingType$EnumInterface;
	export const blockingTypeDatatype: X3EnumDataType<keyof BlockingType$EnumInterface, unknown>;
	//# sourceMappingURL=blocking-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/blocking-reason.d.ts
declare module '@sage/wh-product-data/lib/enums/blocking-reason' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BlockingReasonEnum {
	    inventoryPending = 1,
	    blockedInOutput = 2,
	    forbiddenInOutput = 3,
	    reserved = 4,
	    stockNature = 5,
	    datesExpired = 6
	}
	export interface BlockingReason$EnumInterface {
	    inventoryPending: 1;
	    blockedInOutput: 2;
	    forbiddenInOutput: 3;
	    reserved: 4;
	    stockNature: 5;
	    datesExpired: 6;
	}
	export type BlockingReason = keyof BlockingReason$EnumInterface;
	export const blockingReasonDatatype: X3EnumDataType<keyof BlockingReason$EnumInterface, unknown>;
	//# sourceMappingURL=blocking-reason.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/auto-palletization-status.d.ts
declare module '@sage/wh-product-data/lib/enums/auto-palletization-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutoPalletizationStatusEnum {
	    notValidated = 1,
	    notUsed2 = 2,
	    partlyValidated = 3,
	    validated = 4,
	    cancelled = 5
	}
	export interface AutoPalletizationStatus$EnumInterface {
	    notValidated: 1;
	    notUsed2: 2;
	    partlyValidated: 3;
	    validated: 4;
	    cancelled: 5;
	}
	export type AutoPalletizationStatus = keyof AutoPalletizationStatus$EnumInterface;
	export const autoPalletizationStatusDatatype: X3EnumDataType<keyof AutoPalletizationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=auto-palletization-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/assembly-order-status.d.ts
declare module '@sage/wh-product-data/lib/enums/assembly-order-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssemblyOrderStatusEnum {
	    pendingPreparation = 1,
	    notUsed2 = 2,
	    selectedForPreparation = 3,
	    preparationUnderProgress = 4,
	    notUsed5 = 5,
	    notUsed6 = 6,
	    notUsed7 = 7,
	    notUsed8 = 8,
	    processed = 9
	}
	export interface AssemblyOrderStatus$EnumInterface {
	    pendingPreparation: 1;
	    notUsed2: 2;
	    selectedForPreparation: 3;
	    preparationUnderProgress: 4;
	    notUsed5: 5;
	    notUsed6: 6;
	    notUsed7: 7;
	    notUsed8: 8;
	    processed: 9;
	}
	export type AssemblyOrderStatus = keyof AssemblyOrderStatus$EnumInterface;
	export const assemblyOrderStatusDatatype: X3EnumDataType<keyof AssemblyOrderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=assembly-order-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/assembly-movement-status.d.ts
declare module '@sage/wh-product-data/lib/enums/assembly-movement-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssemblyMovementStatusEnum {
	    notAddressed = 1,
	    notUsed2 = 2,
	    addressed = 3,
	    notUsed4 = 4,
	    nonCompliant = 5,
	    compliant = 6,
	    notUsed7 = 7,
	    notUsed8 = 8,
	    validated = 9
	}
	export interface AssemblyMovementStatus$EnumInterface {
	    notAddressed: 1;
	    notUsed2: 2;
	    addressed: 3;
	    notUsed4: 4;
	    nonCompliant: 5;
	    compliant: 6;
	    notUsed7: 7;
	    notUsed8: 8;
	    validated: 9;
	}
	export type AssemblyMovementStatus = keyof AssemblyMovementStatus$EnumInterface;
	export const assemblyMovementStatusDatatype: X3EnumDataType<keyof AssemblyMovementStatus$EnumInterface, unknown>;
	//# sourceMappingURL=assembly-movement-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/appointment-weight.d.ts
declare module '@sage/wh-product-data/lib/enums/appointment-weight' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AppointmentWeightEnum {
	    eiWeight = 1,
	    roundWeight = 2
	}
	export interface AppointmentWeight$EnumInterface {
	    eiWeight: 1;
	    roundWeight: 2;
	}
	export type AppointmentWeight = keyof AppointmentWeight$EnumInterface;
	export const appointmentWeightDatatype: X3EnumDataType<keyof AppointmentWeight$EnumInterface, unknown>;
	//# sourceMappingURL=appointment-weight.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/allocation-method.d.ts
declare module '@sage/wh-product-data/lib/enums/allocation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationMethodEnum {
	    toBeProcessed = 1,
	    processed = 2,
	    intergrationError = 3,
	    errorProcessed = 4,
	    importError = 5,
	    exportError = 6,
	    blocked = 7
	}
	export interface AllocationMethod$EnumInterface {
	    toBeProcessed: 1;
	    processed: 2;
	    intergrationError: 3;
	    errorProcessed: 4;
	    importError: 5;
	    exportError: 6;
	    blocked: 7;
	}
	export type AllocationMethod = keyof AllocationMethod$EnumInterface;
	export const allocationMethodDatatype: X3EnumDataType<keyof AllocationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-method.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/address-structure.d.ts
declare module '@sage/wh-product-data/lib/enums/address-structure' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AddressStructureEnum {
	    aisle = 1,
	    row = 2,
	    level = 3,
	    other4 = 4,
	    other = 5
	}
	export interface AddressStructure$EnumInterface {
	    aisle: 1;
	    row: 2;
	    level: 3;
	    other4: 4;
	    other: 5;
	}
	export type AddressStructure = keyof AddressStructure$EnumInterface;
	export const addressStructureDatatype: X3EnumDataType<keyof AddressStructure$EnumInterface, unknown>;
	//# sourceMappingURL=address-structure.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/ad-status.d.ts
declare module '@sage/wh-product-data/lib/enums/ad-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AdStatusEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    substituteValue9 = 9
	}
	export interface AdStatus$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    substituteValue9: 9;
	}
	export type AdStatus = keyof AdStatus$EnumInterface;
	export const adStatusDatatype: X3EnumDataType<keyof AdStatus$EnumInterface, unknown>;
	//# sourceMappingURL=ad-status.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/action.d.ts
declare module '@sage/wh-product-data/lib/enums/action' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionEnum {
	    cre = 1,
	    dup = 2,
	    upd = 3,
	    del = 4
	}
	export interface Action$EnumInterface {
	    cre: 1;
	    dup: 2;
	    upd: 3;
	    del: 4;
	}
	export type Action = keyof Action$EnumInterface;
	export const actionDatatype: X3EnumDataType<keyof Action$EnumInterface, unknown>;
	//# sourceMappingURL=action.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/action-type.d.ts
declare module '@sage/wh-product-data/lib/enums/action-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActionTypeEnum {
	    pick = 1,
	    pack = 2,
	    packPalletize = 3,
	    palletize = 4
	}
	export interface ActionType$EnumInterface {
	    pick: 1;
	    pack: 2;
	    packPalletize: 3;
	    palletize: 4;
	}
	export type ActionType = keyof ActionType$EnumInterface;
	export const actionTypeDatatype: X3EnumDataType<keyof ActionType$EnumInterface, unknown>;
	//# sourceMappingURL=action-type.d.ts.map
}
// From file: @sage/wh-product-data/build/lib/enums/action-458.d.ts
declare module '@sage/wh-product-data/lib/enums/action-458' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Action458Enum {
	    deleted = 1,
	    created = 2,
	    none = 3
	}
	export interface Action458$EnumInterface {
	    deleted: 1;
	    created: 2;
	    none: 3;
	}
	export type Action458 = keyof Action458$EnumInterface;
	export const action458Datatype: X3EnumDataType<keyof Action458$EnumInterface, unknown>;
	//# sourceMappingURL=action-458.d.ts.map
}
declare module '@sage/wh-product-data' {
	export * from '@sage/wh-product-data/index';
}
