"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptMode = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        receivingDockStore: {
            site: 'site',
            code: 'receivingDockStore',
        },
        receivingDockAddress: {
            site: 'site',
            store: 'receivingDockStore',
            code: 'receivingDockAddress',
        },
        truckTrackingStatus: {
            site: 'site',
            code: 'truckTrackingStatus',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'RECEIPTMOD';
            },
            columnName() {
                return 'RMDDESAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'RECEIPTMOD';
            },
            columnName() {
                return 'RMDSHOAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
    },
};
let ReceiptMode = class ReceiptMode extends xtrem_core_1.Node {
};
exports.ReceiptMode = ReceiptMode;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'RCPMOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RMDDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RMDSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CDK',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isCrossDocking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTYEXDCTL',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isExceedQuantityControl", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EINSHRCCL',
        dataType: () => sageWhProductData.enums.cancelationOfEiShortageDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "cancelBalanceExpectedInputManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPCTLEDT',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isReceiptControlListPrint", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPADDAUT',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isAutoAddressing", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EILSTA8',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isExpectedInputLinesNotSettled", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "siteDepositorIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QYMOCC',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isDockAssignment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CREAUT',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isAutoCreationAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SUPAUT',
        lookupAccess: true,
    })
], ReceiptMode.prototype, "isAutoDeletionAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMSTO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "receivingDockStore", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QYMADD',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "receivingDockAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REF',
        dataType: () => sageWhProductData.enums.receiptReferenceTypeDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "reference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSSTA',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.TruckTrackingStatus,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "truckTrackingStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEROCC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ReceiptMode.prototype, "occupationDuration", void 0);
exports.ReceiptMode = ReceiptMode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'RECEIPTMOD',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ReceiptMode);
//# sourceMappingURL=receipt-mode.js.map