import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class ReceiptMode extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly isCrossDocking: Promise<boolean>;
    readonly isExceedQuantityControl: Promise<boolean>;
    readonly cancelBalanceExpectedInputManagement: Promise<sageWhProductData.enums.CancelationOfEiShortage | null>;
    readonly isReceiptControlListPrint: Promise<boolean>;
    readonly isAutoAddressing: Promise<boolean>;
    readonly isExpectedInputLinesNotSettled: Promise<boolean>;
    readonly isActive: Promise<boolean>;
    readonly siteDepositorIdentifier: Promise<string>;
    readonly isDockAssignment: Promise<boolean>;
    readonly isAutoCreationAuthorized: Promise<boolean>;
    readonly isAutoDeletionAuthorized: Promise<boolean>;
    readonly receivingDockStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly receivingDockAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly reference: Promise<sageWhProductData.enums.ReceiptReferenceType | null>;
    readonly truckTrackingStatus: Reference<sageWhMasterData.nodes.TruckTrackingStatus | null>;
    readonly occupationDuration: Promise<string>;
}
//# sourceMappingURL=receipt-mode.d.ts.map