"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Product = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        family: {
            site: 'site',
            depositor: 'depositor',
            code: 'family',
        },
        subFamily: {
            site: 'site',
            depositor: 'depositor',
            code: 'subFamily',
        },
        group: {
            site: 'site',
            depositor: 'depositor',
            code: 'group',
        },
        subGroup: {
            site: 'site',
            depositor: 'depositor',
            code: 'subGroup',
        },
        stockCountClass: {
            site: 'site',
            code: 'stockCountClass',
        },
        source: {
            site: 'site',
            depositor: 'depositor',
            code: 'source',
        },
        inputMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'inputMode',
        },
        outputMode: {
            site: 'site',
            depositor: 'depositor',
            code: 'outputMode',
        },
        material: {
            site: 'site',
            depositor: 'depositor',
            code: 'material',
        },
        defaultContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'code',
            container: 'defaultContainer',
        },
        stockStatus: {
            site: 'site',
            code: 'stockStatus',
        },
        referredUnit: {
            code: 'referredUnit',
        },
        icpeClass: {
            site: 'site',
            code: 'icpeClass',
        },
        transportCategory: {
            site: 'site',
            code: 'transportCategory',
        },
        hazardousMaterialClass: {
            site: 'site',
            code: 'hazardousMaterialClass',
        },
        onuCodes: {
            site: 'site',
            code: 'onuCodes',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        pictureRef: {
            code() {
                return 'LOGOITM';
            },
            site: 'site',
            depositor: 'depositor',
            identifier1: 'code',
            identifier2() {
                return null;
            },
            identifier3() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'ITEM';
            },
            columnName() {
                return 'ITMDESAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
        localizedDescription2: {
            tableName() {
                return 'ITEM';
            },
            columnName() {
                return 'ITMDESAXX2';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'ITEM';
            },
            columnName() {
                return 'ITMSHOAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
    },
    collectionJoins: {
        suppliersUpcs: {
            site: 'site',
            depositor: 'depositor',
            product: 'code',
        },
        productContainers: {
            site: 'site',
            depositor: 'depositor',
            product: 'code',
        },
    },
};
const compositeReferences = {
    pictureRef: {
        picture: 'image',
    },
};
let Product = class Product extends xtrem_core_1.Node {
};
exports.Product = Product;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Product.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], Product.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'COD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "otherCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], Product.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDESAXX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], Product.prototype, "localizedDescription2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], Product.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FAM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Family,
        lookupAccess: true,
    })
], Product.prototype, "family", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SFA',
        columnType: 'string',
        node: () => sageWhProductData.nodes.SubFamily,
        lookupAccess: true,
    })
], Product.prototype, "subFamily", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRU',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Group,
        lookupAccess: true,
    })
], Product.prototype, "group", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SGR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.SubGroup,
        lookupAccess: true,
    })
], Product.prototype, "subGroup", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRNMGT',
        lookupAccess: true,
    })
], Product.prototype, "isKeyInSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCCLS',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockCountClass,
        lookupAccess: true,
    })
], Product.prototype, "stockCountClass", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKCNBR',
        lookupAccess: true,
    })
], Product.prototype, "numberStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPLOK',
        lookupAccess: true,
    })
], Product.prototype, "isBlockedInInput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTLOK',
        lookupAccess: true,
    })
], Product.prototype, "isBlockedInOutput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPLOK2',
        lookupAccess: true,
    })
], Product.prototype, "isBlockedInInput2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTLOK2',
        lookupAccess: true,
    })
], Product.prototype, "isBlockedInOutput2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOTMGT',
        lookupAccess: true,
    })
], Product.prototype, "isKeyInLotNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGLOTMGT',
        lookupAccess: true,
    })
], Product.prototype, "isSingleLot", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CDKMGT',
        lookupAccess: true,
    })
], Product.prototype, "isCrossDocking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DGGMGT',
        lookupAccess: true,
    })
], Product.prototype, "isHazardousMaterials", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTLCODDAC',
        lookupAccess: true,
    })
], Product.prototype, "isKeyInControlCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIFDAT',
        dataType: () => sageWhProductData.enums.fifoDateDatatype,
        lookupAccess: true,
    })
], Product.prototype, "fifoDateNature", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORI',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Origin,
        lookupAccess: true,
    })
], Product.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPMOD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.InputMode,
        lookupAccess: true,
    })
], Product.prototype, "inputMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTMOD',
        columnType: 'string',
        node: () => sageWhProductData.nodes.OutputMode,
        lookupAccess: true,
    })
], Product.prototype, "outputMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRFMOD',
        dataType: () => sageWhProductData.enums.movementTypeDatatype,
        lookupAccess: true,
    })
], Product.prototype, "autoTransferMode", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTDTER',
        lookupAccess: true,
    })
], Product.prototype, "detentionLength", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTDUOM',
        dataType: () => sageWhProductData.enums.unitLengthDatatype,
        lookupAccess: true,
    })
], Product.prototype, "detentionUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USDTER',
        lookupAccess: true,
    })
], Product.prototype, "useByDateLength", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USDUOM',
        dataType: () => sageWhProductData.enums.unitLengthDatatype,
        lookupAccess: true,
    })
], Product.prototype, "useByDateUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNDTER',
        lookupAccess: true,
    })
], Product.prototype, "sendByDateLength", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNDUOM',
        dataType: () => sageWhProductData.enums.unitLengthDatatype,
        lookupAccess: true,
    })
], Product.prototype, "sendByDateUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLDTER',
        lookupAccess: true,
    })
], Product.prototype, "sellByDateLength", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLDUOM',
        dataType: () => sageWhProductData.enums.unitLengthDatatype,
        lookupAccess: true,
    })
], Product.prototype, "sellByDateUnit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIFDEV',
        lookupAccess: true,
    })
], Product.prototype, "fifoTolerance", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIFDEVUOM',
        dataType: () => sageWhProductData.enums.unitLengthDatatype,
        lookupAccess: true,
    })
], Product.prototype, "fifoGapUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "netWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "netVolume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALCVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "pureAlcoholVolume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "price", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DGG',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Risk,
        lookupAccess: true,
    })
], Product.prototype, "material", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MINSTK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "minimumStock", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "alertStock", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAXSTK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "maximumStock", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIRINPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Product.prototype, "firstArrival", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASINPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Product.prototype, "lastReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASOUTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Product.prototype, "lastOutput", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASSKCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Product.prototype, "lastStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DFTCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], Product.prototype, "defaultContainer", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DFTCTRLVL',
        dataType: () => sageWhMasterData.enums.containerLevelDatatype,
        lookupAccess: true,
    })
], Product.prototype, "defaultContainerLevel", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRM',
        dataType: () => sageWhProductData.enums.transmissionL3Datatype,
        lookupAccess: true,
    })
], Product.prototype, "transmittedFromL3", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDLIF',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Product.prototype, "endOfLife", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QLYFLG',
        lookupAccess: true,
    })
], Product.prototype, "isQualityControlManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QLYSKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], Product.prototype, "stockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGLOTCTL',
        lookupAccess: true,
    })
], Product.prototype, "isSingleLotControl", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SMPTYP',
        dataType: () => sageWhProductData.enums.samplingTypeDatatype,
        lookupAccess: true,
    })
], Product.prototype, "samplingType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GENLEVINS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "generalLevelOfInspection", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NQA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "aql", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FRZPNT',
        lookupAccess: true,
    })
], Product.prototype, "freezingPoint", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FRZREV',
        dataType: () => sageWhProductData.enums.reversibleFreezingDatatype,
        lookupAccess: true,
    })
], Product.prototype, "freezingReversibility", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AMMNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "ammNo", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Product.prototype, "referredQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFUNT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], Product.prototype, "referredUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIC',
        columnType: 'string',
        node: () => sageWhProductData.nodes.IcpeClasses,
        lookupAccess: true,
    })
], Product.prototype, "icpeClass", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LGTPNT',
        lookupAccess: true,
    })
], Product.prototype, "flashPoint", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DCTNUM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.TransportCategory,
        lookupAccess: true,
    })
], Product.prototype, "transportCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DMCNUM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.HazardousMaterialsClass,
        lookupAccess: true,
    })
], Product.prototype, "hazardousMaterialClass", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DGGREFTUN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "tunnelRestriction", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "classificationCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRP',
        dataType: () => sageWhProductData.enums.packagingGroupDatatype,
        lookupAccess: true,
    })
], Product.prototype, "packagingGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ONU',
        columnType: 'string',
        node: () => sageWhProductData.nodes.OnuCode,
        lookupAccess: true,
    })
], Product.prototype, "onuCodes", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOLCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "solventCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TECFLD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "technicalField", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], Product.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STUMGT',
        lookupAccess: true,
    })
], Product.prototype, "isStockUnitManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], Product.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Product.prototype, "siteDepositorIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'LOGOITM',
                identifier2: null,
                identifier3: null,
            },
            control: {
                code: 'LOGOITM',
                identifier2: null,
                identifier3: null,
            },
        },
        node: () => sageWhMasterData.nodes.CommonImage,
    })
], Product.prototype, "pictureRef", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhProductData.nodes.SupplierUpc,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], Product.prototype, "suppliersUpcs", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhProductData.nodes.ProductContainer,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], Product.prototype, "productContainers", void 0);
__decorate([
    xtrem_core_1.decorators.binaryStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BLOB',
        lookupAccess: true,
    })
], Product.prototype, "picture", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.ProductActiveMatters,
    })
], Product.prototype, "activeMatters", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.ProductIsPrintableDescriptions,
    })
], Product.prototype, "isPrintableDescriptions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.ProductPercentageActiveMatters,
    })
], Product.prototype, "percentageActiveMatters", void 0);
exports.Product = Product = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITEM',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Product);
//# sourceMappingURL=product.js.map