import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection, BinaryStream } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class Product extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly otherCode: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedDescription2: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly family: Reference<sageWhProductData.nodes.Family | null>;
    readonly subFamily: Reference<sageWhProductData.nodes.SubFamily | null>;
    readonly group: Reference<sageWhProductData.nodes.Group | null>;
    readonly subGroup: Reference<sageWhProductData.nodes.SubGroup | null>;
    readonly isKeyInSerialNumber: Promise<boolean>;
    readonly stockCountClass: Reference<sageWhMasterData.nodes.StockCountClass | null>;
    readonly numberStockCount: Promise<integer>;
    readonly isBlockedInInput: Promise<boolean>;
    readonly isBlockedInOutput: Promise<boolean>;
    readonly isBlockedInInput2: Promise<boolean>;
    readonly isBlockedInOutput2: Promise<boolean>;
    readonly isKeyInLotNumber: Promise<boolean>;
    readonly isSingleLot: Promise<boolean>;
    readonly isCrossDocking: Promise<boolean>;
    readonly isHazardousMaterials: Promise<boolean>;
    readonly isKeyInControlCode: Promise<boolean>;
    readonly fifoDateNature: Promise<sageWhProductData.enums.FifoDate | null>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly inputMode: Reference<sageWhProductData.nodes.InputMode>;
    readonly outputMode: Reference<sageWhProductData.nodes.OutputMode>;
    readonly autoTransferMode: Promise<sageWhProductData.enums.MovementType>;
    readonly detentionLength: Promise<integer | null>;
    readonly detentionUnit: Promise<sageWhProductData.enums.UnitLength | null>;
    readonly useByDateLength: Promise<integer | null>;
    readonly useByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
    readonly sendByDateLength: Promise<integer | null>;
    readonly sendByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
    readonly sellByDateLength: Promise<integer | null>;
    readonly sellByDateUnit: Promise<sageWhProductData.enums.UnitLength | null>;
    readonly fifoTolerance: Promise<integer | null>;
    readonly fifoGapUnit: Promise<sageWhProductData.enums.UnitLength | null>;
    readonly netWeight: Promise<decimal | null>;
    readonly netVolume: Promise<decimal | null>;
    readonly pureAlcoholVolume: Promise<decimal | null>;
    readonly price: Promise<decimal | null>;
    readonly material: Reference<sageWhProductData.nodes.Risk | null>;
    readonly minimumStock: Promise<decimal | null>;
    readonly alertStock: Promise<decimal | null>;
    readonly maximumStock: Promise<decimal | null>;
    readonly firstArrival: Promise<date | null>;
    readonly lastReceipt: Promise<date | null>;
    readonly lastOutput: Promise<date | null>;
    readonly lastStockCount: Promise<date | null>;
    readonly defaultContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly defaultContainerLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
    readonly transmittedFromL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
    readonly endOfLife: Promise<date | null>;
    readonly isQualityControlManagement: Promise<boolean>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly isSingleLotControl: Promise<boolean>;
    readonly samplingType: Promise<sageWhProductData.enums.SamplingType | null>;
    readonly generalLevelOfInspection: Promise<string>;
    readonly aql: Promise<decimal | null>;
    readonly freezingPoint: Promise<integer | null>;
    readonly freezingReversibility: Promise<sageWhProductData.enums.ReversibleFreezing | null>;
    readonly ammNo: Promise<string>;
    readonly referredQuantity: Promise<decimal | null>;
    readonly referredUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly icpeClass: Reference<sageWhProductData.nodes.IcpeClasses | null>;
    readonly flashPoint: Promise<integer | null>;
    readonly transportCategory: Reference<sageWhProductData.nodes.TransportCategory | null>;
    readonly hazardousMaterialClass: Reference<sageWhProductData.nodes.HazardousMaterialsClass | null>;
    readonly tunnelRestriction: Promise<string>;
    readonly classificationCode: Promise<string>;
    readonly packagingGroup: Promise<sageWhProductData.enums.PackagingGroup | null>;
    readonly onuCodes: Reference<sageWhProductData.nodes.OnuCode | null>;
    readonly solventCode: Promise<string>;
    readonly technicalField: Promise<string>;
    readonly isActive: Promise<boolean>;
    readonly isStockUnitManagement: Promise<boolean>;
    readonly stockUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
    readonly siteDepositorIdentifier: Promise<string>;
    readonly pictureRef: Reference<sageWhMasterData.nodes.CommonImage | null>;
    readonly suppliersUpcs: Collection<sageWhProductData.nodes.SupplierUpc>;
    readonly productContainers: Collection<sageWhProductData.nodes.ProductContainer>;
    readonly picture: Promise<BinaryStream>;
    readonly activeMatters: Collection<sageWhProductData.nodes.ProductActiveMatters>;
    readonly isPrintableDescriptions: Collection<sageWhProductData.nodes.ProductIsPrintableDescriptions>;
    readonly percentageActiveMatters: Collection<sageWhProductData.nodes.ProductPercentageActiveMatters>;
}
//# sourceMappingURL=product.d.ts.map