import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class ProductContainer extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly container: Reference<sageWhProductData.nodes.Container>;
    readonly upcCode: Promise<string>;
    readonly containerLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly inferiorContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly numberInferiorContainer: Promise<decimal | null>;
    readonly numberOfConsumptionUnit: Promise<decimal>;
    readonly minimumReserveOutput: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly grossWeight: Promise<decimal>;
    readonly width: Promise<decimal>;
    readonly depth: Promise<decimal>;
    readonly height: Promise<decimal>;
    readonly volume: Promise<decimal | null>;
    readonly linearMeters: Promise<decimal | null>;
    readonly isNesting: Promise<boolean>;
    readonly maximumNesting: Promise<integer | null>;
    readonly umpteenthProductWidthNesting: Promise<decimal | null>;
    readonly umpteenthProductDepthNesting: Promise<decimal | null>;
    readonly umpteenthProductHeightNesting: Promise<decimal | null>;
    readonly umpteenthProductVolumeNesting: Promise<decimal | null>;
    readonly isInputAllowed: Promise<boolean>;
    readonly sequenceCode: Reference<sageWhMasterData.nodes.StoreChaining>;
    readonly percentageOfRupture: Promise<integer | null>;
    readonly maximumNumberOfContainers: Promise<decimal | null>;
    readonly stackingCoefficient: Promise<integer | null>;
    readonly stackingCorrective: Promise<integer | null>;
    readonly isKeyInSupportNumbers: Promise<boolean>;
    readonly rotationClass: Reference<sageWhMasterData.nodes.RotationClass | null>;
    readonly assignmentClass: Reference<sageWhMasterData.nodes.AssignmentClass | null>;
    readonly homogeneousLevel: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly isOutputAllowed: Promise<boolean>;
    readonly dispatchableInState: Promise<sageWhProductData.enums.DispatchableInState | null>;
    readonly isPackingPattern: Promise<boolean>;
    readonly containerTare: Promise<decimal | null>;
    readonly parcelRangeShippedAsIsStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly parcelTypeShippedAsIsStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
    readonly parcelRangeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.RangeOfParcel | null>;
    readonly parcelTypeShippedAsIsNonStandard: Reference<sageWhMasterData.nodes.ParcelType | null>;
    readonly isActive: Promise<boolean>;
    readonly numberOfStockUnit: Promise<decimal | null>;
    readonly density: Promise<decimal | null>;
    readonly unitWeight: Promise<decimal | null>;
    readonly unitVolume: Promise<decimal | null>;
    readonly containersInferior: Collection<sageWhProductData.nodes.ProductContainerContainersInferior>;
    readonly numberOfConsumptionUnitPerLevels: Collection<sageWhProductData.nodes.ProductContainerNumberOfConsumptionUnitPerLevels>;
    readonly numberOfStockUnitPerLevels: Collection<sageWhProductData.nodes.ProductContainerNumberOfStockUnitPerLevels>;
    readonly prohibitedClasses: Collection<sageWhProductData.nodes.ProductContainerProhibitedClasses>;
}
//# sourceMappingURL=product-container.d.ts.map