"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductActiveMatters = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'DG0'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            site: 'site',
            depositor: 'depositor',
            code: 'code',
        },
        activeMatter: {
            site: 'site',
            code: 'activeMatter',
        },
    },
};
let ProductActiveMatters = class ProductActiveMatters extends xtrem_core_1.Node {
};
exports.ProductActiveMatters = ProductActiveMatters;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        lookupAccess: true,
    })
], ProductActiveMatters.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'FCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ProductActiveMatters.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ProductActiveMatters.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], ProductActiveMatters.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
    })
], ProductActiveMatters.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAG',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ActiveMatter,
        lookupAccess: true,
    })
], ProductActiveMatters.prototype, "activeMatter", void 0);
exports.ProductActiveMatters = ProductActiveMatters = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITEM',
        keyPropertyNames: ['denormalizedIndex', 'site', 'depositor', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ProductActiveMatters);
//# sourceMappingURL=product-active-matters.js.map