"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PickingMode = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        preparationAreaForParcel: {
            site: 'site',
            code: 'preparationAreaForParcel',
        },
        preparationAreaForKit: {
            site: 'site',
            code: 'preparationAreaForKit',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PICKINGMOD';
            },
            columnName() {
                return 'PMDDESAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'PICKINGMOD';
            },
            columnName() {
                return 'PMDSHOAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
    },
};
let PickingMode = class PickingMode extends xtrem_core_1.Node {
};
exports.PickingMode = PickingMode;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], PickingMode.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], PickingMode.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PMD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PMDDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PMDSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSAXCL',
        lookupAccess: true,
    })
], PickingMode.prototype, "isExclusiveReservation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WAVFLC',
        lookupAccess: true,
    })
], PickingMode.prototype, "isMergingOfFlows", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDKAUZ',
        dataType: () => sageWhProductData.enums.crossDockingDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "crossDockingRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIFDATXCL',
        lookupAccess: true,
    })
], PickingMode.prototype, "isExclusiveFifoDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGLOTMGT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isSingleLotInOutput", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MPO',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderMixed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGDLOPIC',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderSingleDeliveryOrderPerPicking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGDLORSV',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderSingleDeliveryOrderPerReserve", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGPKZ',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderSinglePickArea", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKZ',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], PickingMode.prototype, "preparationAreaForParcel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKZKIT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.PreparationArea,
        lookupAccess: true,
    })
], PickingMode.prototype, "preparationAreaForKit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGOUTLVL',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderSingleOutputLevel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGDRN',
        lookupAccess: true,
    })
], PickingMode.prototype, "isSingleShippingRoundPerPreparationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGCLT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isSingleShipToCustomerPerPreparationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIKWKLPIC',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPickingPreparationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIKWKLRSV',
        lookupAccess: true,
    })
], PickingMode.prototype, "isReservePreparationOrder", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKG',
        dataType: () => sageWhProductData.enums.packingDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "packingManagement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKOEDT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPreparationOrderPrint", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKOEDTORD',
        dataType: () => sageWhProductData.enums.poPrintSequenceDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "preparationOrderPrintSequence", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PKOEDTGRU',
        lookupAccess: true,
    })
], PickingMode.prototype, "isGroupedMovements", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LBLEDT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isParcelLabelPrint", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHPEDT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isShippingUnitLabelPrint", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MLTPIC',
        lookupAccess: true,
    })
], PickingMode.prototype, "isMultiplePicking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BEFPLZ',
        lookupAccess: true,
    })
], PickingMode.prototype, "isPrepalletization", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DECPKO',
        dataType: () => sageWhProductData.enums.loadSplitDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "loadSplit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CONDAT',
        lookupAccess: true,
    })
], PickingMode.prototype, "isContractDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OUMGRUPMD',
        dataType: () => sageWhProductData.enums.vtGroupingCriteriaDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "handledGroupingRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], PickingMode.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], PickingMode.prototype, "siteDepositorIdentifier", void 0);
exports.PickingMode = PickingMode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PICKINGMOD',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PickingMode);
//# sourceMappingURL=picking-mode.js.map