import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class PickingMode extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly isExclusiveReservation: Promise<boolean>;
    readonly isMergingOfFlows: Promise<boolean>;
    readonly crossDockingRule: Promise<sageWhProductData.enums.CrossDocking | null>;
    readonly isExclusiveFifoDate: Promise<boolean>;
    readonly isSingleLotInOutput: Promise<boolean>;
    readonly isPreparationOrderMixed: Promise<boolean>;
    readonly isPreparationOrderSingleDeliveryOrderPerPicking: Promise<boolean>;
    readonly isPreparationOrderSingleDeliveryOrderPerReserve: Promise<boolean>;
    readonly isPreparationOrderSinglePickArea: Promise<boolean>;
    readonly preparationAreaForParcel: Reference<sageWhMasterData.nodes.PreparationArea>;
    readonly preparationAreaForKit: Reference<sageWhMasterData.nodes.PreparationArea>;
    readonly isPreparationOrderSingleOutputLevel: Promise<boolean>;
    readonly isSingleShippingRoundPerPreparationOrder: Promise<boolean>;
    readonly isSingleShipToCustomerPerPreparationOrder: Promise<boolean>;
    readonly isPickingPreparationOrder: Promise<boolean>;
    readonly isReservePreparationOrder: Promise<boolean>;
    readonly packingManagement: Promise<sageWhProductData.enums.Packing | null>;
    readonly isPreparationOrderPrint: Promise<boolean>;
    readonly preparationOrderPrintSequence: Promise<sageWhProductData.enums.PoPrintSequence | null>;
    readonly isGroupedMovements: Promise<boolean>;
    readonly isParcelLabelPrint: Promise<boolean>;
    readonly isShippingUnitLabelPrint: Promise<boolean>;
    readonly isMultiplePicking: Promise<boolean>;
    readonly isPrepalletization: Promise<boolean>;
    readonly loadSplit: Promise<sageWhProductData.enums.LoadSplit | null>;
    readonly isContractDate: Promise<boolean>;
    readonly handledGroupingRule: Promise<sageWhProductData.enums.VtGroupingCriteria | null>;
    readonly isActive: Promise<boolean>;
    readonly siteDepositorIdentifier: Promise<string>;
}
//# sourceMappingURL=picking-mode.d.ts.map