"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputMode = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'OUTPUTMOD';
            },
            columnName() {
                return 'OMDDESAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'OUTPUTMOD';
            },
            columnName() {
                return 'OMDSHOAXX';
            },
            key1: ['site', 'depositor'],
            key2: ['code'],
        },
    },
};
let OutputMode = class OutputMode extends xtrem_core_1.Node {
};
exports.OutputMode = OutputMode;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], OutputMode.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], OutputMode.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OUTMOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OMDDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OMDSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PICSTKMGT',
        lookupAccess: true,
    })
], OutputMode.prototype, "isPickingStockAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DYNPIC',
        lookupAccess: true,
    })
], OutputMode.prototype, "isPickingPivotAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DYNSNGDLO',
        lookupAccess: true,
    })
], OutputMode.prototype, "isSingleDeliveryOrderReplenishmentForPickingPivotAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DYNSNGWAV',
        lookupAccess: true,
    })
], OutputMode.prototype, "isSingleWaveReplenishmentForPickingPivotAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSVOUTAUZ',
        dataType: () => sageWhProductData.enums.reserveOutputAuthorizedDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "reserveOutputAuthorizedRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSVNEVER',
        lookupAccess: true,
    })
], OutputMode.prototype, "isReserveProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PICCAPPCT',
        lookupAccess: true,
    })
], OutputMode.prototype, "percentagePickingCapacityForReserveOutputAuthorizedRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUTPIC',
        lookupAccess: true,
    })
], OutputMode.prototype, "isAutomaticChoiceOfPicking", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IPAOUTAUZ',
        dataType: () => sageWhProductData.enums.incompleteOutputAuthorizedDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "inCompleteContainerPickingAuthorizedRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IPACREAUZ',
        lookupAccess: true,
    })
], OutputMode.prototype, "isIncompletePalletCreatedAuthorized", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PICRPNSSH',
        lookupAccess: true,
    })
], OutputMode.prototype, "isStockOutReplenishmentAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PICRPNTSD',
        lookupAccess: true,
    })
], OutputMode.prototype, "isPreventiveReplenishmentAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTSRNMGT',
        lookupAccess: true,
    })
], OutputMode.prototype, "isSerialNumberInInputAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INPSRNMGT',
        lookupAccess: true,
    })
], OutputMode.prototype, "isSerialNumberInOutputAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BIGVOLTSD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "bigVolumeLimit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MAPMGT',
        lookupAccess: true,
    })
], OutputMode.prototype, "isDynamicPickingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MLTPIC',
        lookupAccess: true,
    })
], OutputMode.prototype, "isMultiplePickingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGPIC',
        lookupAccess: true,
    })
], OutputMode.prototype, "isDeliveryOrderSinglePickingForMultiplePickingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTRPN',
        lookupAccess: true,
    })
], OutputMode.prototype, "isPriorityOutputToReplenishmentForMultiplePickingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SNGSLO',
        lookupAccess: true,
    })
], OutputMode.prototype, "isSingleAddressReplenishmentForMultiplePickingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], OutputMode.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], OutputMode.prototype, "siteDepositorIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OUTSRNLCZ',
        serviceOptions: () => [sageWhSystem.serviceOptions.SrnActivityCode],
        lookupAccess: true,
    })
], OutputMode.prototype, "isLocalizedSerialNumberAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGMVT',
        lookupAccess: true,
    })
], OutputMode.prototype, "isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.OutputModeOutputsPriority,
    })
], OutputMode.prototype, "outputsPriority", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.OutputModePickingsPriority,
    })
], OutputMode.prototype, "pickingsPriority", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.OutputModeReplenishmentsPriority,
    })
], OutputMode.prototype, "replenishmentsPriority", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhProductData.nodes.OutputModeReplenishmentsPrioritySorting,
    })
], OutputMode.prototype, "replenishmentsPrioritySorting", void 0);
exports.OutputMode = OutputMode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OUTPUTMOD',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OutputMode);
//# sourceMappingURL=output-mode.js.map