import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageWhProductData from '..';
export declare class OutputMode extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly isPickingStockAllowed: Promise<boolean>;
    readonly isPickingPivotAllowed: Promise<boolean>;
    readonly isSingleDeliveryOrderReplenishmentForPickingPivotAllowed: Promise<boolean>;
    readonly isSingleWaveReplenishmentForPickingPivotAllowed: Promise<boolean>;
    readonly reserveOutputAuthorizedRule: Promise<sageWhProductData.enums.ReserveOutputAuthorized | null>;
    readonly isReserveProhibited: Promise<boolean>;
    readonly percentagePickingCapacityForReserveOutputAuthorizedRule: Promise<integer | null>;
    readonly isAutomaticChoiceOfPicking: Promise<boolean>;
    readonly inCompleteContainerPickingAuthorizedRule: Promise<sageWhProductData.enums.IncompleteOutputAuthorized | null>;
    readonly isIncompletePalletCreatedAuthorized: Promise<boolean>;
    readonly isStockOutReplenishmentAllowed: Promise<boolean>;
    readonly isPreventiveReplenishmentAllowed: Promise<boolean>;
    readonly isSerialNumberInInputAllowed: Promise<boolean>;
    readonly isSerialNumberInOutputAllowed: Promise<boolean>;
    readonly bigVolumeLimit: Promise<decimal | null>;
    readonly isDynamicPickingAllowed: Promise<boolean>;
    readonly isMultiplePickingAllowed: Promise<boolean>;
    readonly isDeliveryOrderSinglePickingForMultiplePickingAllowed: Promise<boolean>;
    readonly isPriorityOutputToReplenishmentForMultiplePickingAllowed: Promise<boolean>;
    readonly isSingleAddressReplenishmentForMultiplePickingAllowed: Promise<boolean>;
    readonly isActive: Promise<boolean>;
    readonly siteDepositorIdentifier: Promise<string>;
    readonly isLocalizedSerialNumberAllowed: Promise<boolean>;
    readonly isMovementInHomogeneousContainerForReserveOutputAuthorizedRuleAllowed: Promise<boolean>;
    readonly outputsPriority: Collection<sageWhProductData.nodes.OutputModeOutputsPriority>;
    readonly pickingsPriority: Collection<sageWhProductData.nodes.OutputModePickingsPriority>;
    readonly replenishmentsPriority: Collection<sageWhProductData.nodes.OutputModeReplenishmentsPriority>;
    readonly replenishmentsPrioritySorting: Collection<sageWhProductData.nodes.OutputModeReplenishmentsPrioritySorting>;
}
//# sourceMappingURL=output-mode.d.ts.map