"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhProductData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        containerType: {
            site: 'site',
            code: 'containerType',
        },
        parcelRangeShippedAsIsStandard: {
            site: 'site',
            code: 'parcelRangeShippedAsIsStandard',
        },
        parcelTypeShippedAsIsStandard: {
            site: 'site',
            parcelRange: 'parcelRangeShippedAsIsStandard',
            code: 'parcelTypeShippedAsIsStandard',
        },
        parcelRangeShippedAsIsNonStandard: {
            site: 'site',
            code: 'parcelRangeShippedAsIsNonStandard',
        },
        parcelTypeShippedAsIsNonStandard: {
            site: 'site',
            parcelRange: 'parcelRangeShippedAsIsNonStandard',
            code: 'parcelTypeShippedAsIsNonStandard',
        },
        shippingUnitDispatchableAsIs: {
            site: 'site',
            code: 'shippingUnitDispatchableAsIs',
        },
    },
};
let Container = class Container extends xtrem_core_1.Node {
};
exports.Container = Container;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Container.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'COD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Container.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ContainersType,
        lookupAccess: true,
    })
], Container.prototype, "containerType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LVL',
        dataType: () => sageWhMasterData.enums.containerLevelDatatype,
        lookupAccess: true,
    })
], Container.prototype, "containerLevel", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], Container.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        lookupAccess: true,
    })
], Container.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "height", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "width", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DTH',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "depth", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSTPRAST1',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RangeOfParcel,
        lookupAccess: true,
    })
], Container.prototype, "parcelRangeShippedAsIsStandard", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSTPTYST1',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ParcelType,
        lookupAccess: true,
    })
], Container.prototype, "parcelTypeShippedAsIsStandard", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSTPRAST2',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.RangeOfParcel,
        lookupAccess: true,
    })
], Container.prototype, "parcelRangeShippedAsIsNonStandard", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSTPTYST2',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ParcelType,
        lookupAccess: true,
    })
], Container.prototype, "parcelTypeShippedAsIsNonStandard", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSTSHU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.ShippingUnitType,
        lookupAccess: true,
    })
], Container.prototype, "shippingUnitDispatchableAsIs", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USTFLG',
        lookupAccess: true,
    })
], Container.prototype, "isShippingUnitPalettizableAsIs", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAXQTY',
        lookupAccess: true,
    })
], Container.prototype, "maximumQuantityAllowedInInputOutput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBSHEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "palletBaseHeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBSWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "palletBaseGrossWeight", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
        lookupAccess: true,
    })
], Container.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRTYP',
        dataType: () => sageWhMasterData.enums.containerManagementTypeDatatype,
        lookupAccess: true,
    })
], Container.prototype, "containerManagementType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UNTWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "unitWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UNTVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], Container.prototype, "unitVolume", void 0);
exports.Container = Container = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CONTAINER',
        keyPropertyNames: ['site', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Container);
//# sourceMappingURL=container.js.map